/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ws.http.request.run;

import com.intellij.execution.DefaultExecutionResult;
import com.intellij.execution.ExecutionResult;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.impl.ConsoleViewImpl;
import com.intellij.execution.impl.ConsoleViewUtil;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.ide.scratch.ScratchUtil;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.ws.http.request.psi.HttpRequest;
import com.intellij.ws.http.request.run.HttpPhysicalResponseProcessor;
import com.intellij.ws.http.request.run.HttpRequestHistoryManager;
import com.intellij.ws.http.request.run.HttpScratchResponseProcessor;
import com.intellij.ws.rest.client.RestClientControllerImpl;
import com.intellij.ws.rest.client.RestClientFileUtil;
import com.intellij.ws.rest.client.RestClientRequest;
import com.intellij.ws.rest.client.RestClientRequestProcessor;
import com.intellij.ws.rest.client.RestClientResponse;
import com.intellij.ws.rest.client.RestClientResponseListener;
import java.io.OutputStream;
import java.util.Collection;
import org.apache.http.client.CookieStore;
import org.apache.http.cookie.Cookie;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class RunHttpRequestProfileState
implements RunProfileState {
    private Project myProject;
    private final RestClientRequest myRequest;
    private final HttpRequest myPsiRequest;

    public RunHttpRequestProfileState(@NotNull Project project, @NotNull RestClientRequest request, @NotNull HttpRequest psiRequest) {
        if (project == null) {
            RunHttpRequestProfileState.$$$reportNull$$$0(0);
        }
        if (request == null) {
            RunHttpRequestProfileState.$$$reportNull$$$0(1);
        }
        if (psiRequest == null) {
            RunHttpRequestProfileState.$$$reportNull$$$0(2);
        }
        this.myProject = project;
        this.myRequest = request;
        this.myPsiRequest = psiRequest;
    }

    @Nullable
    public ExecutionResult execute(Executor executor, @NotNull ProgramRunner runner) {
        if (runner == null) {
            RunHttpRequestProfileState.$$$reportNull$$$0(3);
        }
        HttpRequestProcessHandler processHandler = new HttpRequestProcessHandler();
        ConsoleViewImpl console = new ConsoleViewImpl(this.myProject, true);
        console.attachToProcess((ProcessHandler)processHandler);
        this.executeHttpRequest(this.myProject, processHandler, (ConsoleView)console);
        return new DefaultExecutionResult((ExecutionConsole)console, (ProcessHandler)processHandler);
    }

    private void executeHttpRequest(@NotNull Project project, final @NotNull ProcessHandler processHandler, final @NotNull ConsoleView console) {
        if (project == null) {
            RunHttpRequestProfileState.$$$reportNull$$$0(4);
        }
        if (processHandler == null) {
            RunHttpRequestProfileState.$$$reportNull$$$0(5);
        }
        if (console == null) {
            RunHttpRequestProfileState.$$$reportNull$$$0(6);
        }
        RestClientControllerImpl controller = new RestClientControllerImpl(project){

            @Override
            protected void addToHistory(@NotNull Project project, @NotNull RestClientRequest request, @Nullable RestClientResponse response) {
                PsiFile file;
                if (project == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (request == null) {
                    1.$$$reportNull$$$0(1);
                }
                HttpPhysicalResponseProcessor processor = (file = RunHttpRequestProfileState.this.myPsiRequest.getContainingFile()) != null && ScratchUtil.isScratch((VirtualFile)file.getVirtualFile()) ? new HttpScratchResponseProcessor(RunHttpRequestProfileState.this.myPsiRequest) : new HttpPhysicalResponseProcessor(RunHttpRequestProfileState.this.myPsiRequest);
                HttpRequestHistoryManager.getInstance(project).addToHistory(request, response, processor);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "project";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "request";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/ws/http/request/run/RunHttpRequestProfileState$1";
                objectArray[2] = "addToHistory";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        processHandler.notifyTextAvailable(this.myRequest.httpMethod + " " + this.myRequest.toString() + "\n\n", ProcessOutputTypes.SYSTEM);
        controller.onGoButtonClick(this.myRequest, new RestClientResponseListener(){

            @Override
            public void setResponseHeader(String header) {
                if (StringUtil.isNotEmpty((String)header)) {
                    processHandler.notifyTextAvailable(header + "\n", ProcessOutputTypes.SYSTEM);
                }
            }

            @Override
            public void setErrorResponse(String response) {
                if (StringUtil.isNotEmpty((String)response)) {
                    processHandler.notifyTextAvailable(response, ProcessOutputTypes.STDERR);
                }
            }

            @Override
            public void setResponse(String response, @Nullable String mimeType) {
                if (StringUtil.isNotEmpty((String)response)) {
                    FileType fileType = RestClientFileUtil.findFileType(mimeType);
                    ConsoleViewUtil.printAsFileType((ConsoleView)console, (String)response, (FileType)fileType);
                }
            }

            @Override
            public void setStatus(String status) {
                if (StringUtil.isNotEmpty((String)status)) {
                    processHandler.notifyTextAvailable("\n\n" + status, ProcessOutputTypes.SYSTEM);
                }
            }

            @Override
            public void setCookies(Collection<Cookie> cookies) {
            }
        }, new RestClientRequestProcessor(){

            @Override
            public void preProcessRequest(@NotNull RestClientRequest request) {
                if (request == null) {
                    3.$$$reportNull$$$0(0);
                }
            }

            @Override
            public void postProcessRequest(@NotNull RestClientRequest request, @NotNull CookieStore store) {
                if (request == null) {
                    3.$$$reportNull$$$0(1);
                }
                if (store == null) {
                    3.$$$reportNull$$$0(2);
                }
                if (!processHandler.isProcessTerminated() && !processHandler.isProcessTerminating()) {
                    processHandler.detachProcess();
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "request";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "store";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/ws/http/request/run/RunHttpRequestProfileState$3";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "preProcessRequest";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "postProcessRequest";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "request";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiRequest";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runner";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processHandler";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "console";
                break;
            }
        }
        objectArray2[1] = "com/intellij/ws/http/request/run/RunHttpRequestProfileState";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "execute";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "executeHttpRequest";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class HttpRequestProcessHandler
    extends ProcessHandler {
        private HttpRequestProcessHandler() {
        }

        protected void destroyProcessImpl() {
            this.notifyProcessTerminated(0);
        }

        protected void detachProcessImpl() {
            this.notifyProcessDetached();
        }

        public boolean detachIsDefault() {
            return true;
        }

        public OutputStream getProcessInput() {
            return null;
        }
    }
}

