/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.j2ee.appServerIntegrations.impl;

import com.intellij.framework.FrameworkType;
import com.intellij.framework.impl.FrameworkTypeUtil;
import com.intellij.j2ee.appServerIntegrations.ApplicationServersConfigurable;
import com.intellij.j2ee.appServerIntegrations.impl.AppServersLibraryTable;
import com.intellij.j2ee.appServerIntegrations.impl.ApplicationServerImpl;
import com.intellij.javaee.J2EEBundle;
import com.intellij.javaee.appServerIntegrations.AppServerIntegration;
import com.intellij.javaee.appServerIntegrations.ApplicationServer;
import com.intellij.javaee.appServerIntegrations.ApplicationServerHelper;
import com.intellij.javaee.appServerIntegrations.ApplicationServerInfo;
import com.intellij.javaee.appServerIntegrations.ApplicationServerPersistentData;
import com.intellij.javaee.appServerIntegrations.CantFindApplicationServerJarsException;
import com.intellij.javaee.appServers.library.AppServerFrameworkLibraryProperties;
import com.intellij.javaee.appServers.library.AppServerFrameworkLibraryType;
import com.intellij.javaee.serverInstances.ApplicationServersManager;
import com.intellij.javaee.serverInstances.ApplicationServersManagerListener;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.components.ApplicationComponent;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.impl.libraries.LibraryEx;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryProperties;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.roots.libraries.LibraryTablePresentation;
import com.intellij.openapi.roots.libraries.LibraryTablesRegistrar;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMExternalizable;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.util.EventDispatcher;
import com.intellij.util.Function;
import com.intellij.util.NullableFunction;
import com.intellij.util.text.UniqueNameGenerator;
import java.awt.Component;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EventListener;
import java.util.List;
import java.util.Map;
import javax.swing.JPanel;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="AppserversManager", storages={@Storage(value="javaeeAppServers.xml", roamingType=RoamingType.DISABLED), @Storage(value="other.xml", deprecated=true)})
public class ApplicationServersManagerImpl
extends ApplicationServersManager
implements Disposable,
PersistentStateComponent<Element>,
ApplicationComponent {
    private static final Logger LOG = Logger.getInstance(ApplicationServersManagerImpl.class);
    private static final String LIBRARY_TABLE_ELEMENT_NAME = "LibraryTable";
    private static final String ATTRIBUTE_NAME = "NAME";
    private static final String SERVER_DK_ELEMENT = "ServerDK";
    public static final LibraryTablePresentation APP_SERVER_LIBRARY_TABLE_PRESENTATION = new LibraryTablePresentation(){

        public String getDisplayName(boolean plural) {
            return J2EEBundle.message((String)"appserver.library.display.name", (Object[])new Object[]{plural ? 2 : 1});
        }

        public String getDescription() {
            return J2EEBundle.message((String)"libraries.node.text.application.server", (Object[])new Object[0]);
        }

        public String getLibraryTableEditorTitle() {
            return J2EEBundle.message((String)"library.configure.appserver.title", (Object[])new Object[0]);
        }
    };
    private final List<ApplicationServer> myServerDKs = new ArrayList<ApplicationServer>();
    private final EventDispatcher<ApplicationServersManagerListener> myDispatcher = EventDispatcher.create(ApplicationServersManagerListener.class);
    private final AppServersLibraryTable myLibraryTable = new AppServersLibraryTable();
    private final List<Element> myUnresolvedServerElements = new ArrayList<Element>();

    public ApplicationServersManagerImpl(LibraryTablesRegistrar libraryTablesRegistrar) {
        libraryTablesRegistrar.registerLibraryTable((LibraryTable)this.myLibraryTable);
        Disposer.register((Disposable)this, (Disposable)this.myLibraryTable);
    }

    public ApplicationServer createServer(AppServerIntegration integration, ApplicationServerPersistentData serverData) {
        ApplicationServersManager serversManager = ApplicationServersManagerImpl.getInstance();
        final ApplicationServersManager.ApplicationServersManagerModifiableModel model = serversManager.createModifiableModel();
        ApplicationServerInfo serverInfo = null;
        try {
            ApplicationServerHelper helper = integration.getApplicationServerHelper();
            if (helper != null) {
                serverInfo = helper.getApplicationServerInfo(serverData);
            }
        }
        catch (CantFindApplicationServerJarsException e) {
            LOG.info((Throwable)e);
        }
        UniqueNameGenerator generator = new UniqueNameGenerator((Collection)serversManager.getApplicationServers(), (Function)((NullableFunction)o -> o.getName()));
        String defaultName = serverInfo != null ? serverInfo.getDefaultName() : integration.getPresentableName();
        String name = generator.generateUniqueName(defaultName);
        File[] libraries = serverInfo != null ? serverInfo.getDefaultLibraries() : new File[]{};
        ApplicationServer server = model.createNewApplicationServer(name, libraries, serverData);
        server.setSourceIntegrationName(integration.getPresentableName());
        new WriteAction(){

            protected void run(@NotNull Result result) {
                if (result == null) {
                    2.$$$reportNull$$$0(0);
                }
                model.commit();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/j2ee/appServerIntegrations/impl/ApplicationServersManagerImpl$2", "run"));
            }
        }.execute();
        return server;
    }

    public void initComponent() {
        this.myLibraryTable.addListener(new ApplicationServersLibraryTableListener(), this);
    }

    public void dispose() {
    }

    @Nullable
    public Element getState() {
        Element element = new Element("state");
        Element libraryTableElement = new Element(LIBRARY_TABLE_ELEMENT_NAME);
        try {
            this.myLibraryTable.writeExternal(libraryTableElement);
            for (ApplicationServer applicationServer : this.getApplicationServers()) {
                Element serverDKElement = new Element(SERVER_DK_ELEMENT);
                serverDKElement.setAttribute(ATTRIBUTE_NAME, applicationServer.getName());
                ((JDOMExternalizable)applicationServer).writeExternal(serverDKElement);
                element.addContent(serverDKElement);
            }
        }
        catch (WriteExternalException e) {
            LOG.error((Throwable)e);
            return null;
        }
        if (!JDOMUtil.isEmpty((Element)libraryTableElement)) {
            element.addContent(libraryTableElement);
        }
        for (Element serverElement : this.myUnresolvedServerElements) {
            element.addContent(serverElement.clone());
        }
        return element;
    }

    public void loadState(Element element) {
        this.myServerDKs.clear();
        Element libraryTableElement = element.getChild(LIBRARY_TABLE_ELEMENT_NAME);
        if (libraryTableElement != null) {
            Disposer.dispose((Disposable)this.myLibraryTable);
            Disposer.register((Disposable)this, (Disposable)this.myLibraryTable);
            try {
                this.myLibraryTable.readExternal(libraryTableElement);
            }
            catch (InvalidDataException e) {
                LOG.error((Throwable)e);
            }
        }
        List serverDKElements = element.getChildren(SERVER_DK_ELEMENT);
        ArrayList<Library> unknownLibraries = new ArrayList<Library>(Arrays.asList(this.myLibraryTable.getLibraries()));
        Map frameworkTypes = FrameworkTypeUtil.computeFrameworkTypeByIdMap();
        for (Element serverElement : serverDKElements) {
            Library library;
            String name = serverElement.getAttributeValue(ATTRIBUTE_NAME);
            if (name == null || (library = this.myLibraryTable.getLibraryByName(name)) == null) continue;
            unknownLibraries.remove(library);
            ApplicationServerImpl server = new ApplicationServerImpl(library, null);
            List<Pair<Library, AppServerFrameworkLibraryProperties>> frameworkLibraries = this.myLibraryTable.getApplicationServerFrameworkLibraries(name);
            for (Pair<Library, AppServerFrameworkLibraryProperties> pair : frameworkLibraries) {
                FrameworkType type = (FrameworkType)frameworkTypes.get(((AppServerFrameworkLibraryProperties)((Object)pair.getSecond())).getFrameworkTypeId());
                if (type == null) continue;
                Library frameworkLibrary = (Library)pair.getFirst();
                unknownLibraries.remove(frameworkLibrary);
                server.addFrameworkLibrary(type, frameworkLibrary);
            }
            try {
                server.readExternal(serverElement);
                this.myServerDKs.add(server);
            }
            catch (InvalidDataException ignored) {
                this.myUnresolvedServerElements.add(serverElement.clone());
            }
        }
    }

    public List<ApplicationServer> getApplicationServers() {
        return this.myServerDKs;
    }

    public List<ApplicationServer> getApplicationServers(AppServerIntegration[] integrations) {
        return this.filter(integrations, this.getApplicationServers());
    }

    private List<ApplicationServer> filter(AppServerIntegration[] integrations, List<ApplicationServer> servers) {
        ArrayList<ApplicationServer> result = new ArrayList<ApplicationServer>();
        for (AppServerIntegration integration : integrations) {
            result.addAll(ApplicationServersManagerImpl.filter(integration, servers));
        }
        return this.resort(result);
    }

    private List<ApplicationServer> resort(List<ApplicationServer> result) {
        Collections.sort(result, (applicationServer, applicationServer1) -> this.myServerDKs.indexOf(applicationServer1) - this.myServerDKs.indexOf(applicationServer));
        return result;
    }

    private static List<ApplicationServer> filter(AppServerIntegration integration, List<ApplicationServer> servers) {
        ArrayList<ApplicationServer> result = new ArrayList<ApplicationServer>();
        for (ApplicationServer server : servers) {
            if (server.getSourceIntegration() != integration) continue;
            result.add(server);
        }
        return result;
    }

    @Nullable
    public ApplicationServer findByName(String name) {
        if (name == null) {
            return null;
        }
        List<ApplicationServer> serverDKs = this.getApplicationServers();
        for (ApplicationServer applicationServer : serverDKs) {
            if (!Comparing.equal((String)name, (String)applicationServer.getName())) continue;
            return applicationServer;
        }
        return null;
    }

    public ApplicationServer findByName(String name, @NotNull AppServerIntegration integration) {
        if (integration == null) {
            ApplicationServersManagerImpl.$$$reportNull$$$0(0);
        }
        if (name == null) {
            return null;
        }
        for (ApplicationServer server : this.getApplicationServers()) {
            if (server.getSourceIntegration() != integration || !name.equals(server.getName())) continue;
            return server;
        }
        return null;
    }

    @Nullable
    public ApplicationServer editApplicationServers(JPanel panel, AppServerIntegration integration, ApplicationServer current) {
        ApplicationServersConfigurable configurable = ApplicationServersConfigurable.createConfigurable(integration, current);
        if (ShowSettingsUtil.getInstance().editConfigurable((Component)panel, configurable.getDimensionServiceKey(), (Configurable)configurable)) {
            return configurable.getSelectedApplicationServer();
        }
        return null;
    }

    @Nullable
    public ApplicationServer getDefaultFor(AppServerIntegration integration) {
        List<ApplicationServer> servers = this.getApplicationServers();
        for (ApplicationServer server : servers) {
            if (server.getSourceIntegration() != integration) continue;
            return server;
        }
        return null;
    }

    public void addServersListener(ApplicationServersManagerListener listener) {
        this.myDispatcher.addListener((EventListener)listener);
    }

    public void removeServersListener(ApplicationServersManagerListener listener) {
        this.myDispatcher.removeListener((EventListener)listener);
    }

    public LibraryTable getLibraryTable() {
        return this.myLibraryTable;
    }

    public ApplicationServersManager.ApplicationServersManagerModifiableModel createModifiableModel() {
        return new ApplicationServersManagerModifiableModelImpl();
    }

    @Nullable
    private ApplicationServer findServerByLibrary(@NotNull Library library) {
        ApplicationServer server;
        if (library == null) {
            ApplicationServersManagerImpl.$$$reportNull$$$0(1);
        }
        if ((server = this.findByName(library.getName())) != null && library.equals(server.getLibrary())) {
            return server;
        }
        return null;
    }

    public static String getFrameworkLibraryName(ApplicationServer server, FrameworkType type) {
        return server.getName() + " - " + type.getPresentableName();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "integration";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "library";
                break;
            }
        }
        objectArray2[1] = "com/intellij/j2ee/appServerIntegrations/impl/ApplicationServersManagerImpl";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "findByName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "findServerByLibrary";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private class ApplicationServersLibraryTableListener
    implements LibraryTable.Listener {
        private ApplicationServersLibraryTableListener() {
        }

        public void afterLibraryAdded(@NotNull Library newLibrary) {
            ApplicationServer server;
            if (newLibrary == null) {
                ApplicationServersLibraryTableListener.$$$reportNull$$$0(0);
            }
            if ((server = ApplicationServersManagerImpl.this.findServerByLibrary(newLibrary)) != null) {
                ((ApplicationServersManagerListener)ApplicationServersManagerImpl.this.myDispatcher.getMulticaster()).serverAdded(server);
            }
        }

        public void afterLibraryRenamed(@NotNull Library library) {
            ApplicationServer server;
            if (library == null) {
                ApplicationServersLibraryTableListener.$$$reportNull$$$0(1);
            }
            if ((server = ApplicationServersManagerImpl.this.findServerByLibrary(library)) != null) {
                ((ApplicationServersManagerListener)ApplicationServersManagerImpl.this.myDispatcher.getMulticaster()).serverRenamed(server);
            }
        }

        public void afterLibraryRemoved(@NotNull Library library) {
            ApplicationServer server;
            if (library == null) {
                ApplicationServersLibraryTableListener.$$$reportNull$$$0(2);
            }
            if ((server = ApplicationServersManagerImpl.this.findServerByLibrary(library)) != null) {
                ((ApplicationServersManagerListener)ApplicationServersManagerImpl.this.myDispatcher.getMulticaster()).serverRemoved(server);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "newLibrary";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "library";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/j2ee/appServerIntegrations/impl/ApplicationServersManagerImpl$ApplicationServersLibraryTableListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "afterLibraryAdded";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "afterLibraryRenamed";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "afterLibraryRemoved";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    class ApplicationServersManagerModifiableModelImpl
    implements ApplicationServersManager.ApplicationServersManagerModifiableModel {
        private final LibraryTable.ModifiableModel myModifiableModel;
        private final List<ApplicationServer> myAdded = new ArrayList<ApplicationServer>();
        private final List<ApplicationServer> myDeleted = new ArrayList<ApplicationServer>();

        public ApplicationServersManagerModifiableModelImpl() {
            this.myModifiableModel = ApplicationServersManagerImpl.this.myLibraryTable.getModifiableModel();
        }

        public List<ApplicationServer> getCurrentList(AppServerIntegration[] integrations) {
            ArrayList<ApplicationServer> result = new ArrayList<ApplicationServer>(ApplicationServersManagerImpl.this.myServerDKs);
            result.removeAll(this.myDeleted);
            result.addAll(this.myAdded);
            return ApplicationServersManagerImpl.this.filter(integrations, result);
        }

        public ApplicationServerImpl createNewApplicationServer(String name, File[] defaultLibraries, ApplicationServerPersistentData persistentData) {
            Library library = this.myModifiableModel.createLibrary(name);
            if (defaultLibraries != null && defaultLibraries.length > 0) {
                Library.ModifiableModel modifiableModel = library.getModifiableModel();
                for (File defaultLibrary : defaultLibraries) {
                    String url = VfsUtil.getUrlForLibraryRoot((File)defaultLibrary);
                    if (!defaultLibrary.isDirectory() && !"jar".equals(VirtualFileManager.extractProtocol((String)url))) continue;
                    modifiableModel.addRoot(url, OrderRootType.CLASSES);
                }
                modifiableModel.commit();
            }
            ApplicationServerImpl result = new ApplicationServerImpl(library, persistentData);
            this.myAdded.add(result);
            return result;
        }

        public void deleteApplicationServer(ApplicationServer applicationServer) {
            if (this.myAdded.contains(applicationServer)) {
                this.myAdded.remove(applicationServer);
            } else {
                this.myDeleted.add(applicationServer);
            }
            this.myModifiableModel.removeLibrary(applicationServer.getLibrary());
            for (Library library : applicationServer.getFrameworkLibraries()) {
                this.myModifiableModel.removeLibrary(library);
            }
        }

        public void dispose() {
            for (ApplicationServer server : this.myAdded) {
                Disposer.dispose((Disposable)server.getLibrary());
                for (Library library : server.getFrameworkLibraries()) {
                    Disposer.dispose((Disposable)library);
                }
            }
        }

        public Library addFrameworkLibrary(@NotNull ApplicationServer server, @NotNull FrameworkType type, @NotNull List<File> files) {
            if (server == null) {
                ApplicationServersManagerModifiableModelImpl.$$$reportNull$$$0(0);
            }
            if (type == null) {
                ApplicationServersManagerModifiableModelImpl.$$$reportNull$$$0(1);
            }
            if (files == null) {
                ApplicationServersManagerModifiableModelImpl.$$$reportNull$$$0(2);
            }
            if (!this.getFrameworkLibraries(server, type).isEmpty()) {
                return null;
            }
            Library library = this.myModifiableModel.createLibrary(ApplicationServersManagerImpl.getFrameworkLibraryName(server, type), AppServerFrameworkLibraryType.LIBRARY_KIND);
            LibraryEx.ModifiableModelEx modifiableModel = (LibraryEx.ModifiableModelEx)library.getModifiableModel();
            modifiableModel.setProperties((LibraryProperties)new AppServerFrameworkLibraryProperties(type.getId(), server.getName()));
            for (File file : files) {
                modifiableModel.addRoot(VfsUtil.getUrlForLibraryRoot((File)file), OrderRootType.CLASSES);
            }
            modifiableModel.commit();
            ((ApplicationServerImpl)server).addFrameworkLibrary(type, library);
            return library;
        }

        public void removeFrameworkLibrary(@NotNull ApplicationServer server, @NotNull FrameworkType type) {
            if (server == null) {
                ApplicationServersManagerModifiableModelImpl.$$$reportNull$$$0(3);
            }
            if (type == null) {
                ApplicationServersManagerModifiableModelImpl.$$$reportNull$$$0(4);
            }
            for (Library library : this.getFrameworkLibraries(server, type)) {
                this.myModifiableModel.removeLibrary(library);
                ((ApplicationServerImpl)server).removeFrameworkLibrary(type);
            }
        }

        private List<Library> getFrameworkLibraries(ApplicationServer server, FrameworkType type) {
            ArrayList<Library> toRemove = new ArrayList<Library>();
            List<Pair<Library, AppServerFrameworkLibraryProperties>> libraries = AppServersLibraryTable.getApplicationServerFrameworkLibraries(server.getName(), this.myModifiableModel.getLibraryIterator());
            for (Pair<Library, AppServerFrameworkLibraryProperties> pair : libraries) {
                if (!((AppServerFrameworkLibraryProperties)((Object)pair.getSecond())).getFrameworkTypeId().equals(type.getId())) continue;
                toRemove.add((Library)pair.getFirst());
            }
            return toRemove;
        }

        public void commit() {
            ApplicationServersManagerImpl.this.myServerDKs.removeAll(this.myDeleted);
            ApplicationServersManagerImpl.this.myServerDKs.addAll(this.myAdded);
            this.myModifiableModel.commit();
        }

        public Library getLibrary(ApplicationServer applicationServer) {
            return applicationServer.getLibrary();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "server";
                    break;
                }
                case 1: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "files";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/j2ee/appServerIntegrations/impl/ApplicationServersManagerImpl$ApplicationServersManagerModifiableModelImpl";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "addFrameworkLibrary";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "removeFrameworkLibrary";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

