/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.module.view.nodes;

import com.intellij.ide.DataManager;
import com.intellij.ide.impl.DataManagerImpl;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.javaee.module.view.nodes.JavaeeNodeDescriptor;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataConstants;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FileStatusManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.util.PsiUtilBase;
import java.awt.Color;
import javax.swing.Icon;

public abstract class PsiNamedElementNodeDescriptor<T extends PsiNamedElement>
extends JavaeeNodeDescriptor<T> {
    private final T myElement;

    protected PsiNamedElementNodeDescriptor(T element, NodeDescriptor parentDescriptor, Object parameters) {
        super(element.getProject(), parentDescriptor, parameters, element);
        this.myElement = element;
    }

    public Color getNewColor() {
        PsiNamedElement element = (PsiNamedElement)this.getElement();
        if (CopyPasteManager.getInstance().isCutElement((Object)element)) {
            return CopyPasteManager.CUT_COLOR;
        }
        VirtualFile file = PsiUtilBase.getVirtualFile((PsiElement)element);
        return file == null ? null : FileStatusManager.getInstance((Project)this.myProject).getStatus(file).getColor();
    }

    public T updateElement() {
        return this.myElement;
    }

    public Icon getNewIcon() {
        int flags = 2;
        PsiElement element = (PsiElement)this.getElement();
        if (ModuleUtil.isModuleDisposed((PsiElement)element)) {
            VirtualFile virtualFile = (VirtualFile)((DataManagerImpl)DataManager.getInstance()).getDataRule(DataConstants.VIRTUAL_FILE).getData((DataProvider)this);
            if (virtualFile == null) {
                return null;
            }
            FileType fileType = virtualFile.getFileType();
            return fileType.getIcon();
        }
        return element.getIcon(flags);
    }

    public String getNewNodeText() {
        return ((PsiNamedElement)this.getElement()).getName();
    }

    public Object getData(String dataId) {
        if (CommonDataKeys.PSI_ELEMENT.is(dataId)) {
            PsiNamedElement element = (PsiNamedElement)this.getElement();
            return element != null && element.isValid() ? element : null;
        }
        if (CommonDataKeys.NAVIGATABLE.is(dataId)) {
            PsiNamedElement element = (PsiNamedElement)this.getElement();
            return element instanceof Navigatable && element.isValid() ? element : null;
        }
        return super.getData(dataId);
    }

    public boolean isValid() {
        PsiNamedElement element = (PsiNamedElement)this.getElement();
        return element != null && element.isValid();
    }
}

