/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.ui.packaging;

import com.intellij.facet.FacetTypeId;
import com.intellij.jam.model.util.JamCommonUtil;
import com.intellij.javaee.application.JavaeeDescriptorUtil;
import com.intellij.javaee.application.facet.JavaeeApplicationFacet;
import com.intellij.javaee.facet.JavaeeFacet;
import com.intellij.javaee.model.xml.application.JavaeeApplication;
import com.intellij.javaee.ui.packaging.EarArtifactDependenciesChecker;
import com.intellij.javaee.ui.packaging.JavaeeArtifactTypeBase;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ui.configuration.artifacts.sourceItems.ModuleOutputSourceItem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.artifacts.ArtifactTemplate;
import com.intellij.packaging.elements.CompositePackagingElement;
import com.intellij.packaging.elements.PackagingElementOutputKind;
import com.intellij.packaging.elements.PackagingElementResolvingContext;
import com.intellij.packaging.impl.artifacts.ArtifactUtil;
import com.intellij.packaging.ui.ArtifactProblemsHolder;
import com.intellij.packaging.ui.PackagingSourceItem;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import icons.J2eeOpenapiIcons;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class JavaeeApplicationArtifactType
extends JavaeeArtifactTypeBase {
    public JavaeeApplicationArtifactType(@NonNls String id, String title, boolean isArchive) {
        super(id, title, isArchive, (FacetTypeId<? extends JavaeeFacet>)JavaeeApplicationFacet.ID);
    }

    @NotNull
    public Icon getIcon() {
        Icon icon = J2eeOpenapiIcons.Javaee_artifact;
        if (icon == null) {
            JavaeeApplicationArtifactType.$$$reportNull$$$0(0);
        }
        return icon;
    }

    @Nullable
    public String getDefaultPathFor(@NotNull PackagingSourceItem sourceItem) {
        if (sourceItem == null) {
            JavaeeApplicationArtifactType.$$$reportNull$$$0(1);
        }
        if (sourceItem instanceof ModuleOutputSourceItem) {
            return "/lib/" + ArtifactUtil.suggestArtifactFileName((String)((ModuleOutputSourceItem)sourceItem).getModule().getName()) + ".jar!/";
        }
        return super.getDefaultPathFor(sourceItem);
    }

    public String getDefaultPathFor(@NotNull PackagingElementOutputKind kind) {
        if (kind == null) {
            JavaeeApplicationArtifactType.$$$reportNull$$$0(2);
        }
        if (kind.containsJarFiles()) {
            return "/lib";
        }
        return "/";
    }

    @Override
    protected List<? extends ArtifactTemplate> getExplodedArtifactTemplates(PackagingElementResolvingContext context) {
        return Collections.emptyList();
    }

    public void checkRootElement(@NotNull CompositePackagingElement<?> rootElement, @NotNull Artifact artifact, @NotNull ArtifactProblemsHolder manager) {
        if (rootElement == null) {
            JavaeeApplicationArtifactType.$$$reportNull$$$0(3);
        }
        if (artifact == null) {
            JavaeeApplicationArtifactType.$$$reportNull$$$0(4);
        }
        if (manager == null) {
            JavaeeApplicationArtifactType.$$$reportNull$$$0(5);
        }
        JavaeeApplication javaeeAppDescriptor = this.checkDescriptor(rootElement, manager);
        EarArtifactDependenciesChecker checker = new EarArtifactDependenciesChecker(this, manager, javaeeAppDescriptor);
        checker.processEar(rootElement);
    }

    @Nullable
    private JavaeeApplication checkDescriptor(CompositePackagingElement<?> rootElement, ArtifactProblemsHolder manager) {
        VirtualFile file = this.findDescriptor(rootElement, manager, "META-INF/application.xml");
        if (file != null) {
            PsiFile psiFile;
            if (file.isDirectory()) {
                manager.registerError("'META-INF/application.xml' descriptor refers to directory rather than file", "application.xml-is-directory");
                return null;
            }
            Module module = (psiFile = PsiManager.getInstance((Project)manager.getContext().getProject()).findFile(file)) != null ? ModuleUtilCore.findModuleForPsiElement((PsiElement)psiFile) : null;
            JavaeeApplication root = (JavaeeApplication)JamCommonUtil.getRootElement((PsiFile)psiFile, JavaeeApplication.class, (Module)module);
            if (root != null && module != null) {
                JavaeeDescriptorUtil.checkDescriptor(root, rootElement, manager, this);
            }
            return root;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javaee/ui/packaging/JavaeeApplicationArtifactType";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceItem";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kind";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootElement";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "artifact";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getIcon";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javaee/ui/packaging/JavaeeApplicationArtifactType";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultPathFor";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "checkRootElement";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

