/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa;

import com.intellij.database.autoconfig.DataSourceDetector;
import com.intellij.database.model.DatabaseSystem;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbPsiFacade;
import com.intellij.facet.Facet;
import com.intellij.facet.FacetManager;
import com.intellij.facet.FacetTypeId;
import com.intellij.jpa.view.editor.PersistencePackageAsVirtualFileImpl;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.persistence.facet.PersistenceFacet;
import com.intellij.persistence.model.PersistencePackage;
import com.intellij.psi.PsiElement;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PairConsumer;
import com.intellij.util.xml.DomElement;
import java.util.Collection;
import java.util.Map;
import java.util.Properties;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public abstract class JpaDataSourceDetectorBase<F extends Facet>
extends DataSourceDetector {
    private final FacetTypeId<F> myFacetTypeId;

    protected JpaDataSourceDetectorBase(@NotNull FacetTypeId<F> facetTypeId) {
        if (facetTypeId == null) {
            JpaDataSourceDetectorBase.$$$reportNull$$$0(0);
        }
        this.myFacetTypeId = facetTypeId;
    }

    protected abstract Map<String, PairConsumer<DataSourceDetector.Builder, Properties>> getProviders();

    protected static PairConsumer<DataSourceDetector.Builder, Properties> provider(String urlProp, String userProp, String passwordProp, String driverProp) {
        return (builder, properties) -> {
            JpaDataSourceDetectorBase.collect(builder, DataSourceDetector.Property.URL, properties, urlProp);
            JpaDataSourceDetectorBase.collect(builder, DataSourceDetector.Property.USERNAME, properties, userProp);
            JpaDataSourceDetectorBase.collect(builder, DataSourceDetector.Property.PASSWORD, properties, passwordProp);
            JpaDataSourceDetectorBase.collect(builder, DataSourceDetector.Property.DRIVER_CLASS, properties, driverProp);
        };
    }

    private static void collect(@NotNull DataSourceDetector.Builder b, @NotNull DataSourceDetector.Property p, @NotNull Properties properties, @NonNls String keys) {
        if (b == null) {
            JpaDataSourceDetectorBase.$$$reportNull$$$0(1);
        }
        if (p == null) {
            JpaDataSourceDetectorBase.$$$reportNull$$$0(2);
        }
        if (properties == null) {
            JpaDataSourceDetectorBase.$$$reportNull$$$0(3);
        }
        for (String key : StringUtil.split((String)keys, (String)",", (boolean)true, (boolean)true)) {
            String property = properties.getProperty(key.trim());
            if (property == null) continue;
            b.with(p, property);
        }
    }

    public void collectDataSources(@NotNull Module module, @NotNull DataSourceDetector.Builder builder, boolean onTheFly) {
        if (module == null) {
            JpaDataSourceDetectorBase.$$$reportNull$$$0(4);
        }
        if (builder == null) {
            JpaDataSourceDetectorBase.$$$reportNull$$$0(5);
        }
        DbPsiFacade dbPsiFacade = DbPsiFacade.getInstance((Project)module.getProject());
        Collection facets = FacetManager.getInstance((Module)module).getFacetsByType(this.myFacetTypeId);
        for (Facet facet : facets) {
            for (PersistencePackage unit : ((PersistenceFacet)facet).getPersistenceUnits()) {
                PsiElement origin = unit instanceof DomElement ? ((DomElement)unit).getXmlElement() : unit.getIdentifyingPsiElement();
                String unitName = PersistencePackageAsVirtualFileImpl.getElementName(unit);
                DbDataSource existingDataSource = dbPsiFacade.findDataSource(((PersistenceFacet)facet).getDataSourceId(unit));
                String existingDataSourceName = existingDataSource == null ? null : existingDataSource.getName();
                DataSourceDetector.Callback callback = JpaDataSourceDetectorBase.newCallback((PersistenceFacet)facet, unit);
                Properties properties = unit.getModelHelper().getPersistenceUnitProperties();
                Map<String, PairConsumer<DataSourceDetector.Builder, Properties>> providers = this.getProviders();
                for (String provider : providers.keySet()) {
                    String dataSourceName = unitName + "/" + provider;
                    if (onTheFly && existingDataSourceName != null && !Comparing.equal((String)existingDataSourceName, (String)dataSourceName)) continue;
                    providers.get(provider).consume((Object)builder.withName(dataSourceName), (Object)properties);
                    builder.onCreate(callback).commit(provider, (Object)origin);
                }
            }
        }
    }

    @NotNull
    private static <F extends PersistenceFacet> DataSourceDetector.Callback newCallback(@NotNull F facet, @NotNull PersistencePackage unit) {
        if (facet == null) {
            JpaDataSourceDetectorBase.$$$reportNull$$$0(6);
        }
        if (unit == null) {
            JpaDataSourceDetectorBase.$$$reportNull$$$0(7);
        }
        final PersistencePackageAsVirtualFileImpl file = (PersistencePackageAsVirtualFileImpl)((Object)ObjectUtils.assertNotNull((Object)((Object)PersistencePackageAsVirtualFileImpl.findFile(unit, facet))));
        DataSourceDetector.Callback callback = new DataSourceDetector.Callback(){

            public void onCreated(@NotNull DatabaseSystem dataSource) {
                if (dataSource == null) {
                    1.$$$reportNull$$$0(0);
                }
                PersistenceFacet facet = (PersistenceFacet)ObjectUtils.tryCast(file.findFacet(), PersistenceFacet.class);
                PersistencePackage unit = file.findElement();
                if (unit != null && facet != null && facet.getDataSourceId(unit) == null) {
                    facet.setDataSourceId(unit, dataSource.getUniqueId());
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataSource", "com/intellij/jpa/JpaDataSourceDetectorBase$1", "onCreated"));
            }
        };
        if (callback == null) {
            JpaDataSourceDetectorBase.$$$reportNull$$$0(8);
        }
        return callback;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facetTypeId";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "b";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "p";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "properties";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facet";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "unit";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/jpa/JpaDataSourceDetectorBase";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/jpa/JpaDataSourceDetectorBase";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "newCallback";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "collect";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "collectDataSources";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "newCallback";
                break;
            }
            case 8: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

