/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.application.config;

import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.Annotator;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.DefaultLanguageHighlighterColors;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.JavaClassReference;
import com.intellij.spring.boot.application.config.SpringBootPlaceholderReference;
import com.intellij.spring.boot.application.config.hints.HintReferenceBase;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.containers.ContainerUtil;
import org.jetbrains.annotations.NotNull;

public abstract class SpringBootConfigFileAnnotatorBase
implements Annotator {
    private static final boolean DEBUG_MODE = ApplicationManager.getApplication().isUnitTestMode();

    protected abstract TextAttributesKey getPlaceholderTextAttributesKey();

    protected void annotateValue(@NotNull PsiElement element, @NotNull AnnotationHolder holder) {
        if (element == null) {
            SpringBootConfigFileAnnotatorBase.$$$reportNull$$$0(0);
        }
        if (holder == null) {
            SpringBootConfigFileAnnotatorBase.$$$reportNull$$$0(1);
        }
        int elementOffset = element.getNode().getStartOffset();
        Object[] references = element.getReferences();
        boolean highlightOnlyPlaceholders = ContainerUtil.findInstance((Object[])references, SpringBootPlaceholderReference.class) != null;
        for (Object reference : references) {
            TextAttributesKey key = null;
            if (highlightOnlyPlaceholders) {
                if (reference instanceof SpringBootPlaceholderReference) {
                    key = this.getPlaceholderTextAttributesKey();
                }
            } else if (reference instanceof JavaClassReference) {
                if (reference.resolve() != null) {
                    key = DefaultLanguageHighlighterColors.CLASS_REFERENCE;
                }
            } else if (reference instanceof HintReferenceBase) {
                key = ((HintReferenceBase)((Object)reference)).getTextAttributesKey();
            }
            if (key == null) continue;
            SpringBootConfigFileAnnotatorBase.doAnnotate(holder, reference.getRangeInElement().shiftRight(elementOffset), key);
        }
    }

    protected static void doAnnotate(AnnotationHolder holder, TextRange range, TextAttributesKey key) {
        String message = DEBUG_MODE ? key.getExternalName() : null;
        holder.createInfoAnnotation(range, message).setTextAttributes(key);
    }

    protected static void doAnnotateEnforced(AnnotationHolder holder, TextRange range, SimpleTextAttributes key, String debugMessage) {
        String message = DEBUG_MODE ? debugMessage : null;
        holder.createInfoAnnotation(range, message).setEnforcedTextAttributes(key.toTextAttributes());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "element";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "holder";
                break;
            }
        }
        objectArray[1] = "com/intellij/spring/boot/application/config/SpringBootConfigFileAnnotatorBase";
        objectArray[2] = "annotateValue";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

