/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.model.jam;

import com.intellij.jam.JamConverter;
import com.intellij.jam.JamStringAttributeElement;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLiteral;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.JavaClassReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.JavaClassReferenceProvider;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.JavaClassReferenceSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StringLiteralPsiClassConverter
extends JamConverter<PsiClass> {
    private static final JavaClassReferenceProvider JAVA_CLASS_REFERENCE_PROVIDER = new JavaClassReferenceProvider();

    @Nullable
    public PsiClass fromString(@Nullable String s, JamStringAttributeElement<PsiClass> context) {
        if (StringUtil.isEmptyOrSpaces((String)s)) {
            return null;
        }
        PsiAnnotationMemberValue psiElement = context.getPsiElement();
        if (psiElement == null) {
            return null;
        }
        return JavaPsiFacade.getInstance((Project)psiElement.getProject()).findClass(s, psiElement.getResolveScope());
    }

    @NotNull
    public PsiReference[] createReferences(JamStringAttributeElement<PsiClass> context) {
        PsiLiteral psiLiteral = context.getPsiLiteral();
        if (psiLiteral == null) {
            if (PsiReference.EMPTY_ARRAY == null) {
                StringLiteralPsiClassConverter.$$$reportNull$$$0(0);
            }
            return PsiReference.EMPTY_ARRAY;
        }
        String stringValue = context.getStringValue();
        if (stringValue == null) {
            if (PsiReference.EMPTY_ARRAY == null) {
                StringLiteralPsiClassConverter.$$$reportNull$$$0(1);
            }
            return PsiReference.EMPTY_ARRAY;
        }
        JavaClassReferenceSet set = new JavaClassReferenceSet(stringValue, (PsiElement)psiLiteral, ElementManipulators.getOffsetInElement((PsiElement)psiLiteral), false, JAVA_CLASS_REFERENCE_PROVIDER){

            public boolean isAllowDollarInNames() {
                return true;
            }
        };
        JavaClassReference[] javaClassReferenceArray = set.getAllReferences();
        if (javaClassReferenceArray == null) {
            StringLiteralPsiClassConverter.$$$reportNull$$$0(2);
        }
        return javaClassReferenceArray;
    }

    static {
        JAVA_CLASS_REFERENCE_PROVIDER.setOption(JavaClassReferenceProvider.ALLOW_DOLLAR_NAMES, (Object)Boolean.TRUE);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/boot/model/jam/StringLiteralPsiClassConverter", "createReferences"));
    }
}

