/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.klint.checks;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.tools.klint.detector.api.Category;
import com.android.tools.klint.detector.api.Detector;
import com.android.tools.klint.detector.api.Implementation;
import com.android.tools.klint.detector.api.Issue;
import com.android.tools.klint.detector.api.JavaContext;
import com.android.tools.klint.detector.api.Scope;
import com.android.tools.klint.detector.api.Severity;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.ULiteralExpression;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.visitor.UastVisitor;

public class NonInternationalizedSmsDetector
extends Detector
implements Detector.UastScanner {
    public static final Issue ISSUE = Issue.create("UnlocalizedSms", "SMS phone number missing country code", "SMS destination numbers must start with a country code or the application code must ensure that the SMS is only sent when the user is in the same country as the receiver.", Category.CORRECTNESS, 5, Severity.WARNING, new Implementation(NonInternationalizedSmsDetector.class, Scope.JAVA_FILE_SCOPE));

    @Override
    public List<String> getApplicableMethodNames() {
        ArrayList<String> methodNames = new ArrayList<String>(2);
        methodNames.add("sendTextMessage");
        methodNames.add("sendMultipartTextMessage");
        return methodNames;
    }

    @Override
    public void visitMethod(@NonNull JavaContext context, @Nullable UastVisitor visitor, @NonNull UCallExpression call, @NonNull UMethod method) {
        if (call.getReceiver() == null) {
            return;
        }
        List args = call.getValueArguments();
        if (args.size() != 5) {
            return;
        }
        UExpression destinationAddress = (UExpression)args.get(0);
        if (!(destinationAddress instanceof ULiteralExpression)) {
            return;
        }
        Object literal = ((ULiteralExpression)destinationAddress).getValue();
        if (!(literal instanceof String)) {
            return;
        }
        String number = (String)literal;
        if (number.startsWith("+")) {
            return;
        }
        context.report(ISSUE, (UElement)call, context.getUastLocation((UElement)destinationAddress), "To make sure the SMS can be sent by all users, please start the SMS number with a + and a country code or restrict the code invocation to people in the country you are targeting.");
    }
}

