/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.inspections.klint;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.builder.model.SourceProvider;
import com.android.tools.idea.AndroidPsiUtils;
import com.android.tools.idea.model.AndroidModel;
import com.android.tools.klint.client.api.LintRequest;
import com.android.tools.klint.detector.api.ClassContext;
import com.android.tools.klint.detector.api.Context;
import com.android.tools.klint.detector.api.DefaultPosition;
import com.android.tools.klint.detector.api.Issue;
import com.android.tools.klint.detector.api.Location;
import com.google.common.base.Splitter;
import com.intellij.debugger.engine.JVMNameUtil;
import com.intellij.ide.util.JavaAnonymousClassesHelper;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiAnnotationParameterList;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiArrayInitializerMemberValue;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiLiteral;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.ClassUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.TypeConversionUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.inspections.klint.IntellijLintRequest;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.uast.UAnnotated;
import org.jetbrains.uast.UAnnotation;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UFile;
import org.jetbrains.uast.ULiteralExpression;
import org.jetbrains.uast.UNamedExpression;
import org.jetbrains.uast.UastUtils;
import org.jetbrains.uast.psi.UElementWithLocation;
import org.jetbrains.uast.util.UastExpressionUtils;

public class IntellijLintUtils {
    @NonNls
    public static final String SUPPRESS_LINT_FQCN = "android.annotation.SuppressLint";
    @NonNls
    public static final String SUPPRESS_WARNINGS_FQCN = "java.lang.SuppressWarnings";

    private IntellijLintUtils() {
    }

    @NonNull
    public static Location getLocation(@NonNull File file, @NonNull PsiElement element) {
        PsiClass clz;
        PsiIdentifier nameIdentifier;
        assert (element.getContainingFile().getVirtualFile() == null || FileUtil.filesEqual((File)VfsUtilCore.virtualToIoFile((VirtualFile)element.getContainingFile().getVirtualFile()), (File)file));
        if (element instanceof PsiClass && (nameIdentifier = (clz = (PsiClass)element).getNameIdentifier()) != null) {
            element = nameIdentifier;
        }
        TextRange textRange = element.getTextRange();
        DefaultPosition start = new DefaultPosition(-1, -1, textRange.getStartOffset());
        DefaultPosition end = new DefaultPosition(-1, -1, textRange.getEndOffset());
        return Location.create(file, start, end);
    }

    @NonNull
    public static Location getUastLocation(@NonNull File file, @NonNull UElement element) {
        UClass clz;
        UElement nameIdentifier;
        PsiFile containingPsiFile = UastUtils.getContainingFile((UElement)element).getPsi();
        assert (containingPsiFile.getVirtualFile() == null || FileUtil.filesEqual((File)VfsUtilCore.virtualToIoFile((VirtualFile)containingPsiFile.getVirtualFile()), (File)file));
        if (element instanceof UClass && (nameIdentifier = (clz = (UClass)element).getUastAnchor()) != null) {
            element = nameIdentifier;
        }
        TextRange textRange = null;
        PsiElement psi = element.getPsi();
        if (psi != null) {
            textRange = psi.getTextRange();
        } else if (element instanceof UElementWithLocation) {
            UElementWithLocation elementWithLocation = (UElementWithLocation)element;
            textRange = new TextRange(elementWithLocation.getStartOffset(), elementWithLocation.getEndOffset());
        }
        if (textRange == null) {
            return Location.NONE;
        }
        DefaultPosition start = new DefaultPosition(-1, -1, textRange.getStartOffset());
        DefaultPosition end = new DefaultPosition(-1, -1, textRange.getEndOffset());
        return Location.create(file, start, end);
    }

    @Nullable
    public static PsiFile getPsiFile(@NonNull Context context) {
        VirtualFile file = VfsUtil.findFileByIoFile((File)context.file, (boolean)false);
        if (file == null) {
            return null;
        }
        LintRequest request = context.getDriver().getRequest();
        Project project = ((IntellijLintRequest)request).getProject();
        if (project.isDisposed()) {
            return null;
        }
        return AndroidPsiUtils.getPsiFileSafely((Project)project, (VirtualFile)file);
    }

    public static boolean isSuppressed(@NonNull PsiElement element, @NonNull PsiFile file, @NonNull Issue issue) {
        while (element != null && element != file) {
            PsiModifierListOwner owner;
            PsiModifierList modifierList;
            if (element instanceof PsiModifierListOwner && (modifierList = (owner = (PsiModifierListOwner)element).getModifierList()) != null) {
                for (PsiAnnotation annotation : modifierList.getAnnotations()) {
                    String fqcn = annotation.getQualifiedName();
                    if (fqcn == null || !fqcn.equals(SUPPRESS_LINT_FQCN) && !fqcn.equals(SUPPRESS_WARNINGS_FQCN)) continue;
                    PsiAnnotationParameterList parameterList = annotation.getParameterList();
                    for (PsiNameValuePair pair : parameterList.getAttributes()) {
                        String text;
                        PsiAnnotationMemberValue v = pair.getValue();
                        if (v instanceof PsiLiteral) {
                            PsiLiteral literal = (PsiLiteral)v;
                            Object value2 = literal.getValue();
                            if (!(value2 instanceof String) || !IntellijLintUtils.isSuppressed(issue, (String)value2)) continue;
                            return true;
                        }
                        if (v instanceof PsiArrayInitializerMemberValue) {
                            PsiArrayInitializerMemberValue mv = (PsiArrayInitializerMemberValue)v;
                            for (PsiAnnotationMemberValue mmv : mv.getInitializers()) {
                                PsiLiteral literal;
                                Object value3;
                                if (!(mmv instanceof PsiLiteral) || !((value3 = (literal = (PsiLiteral)mmv).getValue()) instanceof String) || !IntellijLintUtils.isSuppressed(issue, (String)value3)) continue;
                                return true;
                            }
                            continue;
                        }
                        if (v == null || (text = v.getText().trim()).isEmpty() || !IntellijLintUtils.isSuppressed(issue, text)) continue;
                        return true;
                    }
                }
            }
            element = element.getParent();
        }
        return false;
    }

    public static boolean isSuppressed(@NonNull UElement element, @NonNull UFile file, @NonNull Issue issue) {
        while (element != null && element != file) {
            if (element instanceof UAnnotated) {
                UAnnotated annotated = (UAnnotated)element;
                for (UAnnotation annotation : annotated.getAnnotations()) {
                    String fqcn = annotation.getQualifiedName();
                    if (fqcn == null || !fqcn.equals(SUPPRESS_LINT_FQCN) && !fqcn.equals(SUPPRESS_WARNINGS_FQCN)) continue;
                    List parameterList = annotation.getAttributeValues();
                    for (UNamedExpression pair : parameterList) {
                        UExpression v = pair.getExpression();
                        if (v instanceof ULiteralExpression) {
                            ULiteralExpression literal = (ULiteralExpression)v;
                            Object value2 = literal.getValue();
                            if (!(value2 instanceof String) || !IntellijLintUtils.isSuppressed(issue, (String)value2)) continue;
                            return true;
                        }
                        if (!UastExpressionUtils.isArrayInitializer((UElement)v)) continue;
                        UCallExpression mv = (UCallExpression)v;
                        for (UExpression mmv : mv.getValueArguments()) {
                            ULiteralExpression literal;
                            Object value3;
                            if (!(mmv instanceof ULiteralExpression) || !((value3 = (literal = (ULiteralExpression)mmv).getValue()) instanceof String) || !IntellijLintUtils.isSuppressed(issue, (String)value3)) continue;
                            return true;
                        }
                    }
                }
            }
            element = element.getUastParent();
        }
        return false;
    }

    private static boolean isSuppressed(@NonNull Issue issue, @NonNull String string) {
        for (String id : Splitter.on((char)',').trimResults().split((CharSequence)string)) {
            if (!id.equals(issue.getId()) && !id.equals("all")) continue;
            return true;
        }
        return false;
    }

    @NonNull
    public static String getInternalMethodName(@NonNull PsiMethod method) {
        if (method.isConstructor()) {
            return "<init>";
        }
        return method.getName();
    }

    @Nullable
    public static PsiElement getCallName(@NonNull PsiCallExpression expression2) {
        PsiElement lastChild;
        PsiElement firstChild = expression2.getFirstChild();
        if (firstChild != null && (lastChild = firstChild.getLastChild()) instanceof PsiIdentifier) {
            return lastChild;
        }
        return null;
    }

    @Nullable
    public static String getInternalName(@NonNull PsiClass psiClass) {
        PsiClass parent;
        if (psiClass instanceof PsiAnonymousClass && (parent = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)psiClass, PsiClass.class)) != null) {
            String internalName = IntellijLintUtils.getInternalName(parent);
            if (internalName == null) {
                return null;
            }
            return internalName + JavaAnonymousClassesHelper.getName((PsiAnonymousClass)((PsiAnonymousClass)psiClass));
        }
        String sig = ClassUtil.getJVMClassName((PsiClass)psiClass);
        if (sig == null) {
            String qualifiedName = psiClass.getQualifiedName();
            if (qualifiedName != null) {
                return ClassContext.getInternalName(qualifiedName);
            }
            return null;
        }
        if (sig.indexOf(46) != -1) {
            sig = ClassContext.getInternalName(sig);
        }
        return sig;
    }

    @Nullable
    public static String getInternalName(@NonNull PsiClassType psiClassType) {
        PsiClass resolved = psiClassType.resolve();
        if (resolved != null) {
            return IntellijLintUtils.getInternalName(resolved);
        }
        String className = psiClassType.getClassName();
        if (className != null) {
            return ClassContext.getInternalName(className);
        }
        return null;
    }

    @Nullable
    public static String getInternalDescription(@NonNull PsiMethod method, boolean includeName, boolean includeReturn) {
        assert (!includeName);
        assert (!includeReturn);
        StringBuilder signature = new StringBuilder();
        if (includeName) {
            if (method.isConstructor()) {
                PsiClass outerClass;
                PsiClass declaringClass = method.getContainingClass();
                if (declaringClass != null && (outerClass = declaringClass.getContainingClass()) != null && !declaringClass.hasModifierProperty("static") && !IntellijLintUtils.appendJvmTypeName(signature, outerClass)) {
                    return null;
                }
                signature.append("<init>");
            } else {
                signature.append(method.getName());
            }
        }
        signature.append('(');
        for (PsiParameter psiParameter : method.getParameterList().getParameters()) {
            if (IntellijLintUtils.appendJvmSignature(signature, psiParameter.getType())) continue;
            return null;
        }
        signature.append(')');
        if (includeReturn) {
            if (!method.isConstructor()) {
                if (!IntellijLintUtils.appendJvmSignature(signature, method.getReturnType())) {
                    return null;
                }
            } else {
                signature.append('V');
            }
        }
        return signature.toString();
    }

    private static boolean appendJvmTypeName(@NonNull StringBuilder signature, @NonNull PsiClass outerClass) {
        String className = IntellijLintUtils.getInternalName(outerClass);
        if (className == null) {
            return false;
        }
        signature.append('L').append(className.replace('.', '/')).append(';');
        return true;
    }

    private static boolean appendJvmSignature(@NonNull StringBuilder buffer, @Nullable PsiType type2) {
        if (type2 == null) {
            return false;
        }
        PsiType psiType = TypeConversionUtil.erasure((PsiType)type2);
        if (psiType instanceof PsiArrayType) {
            buffer.append('[');
            IntellijLintUtils.appendJvmSignature(buffer, ((PsiArrayType)psiType).getComponentType());
        } else if (psiType instanceof PsiClassType) {
            PsiClass resolved = ((PsiClassType)psiType).resolve();
            if (resolved == null) {
                return false;
            }
            if (!IntellijLintUtils.appendJvmTypeName(buffer, resolved)) {
                return false;
            }
        } else if (psiType instanceof PsiPrimitiveType) {
            buffer.append(JVMNameUtil.getPrimitiveSignature((String)psiType.getCanonicalText()));
        } else {
            return false;
        }
        return true;
    }

    @NotNull
    public static List<File> getResourceDirectories(@NotNull AndroidFacet facet) {
        AndroidModel androidModel;
        if (facet.requiresAndroidModel() && (androidModel = facet.getAndroidModel()) != null) {
            ArrayList<File> resDirectories = new ArrayList<File>();
            List sourceProviders = androidModel.getActiveSourceProviders();
            for (SourceProvider provider : sourceProviders) {
                for (File file : provider.getResDirectories()) {
                    if (!file.isDirectory()) continue;
                    resDirectories.add(file);
                }
            }
            return resDirectories;
        }
        return new ArrayList<File>(facet.getMainSourceProvider().getResDirectories());
    }
}

