/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.kapt.idea;

import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.Key;
import com.intellij.openapi.externalSystem.model.ProjectKeys;
import com.intellij.openapi.externalSystem.model.project.ContentRootData;
import com.intellij.openapi.externalSystem.model.project.ExternalSystemSourceType;
import com.intellij.openapi.externalSystem.model.project.LibraryData;
import com.intellij.openapi.externalSystem.model.project.LibraryDependencyData;
import com.intellij.openapi.externalSystem.model.project.LibraryLevel;
import com.intellij.openapi.externalSystem.model.project.LibraryPathType;
import com.intellij.openapi.externalSystem.model.project.ModuleData;
import java.io.File;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.tooling.model.idea.IdeaModule;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.framework.KotlinLibraryUtilKt;
import org.jetbrains.kotlin.kapt.idea.KaptGradleModel;
import org.jetbrains.kotlin.kapt.idea.KaptModelBuilderService;
import org.jetbrains.kotlin.kapt.idea.KaptSourceSetModel;
import org.jetbrains.plugins.gradle.model.data.GradleSourceSetData;
import org.jetbrains.plugins.gradle.service.project.AbstractProjectResolverExtension;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u0003\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\u0004H\u0016J\u0016\u0010\u0007\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\b0\u00050\u0004H\u0016J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u001e\u0010\r\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u001e\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u0015\u001a\u00020\u00162\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010H\u0016J\u0018\u0010\u0017\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0010*\b\u0012\u0004\u0012\u00020\u00110\u0010H\u0002J\"\u0010\u0018\u001a\n\u0012\u0004\u0012\u00020\u0019\u0018\u00010\u0010*\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\u001a\u001a\u00020\fH\u0002\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/kotlin/kapt/idea/KaptProjectResolverExtension;", "Lorg/jetbrains/plugins/gradle/service/project/AbstractProjectResolverExtension;", "()V", "getExtraProjectModelClasses", "", "Ljava/lang/Class;", "Lorg/jetbrains/kotlin/kapt/idea/KaptGradleModel;", "getToolingExtensionsClasses", "", "hasClassInClasspath", "", "name", "", "populateAndroidModuleModelIfNeeded", "", "ideModule", "Lcom/intellij/openapi/externalSystem/model/DataNode;", "Lcom/intellij/openapi/externalSystem/model/project/ModuleData;", "sourceSet", "Lorg/jetbrains/kotlin/kapt/idea/KaptSourceSetModel;", "populateModuleExtraModels", "gradleModule", "Lorg/gradle/tooling/model/idea/IdeaModule;", "findAndroidModuleModel", "findGradleSourceSet", "Lorg/jetbrains/plugins/gradle/model/data/GradleSourceSetData;", "sourceSetName", "kapt3-idea"})
public final class KaptProjectResolverExtension
extends AbstractProjectResolverExtension {
    @NotNull
    public Set<Class<KaptGradleModel>> getExtraProjectModelClasses() {
        return SetsKt.setOf(KaptGradleModel.class);
    }

    @NotNull
    public Set<Class<? extends Object>> getToolingExtensionsClasses() {
        return SetsKt.setOf((Object[])new Class[]{KaptModelBuilderService.class, Unit.class});
    }

    public void populateModuleExtraModels(@NotNull IdeaModule gradleModule, @NotNull DataNode<ModuleData> ideModule) {
        Intrinsics.checkParameterIsNotNull((Object)gradleModule, (String)"gradleModule");
        Intrinsics.checkParameterIsNotNull(ideModule, (String)"ideModule");
        KaptGradleModel kaptGradleModel = (KaptGradleModel)this.resolverCtx.getExtraProject(gradleModule, KaptGradleModel.class);
        if (kaptGradleModel == null) {
            return;
        }
        KaptGradleModel kaptModel = kaptGradleModel;
        if (kaptModel.isEnabled()) {
            for (KaptSourceSetModel sourceSet : kaptModel.getSourceSets()) {
                File it;
                File file;
                ExternalSystemSourceType sourceType;
                DataNode<GradleSourceSetData> sourceSetDataNode;
                this.populateAndroidModuleModelIfNeeded(ideModule, sourceSet);
                if (this.findGradleSourceSet(ideModule, sourceSet.getSourceSetName()) == null) {
                    continue;
                }
                Function2<String, ExternalSystemSourceType, Unit> addSourceSet$ = new Function2<String, ExternalSystemSourceType, Unit>(sourceSetDataNode){
                    final /* synthetic */ DataNode $sourceSetDataNode;

                    public final void invoke(@NotNull String path, @NotNull ExternalSystemSourceType type) {
                        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
                        Intrinsics.checkParameterIsNotNull((Object)type, (String)"type");
                        ContentRootData contentRootData = new ContentRootData(KotlinLibraryUtilKt.getGRADLE_SYSTEM_ID(), path);
                        contentRootData.storePath(type, path);
                        this.$sourceSetDataNode.createChild(ProjectKeys.CONTENT_ROOT, (Object)contentRootData);
                    }
                    {
                        this.$sourceSetDataNode = dataNode;
                        super(2);
                    }
                };
                ExternalSystemSourceType externalSystemSourceType = sourceType = sourceSet.isTest() ? ExternalSystemSourceType.TEST_GENERATED : ExternalSystemSourceType.SOURCE_GENERATED;
                if (sourceSet.getGeneratedSourcesDirFile() != null) {
                    it = file;
                    String string = it.getAbsolutePath();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"it.absolutePath");
                    addSourceSet$.invoke(string, sourceType);
                }
                if (sourceSet.getGeneratedKotlinSourcesDirFile() != null) {
                    it = file;
                    String string = it.getAbsolutePath();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"it.absolutePath");
                    addSourceSet$.invoke(string, sourceType);
                }
                if (sourceSet.getGeneratedClassesDirFile() != null) {
                    File generatedClassesDir = file;
                    LibraryData libraryData = new LibraryData(KotlinLibraryUtilKt.getGRADLE_SYSTEM_ID(), "");
                    libraryData.addPath(LibraryPathType.BINARY, generatedClassesDir.getAbsolutePath());
                    LibraryDependencyData libraryDependencyData = new LibraryDependencyData((ModuleData)sourceSetDataNode.getData(), libraryData, LibraryLevel.MODULE);
                    sourceSetDataNode.createChild(ProjectKeys.LIBRARY_DEPENDENCY, (Object)libraryDependencyData);
                }
            }
        }
        super.populateModuleExtraModels(gradleModule, ideModule);
    }

    private final void populateAndroidModuleModelIfNeeded(DataNode<ModuleData> ideModule, KaptSourceSetModel sourceSet) {
    }

    private final DataNode<?> findAndroidModuleModel(@NotNull DataNode<ModuleData> $receiver) {
        Object v3;
        String modelClassName;
        block2: {
            modelClassName = "com.android.tools.idea.gradle.project.model.AndroidModuleModel";
            Collection collection = $receiver.getChildren();
            Intrinsics.checkExpressionValueIsNotNull((Object)collection, (String)"children");
            Iterable $receiver$iv = collection;
            for (Object element$iv : $receiver$iv) {
                DataNode it;
                DataNode dataNode = it = (DataNode)element$iv;
                Intrinsics.checkExpressionValueIsNotNull((Object)dataNode, (String)"it");
                Key key = dataNode.getKey();
                Intrinsics.checkExpressionValueIsNotNull((Object)key, (String)"it.key");
                if (!Intrinsics.areEqual((Object)key.getDataType(), (Object)modelClassName)) continue;
                v3 = element$iv;
                break block2;
            }
            v3 = null;
        }
        DataNode dataNode = v3;
        if (dataNode == null) {
            return null;
        }
        DataNode node = dataNode;
        return !this.hasClassInClasspath(modelClassName) ? null : node;
    }

    private final boolean hasClassInClasspath(String name) {
        boolean bl;
        try {
            bl = Class.forName(name) != null;
        }
        catch (Throwable thr) {
            bl = false;
        }
        return bl;
    }

    private final DataNode<GradleSourceSetData> findGradleSourceSet(@NotNull DataNode<ModuleData> $receiver, String sourceSetName) {
        Object object = $receiver.getData();
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"data");
        String moduleName = ((ModuleData)object).getId();
        Iterator iterator = $receiver.getChildren().iterator();
        while (iterator.hasNext()) {
            GradleSourceSetData gradleSourceSetData;
            DataNode child;
            DataNode dataNode = child = (DataNode)iterator.next();
            Intrinsics.checkExpressionValueIsNotNull((Object)dataNode, (String)"child");
            Object object2 = dataNode.getData();
            if (!(object2 instanceof GradleSourceSetData)) {
                object2 = null;
            }
            if ((GradleSourceSetData)object2 == null) {
                continue;
            }
            if (!Intrinsics.areEqual((Object)gradleSourceSetData.getId(), (Object)("" + moduleName + ':' + sourceSetName))) continue;
            return child;
        }
        return null;
    }
}

