/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.application.metadata;

import com.intellij.codeInsight.completion.PrioritizedLookupElement;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.VolatileNotNullLazyValue;
import com.intellij.openapi.util.VolatileNullableLazyValue;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiType;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.spring.boot.application.metadata.RelaxedNames;
import com.intellij.spring.boot.application.metadata.SpringBootApplicationMetaConfigKey;
import com.intellij.spring.boot.application.metadata.SpringBootApplicationMetaConfigKeyLookupElementBuilder;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class SpringBootApplicationMetaConfigKeyImpl
implements SpringBootApplicationMetaConfigKey {
    private final SmartPsiElementPointer<PsiElement> myDeclaration;
    @NotNull
    private final SpringBootApplicationMetaConfigKey.DeclarationResolveResult myDeclarationResolveResult;
    private final String myName;
    private final SpringBootApplicationMetaConfigKey.DescriptionText myDescriptionText;
    private final String myDefaultValue;
    private final SpringBootApplicationMetaConfigKey.Deprecation myDeprecation;
    private final PsiType myType;
    private final SpringBootApplicationMetaConfigKey.ItemHint myItemHint;
    private final SpringBootApplicationMetaConfigKey.ItemHint myKeyItemHint;
    private final SpringBootApplicationMetaConfigKey.AccessType myAccessType;
    private final VolatileNullableLazyValue<PsiClass> myEffectiveValueClass;
    @Nullable
    private final PsiClass myMapKeyType;
    @Nullable
    private final PsiClassType myMapValueType;
    private final SpringBootApplicationMetaConfigKey.MetaConfigKeyPresentation myPresentation;
    private final VolatileNotNullLazyValue<RelaxedNames> myRelaxedNames;

    SpringBootApplicationMetaConfigKeyImpl(@NotNull PsiElement declaration, @NotNull SpringBootApplicationMetaConfigKey.DeclarationResolveResult declarationResolveResult, @NotNull String name, @NotNull SpringBootApplicationMetaConfigKey.DescriptionText descriptionText, @Nullable String defaultValue, @NotNull SpringBootApplicationMetaConfigKey.Deprecation deprecation, @Nullable PsiType type, @NotNull SpringBootApplicationMetaConfigKey.AccessType accessType, @NotNull SpringBootApplicationMetaConfigKey.ItemHint itemHint, @NotNull SpringBootApplicationMetaConfigKey.ItemHint keyItemHint) {
        if (declaration == null) {
            SpringBootApplicationMetaConfigKeyImpl.$$$reportNull$$$0(0);
        }
        if (declarationResolveResult == null) {
            SpringBootApplicationMetaConfigKeyImpl.$$$reportNull$$$0(1);
        }
        if (name == null) {
            SpringBootApplicationMetaConfigKeyImpl.$$$reportNull$$$0(2);
        }
        if (descriptionText == null) {
            SpringBootApplicationMetaConfigKeyImpl.$$$reportNull$$$0(3);
        }
        if (deprecation == null) {
            SpringBootApplicationMetaConfigKeyImpl.$$$reportNull$$$0(4);
        }
        if (accessType == null) {
            SpringBootApplicationMetaConfigKeyImpl.$$$reportNull$$$0(5);
        }
        if (itemHint == null) {
            SpringBootApplicationMetaConfigKeyImpl.$$$reportNull$$$0(6);
        }
        if (keyItemHint == null) {
            SpringBootApplicationMetaConfigKeyImpl.$$$reportNull$$$0(7);
        }
        this.myEffectiveValueClass = new VolatileNullableLazyValue<PsiClass>(){

            @Nullable
            protected PsiClass compute() {
                switch (SpringBootApplicationMetaConfigKeyImpl.this.myAccessType) {
                    case INDEXED: {
                        if (SpringBootApplicationMetaConfigKeyImpl.this.myType instanceof PsiArrayType) {
                            PsiArrayType arrayType = (PsiArrayType)SpringBootApplicationMetaConfigKeyImpl.this.myType;
                            return PsiTypesUtil.getPsiClass((PsiType)arrayType.getComponentType());
                        }
                        PsiType parameter = SpringBootApplicationMetaConfigKeyImpl.this.getParameter(0);
                        return PsiTypesUtil.getPsiClass((PsiType)parameter);
                    }
                    case MAP: 
                    case ENUM_MAP: {
                        return PsiTypesUtil.getPsiClass((PsiType)SpringBootApplicationMetaConfigKeyImpl.this.getMapValueType());
                    }
                }
                return PsiTypesUtil.getPsiClass((PsiType)SpringBootApplicationMetaConfigKeyImpl.this.myType);
            }
        };
        this.myPresentation = new SpringBootApplicationMetaConfigKey.MetaConfigKeyPresentation(){

            @NotNull
            public Icon getIcon() {
                switch (SpringBootApplicationMetaConfigKeyImpl.this.myAccessType) {
                    case INDEXED: {
                        Icon icon = AllIcons.Nodes.PropertyRead;
                        if (icon == null) {
                            2.$$$reportNull$$$0(0);
                        }
                        return icon;
                    }
                    case MAP: {
                        Icon icon = AllIcons.Nodes.PropertyWrite;
                        if (icon == null) {
                            2.$$$reportNull$$$0(1);
                        }
                        return icon;
                    }
                    case ENUM_MAP: {
                        Icon icon = AllIcons.Nodes.PropertyWriteStatic;
                        if (icon == null) {
                            2.$$$reportNull$$$0(2);
                        }
                        return icon;
                    }
                }
                Icon icon = AllIcons.Nodes.Property;
                if (icon == null) {
                    2.$$$reportNull$$$0(3);
                }
                return icon;
            }

            public LookupElementBuilder getLookupElement() {
                return this.getLookupElement(SpringBootApplicationMetaConfigKeyImpl.this.getName());
            }

            public LookupElementBuilder getLookupElement(String lookupString) {
                return SpringBootApplicationMetaConfigKeyLookupElementBuilder.create(SpringBootApplicationMetaConfigKeyImpl.this, lookupString);
            }

            public LookupElement tuneLookupElement(LookupElement lookupElement) {
                if (SpringBootApplicationMetaConfigKeyImpl.this.getDeprecation() != SpringBootApplicationMetaConfigKey.Deprecation.NOT_DEPRECATED) {
                    return PrioritizedLookupElement.withPriority((LookupElement)lookupElement, (double)-100.0);
                }
                if (SpringBootApplicationMetaConfigKeyImpl.this.getDeclarationResolveResult() == SpringBootApplicationMetaConfigKey.DeclarationResolveResult.JSON_UNRESOLVED_SOURCE_TYPE) {
                    return PrioritizedLookupElement.withPriority((LookupElement)lookupElement, (double)-50.0);
                }
                if (SpringBootApplicationMetaConfigKeyImpl.this.getDeclarationResolveResult() == SpringBootApplicationMetaConfigKey.DeclarationResolveResult.ADDITIONAL_JSON) {
                    return PrioritizedLookupElement.withPriority((LookupElement)lookupElement, (double)50.0);
                }
                return lookupElement;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/boot/application/metadata/SpringBootApplicationMetaConfigKeyImpl$2", "getIcon"));
            }
        };
        this.myRelaxedNames = new VolatileNotNullLazyValue<RelaxedNames>(){

            @NotNull
            protected RelaxedNames compute() {
                int lastDotIdx = SpringBootApplicationMetaConfigKeyImpl.this.myName.lastIndexOf(46);
                if (lastDotIdx == -1) {
                    RelaxedNames relaxedNames = new RelaxedNames(SpringBootApplicationMetaConfigKeyImpl.this.myName);
                    if (relaxedNames == null) {
                        3.$$$reportNull$$$0(0);
                    }
                    return relaxedNames;
                }
                String propertyName = RelaxedNames.dashedPropertyNameToCamelCase((String)SpringBootApplicationMetaConfigKeyImpl.this.myName);
                String replace = SpringBootApplicationMetaConfigKeyImpl.this.myName.substring(0, lastDotIdx + 1) + propertyName;
                RelaxedNames relaxedNames = new RelaxedNames(replace);
                if (relaxedNames == null) {
                    3.$$$reportNull$$$0(1);
                }
                return relaxedNames;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/boot/application/metadata/SpringBootApplicationMetaConfigKeyImpl$3", "compute"));
            }
        };
        this.myDeclaration = SmartPointerManager.getInstance((Project)declaration.getProject()).createSmartPsiElementPointer(declaration);
        this.myDeclarationResolveResult = declarationResolveResult;
        assert (!name.isEmpty());
        this.myName = name;
        this.myDescriptionText = descriptionText;
        this.myDefaultValue = defaultValue;
        this.myDeprecation = deprecation;
        this.myType = type;
        this.myItemHint = itemHint;
        this.myKeyItemHint = keyItemHint;
        if (accessType == SpringBootApplicationMetaConfigKey.AccessType.MAP) {
            this.myMapKeyType = PsiTypesUtil.getPsiClass((PsiType)this.getMapTypeParameter(0));
            this.myMapValueType = this.getMapTypeParameter(1);
            boolean isEnumMapKeyType = this.myMapKeyType != null && this.myMapKeyType.isEnum();
            this.myAccessType = isEnumMapKeyType ? SpringBootApplicationMetaConfigKey.AccessType.ENUM_MAP : accessType;
        } else {
            this.myMapKeyType = null;
            this.myMapValueType = null;
            this.myAccessType = accessType;
        }
    }

    @Nullable
    private PsiClassType getMapTypeParameter(int index) {
        PsiType parameterType = this.getParameter(index);
        if (!(parameterType instanceof PsiClassType)) {
            return null;
        }
        return (PsiClassType)parameterType;
    }

    @Nullable
    private PsiType getParameter(int index) {
        PsiType[] parameters = ((PsiClassType)this.myType).getParameters();
        if (parameters.length < index + 1) {
            return null;
        }
        return parameters[index];
    }

    @NotNull
    public PsiElement getDeclaration() {
        PsiElement element = this.myDeclaration.getElement();
        assert (element != null) : this.myName;
        PsiElement psiElement = element;
        if (psiElement == null) {
            SpringBootApplicationMetaConfigKeyImpl.$$$reportNull$$$0(8);
        }
        return psiElement;
    }

    @NotNull
    public SpringBootApplicationMetaConfigKey.DeclarationResolveResult getDeclarationResolveResult() {
        SpringBootApplicationMetaConfigKey.DeclarationResolveResult declarationResolveResult = this.myDeclarationResolveResult;
        if (declarationResolveResult == null) {
            SpringBootApplicationMetaConfigKeyImpl.$$$reportNull$$$0(9);
        }
        return declarationResolveResult;
    }

    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            SpringBootApplicationMetaConfigKeyImpl.$$$reportNull$$$0(10);
        }
        return string;
    }

    @NotNull
    public SpringBootApplicationMetaConfigKey.Deprecation getDeprecation() {
        SpringBootApplicationMetaConfigKey.Deprecation deprecation = this.myDeprecation;
        if (deprecation == null) {
            SpringBootApplicationMetaConfigKeyImpl.$$$reportNull$$$0(11);
        }
        return deprecation;
    }

    @NotNull
    public SpringBootApplicationMetaConfigKey.DescriptionText getDescriptionText() {
        SpringBootApplicationMetaConfigKey.DescriptionText descriptionText = this.myDescriptionText;
        if (descriptionText == null) {
            SpringBootApplicationMetaConfigKeyImpl.$$$reportNull$$$0(12);
        }
        return descriptionText;
    }

    @Nullable
    public String getDefaultValue() {
        return this.myDefaultValue;
    }

    @Nullable
    public PsiClass getEffectiveValueClass() {
        return (PsiClass)this.myEffectiveValueClass.getValue();
    }

    public boolean isAccessType(SpringBootApplicationMetaConfigKey.AccessType ... types) {
        for (SpringBootApplicationMetaConfigKey.AccessType type : types) {
            if (type != this.myAccessType) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public PsiClass getMapKeyType() {
        return this.myMapKeyType;
    }

    @Nullable
    public PsiClassType getMapValueType() {
        return this.myMapValueType;
    }

    @Nullable
    public PsiType getType() {
        return this.myType;
    }

    @NotNull
    public SpringBootApplicationMetaConfigKey.ItemHint getItemHint() {
        SpringBootApplicationMetaConfigKey.ItemHint itemHint = this.myItemHint;
        if (itemHint == null) {
            SpringBootApplicationMetaConfigKeyImpl.$$$reportNull$$$0(13);
        }
        return itemHint;
    }

    @NotNull
    public SpringBootApplicationMetaConfigKey.ItemHint getKeyItemHint() {
        SpringBootApplicationMetaConfigKey.ItemHint itemHint = this.myKeyItemHint;
        if (itemHint == null) {
            SpringBootApplicationMetaConfigKeyImpl.$$$reportNull$$$0(14);
        }
        return itemHint;
    }

    @NotNull
    public SpringBootApplicationMetaConfigKey.MetaConfigKeyPresentation getPresentation() {
        SpringBootApplicationMetaConfigKey.MetaConfigKeyPresentation metaConfigKeyPresentation = this.myPresentation;
        if (metaConfigKeyPresentation == null) {
            SpringBootApplicationMetaConfigKeyImpl.$$$reportNull$$$0(15);
        }
        return metaConfigKeyPresentation;
    }

    public boolean matches(@NotNull String configKey) {
        if (configKey == null) {
            SpringBootApplicationMetaConfigKeyImpl.$$$reportNull$$$0(16);
        }
        if (!this.matchesFirstChar(configKey)) {
            return false;
        }
        switch (this.myAccessType) {
            case MAP: 
            case ENUM_MAP: {
                return this.matchesMapType(configKey);
            }
            case INDEXED: {
                return this.matchesIndexedType(configKey);
            }
        }
        return this.myName.equalsIgnoreCase(configKey) || this.matchesRelaxed(configKey);
    }

    public boolean matchesPrefix(@NotNull String prefix) {
        if (prefix == null) {
            SpringBootApplicationMetaConfigKeyImpl.$$$reportNull$$$0(17);
        }
        if (!this.matchesFirstChar(prefix)) {
            return false;
        }
        if (StringUtil.startsWith((CharSequence)this.myName, (CharSequence)prefix)) {
            return true;
        }
        for (String value : ((RelaxedNames)this.myRelaxedNames.getValue()).getValues()) {
            if (!value.startsWith(prefix)) continue;
            return true;
        }
        return false;
    }

    private boolean matchesFirstChar(@NotNull String configKey) {
        if (configKey == null) {
            SpringBootApplicationMetaConfigKeyImpl.$$$reportNull$$$0(18);
        }
        return !configKey.isEmpty() && StringUtil.charsEqualIgnoreCase((char)this.myName.charAt(0), (char)configKey.charAt(0));
    }

    private boolean matchesMapType(String configKey) {
        int mapKeyIndex = configKey.lastIndexOf(46);
        if (mapKeyIndex == -1) {
            return false;
        }
        String mapPropertyName = configKey.substring(0, mapKeyIndex);
        if (this.myName.equalsIgnoreCase(mapPropertyName) || this.matchesRelaxed(mapPropertyName)) {
            return true;
        }
        String multiDotKey = configKey.substring(0, StringUtil.commonPrefixLength((CharSequence)this.myName, (CharSequence)configKey));
        return this.myName.equals(multiDotKey);
    }

    private boolean matchesIndexedType(String configKey) {
        int indexKeyIndex = configKey.indexOf(91);
        String propertyName = indexKeyIndex != -1 ? configKey.substring(0, indexKeyIndex) : configKey;
        return this.myName.equalsIgnoreCase(propertyName) || this.matchesRelaxed(propertyName);
    }

    private boolean matchesRelaxed(String configKey) {
        return ((RelaxedNames)this.myRelaxedNames.getValue()).getValues().contains(configKey);
    }

    public String toString() {
        return "SpringBootApplicationMetaConfigKey{myName='" + this.myName + '\'' + ", myDescriptionText='" + this.myDescriptionText + '\'' + ", myDefaultValue='" + this.myDefaultValue + '\'' + ", myDeprecation=" + this.myDeprecation + ", myType=" + this.myType + ", myAccessType=" + this.myAccessType + ", myMapKeyType=" + this.myMapKeyType + ", myMapValueType=" + this.myMapValueType + ", myItemHint=" + this.myItemHint + ", myKeyItemHint=" + this.myKeyItemHint + '}';
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "declaration";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "declarationResolveResult";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptionText";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "deprecation";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "accessType";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "itemHint";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keyItemHint";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/boot/application/metadata/SpringBootApplicationMetaConfigKeyImpl";
                break;
            }
            case 16: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configKey";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefix";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/boot/application/metadata/SpringBootApplicationMetaConfigKeyImpl";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getDeclaration";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getDeclarationResolveResult";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getDeprecation";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getDescriptionText";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getItemHint";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getKeyItemHint";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "matches";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "matchesPrefix";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "matchesFirstChar";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

