/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.application.properties;

import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.lang.properties.psi.impl.PropertyKeyImpl;
import com.intellij.lang.properties.psi.impl.PropertyValueImpl;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.RecursionManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PatternCondition;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.patterns.PsiElementPattern;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceContributor;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.PsiReferenceRegistrar;
import com.intellij.spring.boot.application.config.SpringBootHintReferencesProvider;
import com.intellij.spring.boot.application.config.hints.LoggerNameReferenceProvider;
import com.intellij.spring.boot.application.config.keyPath.ConfigKeyPathReferenceSet;
import com.intellij.spring.boot.application.metadata.MetaConfigKeyReference;
import com.intellij.spring.boot.application.metadata.SpringBootApplicationMetaConfigKey;
import com.intellij.spring.boot.application.properties.SpringBootApplicationPropertiesKeyReferenceProvider;
import com.intellij.spring.boot.application.properties.SpringBootApplicationPropertiesUtil;
import com.intellij.spring.boot.application.properties.SpringBootApplicationPropertiesValueReferenceProvider;
import com.intellij.spring.boot.library.SpringBootLibraryUtil;
import com.intellij.spring.constants.SpringReferencePatternConditions;
import com.intellij.util.ProcessingContext;
import org.jetbrains.annotations.NotNull;

public class SpringBootApplicationPropertiesReferenceContributor
extends PsiReferenceContributor {
    private static final PatternCondition<PsiElement> APPLICATION_PROPERTIES_SB_1_2_OR_HIGHER = new PatternCondition<PsiElement>("isApplicationPropertiesAndSB_1_2"){

        public boolean accepts(@NotNull PsiElement element, ProcessingContext context) {
            if (element == null) {
                1.$$$reportNull$$$0(0);
            }
            if (!SpringReferencePatternConditions.PROJECT_HAS_SPRING_FACETS_CONDITION.accepts((Object)element, context)) {
                return false;
            }
            PsiFile containingFile = element.getContainingFile().getOriginalFile();
            if (!(containingFile instanceof PropertiesFile)) {
                return false;
            }
            Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)element);
            if (!SpringBootLibraryUtil.isAtLeastVersion((Module)module, (SpringBootLibraryUtil.SpringBootVersion)SpringBootLibraryUtil.SpringBootVersion.VERSION_1_2_0)) {
                return false;
            }
            return SpringBootApplicationPropertiesUtil.isApplicationPropertiesFile((PropertiesFile)containingFile);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/spring/boot/application/properties/SpringBootApplicationPropertiesReferenceContributor$1", "accepts"));
        }
    };
    private static final Key<SpringBootApplicationMetaConfigKey> META_CONFIG_KEY = Key.create((String)"metaConfigKey");
    private static final String LOGGING_LEVEL_KEY_PREFIX = "logging.level.";

    public void registerReferenceProviders(@NotNull PsiReferenceRegistrar registrar) {
        if (registrar == null) {
            SpringBootApplicationPropertiesReferenceContributor.$$$reportNull$$$0(0);
        }
        SpringBootApplicationPropertiesReferenceContributor.registerKeyProviders(registrar);
        registrar.registerReferenceProvider((ElementPattern)PlatformPatterns.psiElement(PropertyValueImpl.class).with(APPLICATION_PROPERTIES_SB_1_2_OR_HIGHER), (PsiReferenceProvider)new SpringBootApplicationPropertiesValueReferenceProvider(), 100.0);
    }

    private static void registerKeyProviders(@NotNull PsiReferenceRegistrar registrar) {
        if (registrar == null) {
            SpringBootApplicationPropertiesReferenceContributor.$$$reportNull$$$0(1);
        }
        registrar.registerReferenceProvider((ElementPattern)PlatformPatterns.psiElement(PropertyKeyImpl.class).with(APPLICATION_PROPERTIES_SB_1_2_OR_HIGHER), (PsiReferenceProvider)new SpringBootApplicationPropertiesKeyReferenceProvider());
        registrar.registerReferenceProvider((ElementPattern)((PsiElementPattern.Capture)((PsiElementPattern.Capture)PlatformPatterns.psiElement(PropertyKeyImpl.class).with(APPLICATION_PROPERTIES_SB_1_2_OR_HIGHER)).without(SpringBootLibraryUtil.SB_1_3_OR_HIGHER)).with((PatternCondition)new PatternCondition<PropertyKeyImpl>("logging.level"){

            public boolean accepts(@NotNull PropertyKeyImpl key, ProcessingContext context) {
                if (key == null) {
                    2.$$$reportNull$$$0(0);
                }
                return StringUtil.startsWith((CharSequence)key.getText(), (CharSequence)SpringBootApplicationPropertiesReferenceContributor.LOGGING_LEVEL_KEY_PREFIX);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/spring/boot/application/properties/SpringBootApplicationPropertiesReferenceContributor$2", "accepts"));
            }
        }), (PsiReferenceProvider)new LoggerNameReferenceProvider(LOGGING_LEVEL_KEY_PREFIX));
        final Condition mapTypeKeyCondition = configKey -> configKey.getKeyItemHint() != SpringBootApplicationMetaConfigKey.ItemHint.NONE && configKey.isAccessType(SpringBootApplicationMetaConfigKey.AccessType.MAP_GROUP);
        registrar.registerReferenceProvider((ElementPattern)((PsiElementPattern.Capture)((PsiElementPattern.Capture)PlatformPatterns.psiElement(PropertyKeyImpl.class).with(APPLICATION_PROPERTIES_SB_1_2_OR_HIGHER)).with(SpringBootLibraryUtil.SB_1_3_OR_HIGHER)).with((PatternCondition)new PatternCondition<PropertyKeyImpl>("mapTypeKey"){

            public boolean accepts(@NotNull PropertyKeyImpl key, ProcessingContext context) {
                if (key == null) {
                    4.$$$reportNull$$$0(0);
                }
                return SpringBootApplicationPropertiesReferenceContributor.findAndStoreMetaConfigKeyIfMatches(key, context, (Condition<SpringBootApplicationMetaConfigKey>)mapTypeKeyCondition);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/spring/boot/application/properties/SpringBootApplicationPropertiesReferenceContributor$4", "accepts"));
            }
        }), new PsiReferenceProvider(){

            @NotNull
            public PsiReference[] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
                if (element == null) {
                    3.$$$reportNull$$$0(0);
                }
                if (context == null) {
                    3.$$$reportNull$$$0(1);
                }
                SpringBootApplicationMetaConfigKey configKey = (SpringBootApplicationMetaConfigKey)context.get(META_CONFIG_KEY);
                Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)element);
                assert (module != null);
                SpringBootHintReferencesProvider hintReferencesProvider = SpringBootHintReferencesProvider.getInstance();
                PsiReference[] psiReferenceArray = hintReferencesProvider.getKeyReferences(module, configKey, element, context);
                if (psiReferenceArray == null) {
                    3.$$$reportNull$$$0(2);
                }
                return psiReferenceArray;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 2: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 2: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "element";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "context";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/spring/boot/application/properties/SpringBootApplicationPropertiesReferenceContributor$3";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/spring/boot/application/properties/SpringBootApplicationPropertiesReferenceContributor$3";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getReferencesByElement";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "getReferencesByElement";
                        break;
                    }
                    case 2: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 2: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        });
        registrar.registerReferenceProvider((ElementPattern)((PsiElementPattern.Capture)PlatformPatterns.psiElement(PropertyKeyImpl.class).with(APPLICATION_PROPERTIES_SB_1_2_OR_HIGHER)).with((PatternCondition)new PatternCondition<PropertyKeyImpl>("isMapOrIndexedKey"){

            public boolean accepts(@NotNull PropertyKeyImpl key, ProcessingContext context) {
                if (key == null) {
                    6.$$$reportNull$$$0(0);
                }
                return SpringBootApplicationPropertiesReferenceContributor.findAndStoreMetaConfigKeyIfMatches(key, context, (Condition<SpringBootApplicationMetaConfigKey>)SpringBootHintReferencesProvider.MAP_OR_INDEXED_WITHOUT_KEY_HINTS_CONDITION);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/spring/boot/application/properties/SpringBootApplicationPropertiesReferenceContributor$6", "accepts"));
            }
        }), new PsiReferenceProvider(){

            @NotNull
            public PsiReference[] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
                if (element == null) {
                    5.$$$reportNull$$$0(0);
                }
                if (context == null) {
                    5.$$$reportNull$$$0(1);
                }
                SpringBootApplicationMetaConfigKey configKey = (SpringBootApplicationMetaConfigKey)context.get(META_CONFIG_KEY);
                String elementText = element.getText();
                if (configKey.isAccessType(new SpringBootApplicationMetaConfigKey.AccessType[]{SpringBootApplicationMetaConfigKey.AccessType.INDEXED})) {
                    int closingBracketIdx = elementText.indexOf("].");
                    if (closingBracketIdx == -1) {
                        if (PsiReference.EMPTY_ARRAY == null) {
                            5.$$$reportNull$$$0(2);
                        }
                        return PsiReference.EMPTY_ARRAY;
                    }
                    int firstPropertyIdx = closingBracketIdx + 2;
                    String text = elementText.substring(firstPropertyIdx);
                    ConfigKeyPathReferenceSet set = new ConfigKeyPathReferenceSet(element, text, firstPropertyIdx, configKey);
                    PsiReference[] psiReferenceArray = set.getReferences();
                    if (psiReferenceArray == null) {
                        5.$$$reportNull$$$0(3);
                    }
                    return psiReferenceArray;
                }
                int offset = configKey.getName().length() + 1;
                if (offset > elementText.length()) {
                    if (PsiReference.EMPTY_ARRAY == null) {
                        5.$$$reportNull$$$0(4);
                    }
                    return PsiReference.EMPTY_ARRAY;
                }
                String text = elementText.substring(offset);
                ConfigKeyPathReferenceSet set = new ConfigKeyPathReferenceSet(element, text, offset, configKey);
                PsiReference[] psiReferenceArray = set.getReferences();
                if (psiReferenceArray == null) {
                    5.$$$reportNull$$$0(5);
                }
                return psiReferenceArray;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "element";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "context";
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/spring/boot/application/properties/SpringBootApplicationPropertiesReferenceContributor$5";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/spring/boot/application/properties/SpringBootApplicationPropertiesReferenceContributor$5";
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getReferencesByElement";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "getReferencesByElement";
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        });
    }

    private static boolean findAndStoreMetaConfigKeyIfMatches(PropertyKeyImpl key, ProcessingContext context, Condition<SpringBootApplicationMetaConfigKey> condition) {
        SpringBootApplicationMetaConfigKey configKey = (SpringBootApplicationMetaConfigKey)RecursionManager.doPreventingRecursion((Object)key, (boolean)true, () -> MetaConfigKeyReference.getResolvedMetaConfigKey((PsiElement)key));
        if (configKey == null || !condition.value((Object)configKey)) {
            return false;
        }
        context.put(META_CONFIG_KEY, (Object)configKey);
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "registrar";
        objectArray2[1] = "com/intellij/spring/boot/application/properties/SpringBootApplicationPropertiesReferenceContributor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "registerReferenceProviders";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "registerKeyProviders";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

