/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.application.properties;

import com.intellij.lang.properties.IProperty;
import com.intellij.lang.properties.PropertiesFileType;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.lang.properties.psi.impl.PropertyImpl;
import com.intellij.lang.properties.psi.impl.PropertyKeyImpl;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.spring.boot.application.metadata.MetaConfigKeyReference;
import com.intellij.spring.boot.application.metadata.SpringBootApplicationMetaConfigKey;
import com.intellij.spring.boot.application.properties.SpringBootApplicationPropertiesUtil;
import com.intellij.spring.boot.model.SpringBootModelConfigFileContributor;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpringBootModelApplicationPropertiesConfigFileContributor
extends SpringBootModelConfigFileContributor {
    public SpringBootModelApplicationPropertiesConfigFileContributor() {
        super((FileType)PropertiesFileType.INSTANCE);
    }

    @NotNull
    public List<SpringBootModelConfigFileContributor.ConfigurationValueResult> findConfigurationValues(PsiFile configFile, SpringBootApplicationMetaConfigKey key, boolean checkRelaxedNames, @Nullable Set<String> activeProfiles) {
        PropertiesFile propertiesFile = SpringBootModelApplicationPropertiesConfigFileContributor.isProfileRelevantFile(configFile, activeProfiles);
        if (propertiesFile == null) {
            List<SpringBootModelConfigFileContributor.ConfigurationValueResult> list = Collections.emptyList();
            if (list == null) {
                SpringBootModelApplicationPropertiesConfigFileContributor.$$$reportNull$$$0(0);
            }
            return list;
        }
        String keyName = key.getName();
        IProperty byExactName = propertiesFile.findPropertyByKey(keyName);
        if (byExactName != null) {
            PropertyImpl propertyImpl = (PropertyImpl)byExactName.getPsiElement();
            List<SpringBootModelConfigFileContributor.ConfigurationValueResult> list = Collections.singletonList(new SpringBootModelConfigFileContributor.ConfigurationValueResult((PsiElement)SpringBootApplicationPropertiesUtil.getPropertyKey(propertyImpl), (PsiElement)SpringBootApplicationPropertiesUtil.getPropertyValue(propertyImpl), byExactName.getValue()));
            if (list == null) {
                SpringBootModelApplicationPropertiesConfigFileContributor.$$$reportNull$$$0(1);
            }
            return list;
        }
        if (!checkRelaxedNames) {
            List<SpringBootModelConfigFileContributor.ConfigurationValueResult> list = Collections.emptyList();
            if (list == null) {
                SpringBootModelApplicationPropertiesConfigFileContributor.$$$reportNull$$$0(2);
            }
            return list;
        }
        for (IProperty property : propertiesFile.getProperties()) {
            SpringBootApplicationMetaConfigKey resolvedKey;
            PropertyImpl element;
            PropertyKeyImpl keyPsiElement;
            String propertyName = property.getName();
            if (propertyName == null || !StringUtil.charsEqualIgnoreCase((char)propertyName.charAt(0), (char)keyName.charAt(0)) || (keyPsiElement = SpringBootApplicationPropertiesUtil.getPropertyKey(element = (PropertyImpl)property.getPsiElement())) == null || (resolvedKey = MetaConfigKeyReference.getResolvedMetaConfigKey((PsiElement)keyPsiElement)) == null || !resolvedKey.getName().equals(keyName)) continue;
            List<SpringBootModelConfigFileContributor.ConfigurationValueResult> list = Collections.singletonList(new SpringBootModelConfigFileContributor.ConfigurationValueResult((PsiElement)keyPsiElement, (PsiElement)SpringBootApplicationPropertiesUtil.getPropertyValue(element), property.getValue()));
            if (list == null) {
                SpringBootModelApplicationPropertiesConfigFileContributor.$$$reportNull$$$0(3);
            }
            return list;
        }
        List<SpringBootModelConfigFileContributor.ConfigurationValueResult> list = Collections.emptyList();
        if (list == null) {
            SpringBootModelApplicationPropertiesConfigFileContributor.$$$reportNull$$$0(4);
        }
        return list;
    }

    @Nullable
    private static PropertiesFile isProfileRelevantFile(PsiFile configFile, @Nullable Set<String> activeProfiles) {
        if (!(configFile instanceof PropertiesFile)) {
            return null;
        }
        PropertiesFile propertiesFile = (PropertiesFile)configFile;
        if (ContainerUtil.isEmpty(activeProfiles)) {
            return propertiesFile;
        }
        String fileName = propertiesFile.getVirtualFile().getNameWithoutExtension();
        String profileSuffix = StringUtil.substringAfter((String)fileName, (String)"-");
        if (profileSuffix == null) {
            return null;
        }
        boolean isInActiveProfiles = activeProfiles.contains(profileSuffix);
        return isInActiveProfiles ? propertiesFile : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/boot/application/properties/SpringBootModelApplicationPropertiesConfigFileContributor", "findConfigurationValues"));
    }
}

