/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.thymeleaf.lang.highlight;

import com.intellij.lexer.Lexer;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.fileTypes.SyntaxHighlighterBase;
import com.intellij.psi.impl.source.jsp.el.ELHighlighter;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.thymeleaf.lang.lexer.ThymeleafLexer;
import com.intellij.thymeleaf.lang.lexer.ThymeleafTokenTypeSets;
import com.intellij.thymeleaf.lang.lexer.ThymesElementTypes;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class ThymeleafSyntaxHighlighter
extends SyntaxHighlighterBase {
    protected final Map<IElementType, TextAttributesKey> keys1 = new HashMap<IElementType, TextAttributesKey>();
    protected final Map<IElementType, TextAttributesKey> keys2 = new HashMap<IElementType, TextAttributesKey>();

    public ThymeleafSyntaxHighlighter() {
        this.fillMap(ThymeleafTokenTypeSets.KEYWORDS, ELHighlighter.EL_KEYWORD);
        this.fillMap(ThymeleafTokenTypeSets.UNARY_OPERATIONS, ELHighlighter.EL_KEYWORD);
        this.fillMap(ThymeleafTokenTypeSets.BINARY_OPERATIONS, ELHighlighter.EL_KEYWORD);
        this.putTokenType(ThymesElementTypes.URL_EXPR_START, ELHighlighter.EL_BOUNDS);
        this.putTokenType(ThymesElementTypes.SELECTIONS_EXPR_START, ELHighlighter.EL_BOUNDS);
        this.putTokenType(ThymesElementTypes.MESSAGE_EXPR_START, ELHighlighter.EL_BOUNDS);
        this.putTokenType(ThymesElementTypes.EXPR_END, ELHighlighter.EL_BOUNDS);
        this.putTokenType(ThymesElementTypes.OGNL_PREPROCESSING_START, ELHighlighter.EL_BOUNDS);
        this.putTokenType(ThymesElementTypes.MESSAGE_PREPROCESSING_START, ELHighlighter.EL_BOUNDS);
        this.putTokenType(ThymesElementTypes.SELECTIONS_PREPROCESSING_START, ELHighlighter.EL_BOUNDS);
        this.putTokenType(ThymesElementTypes.PREPROCESSING_END, ELHighlighter.EL_BOUNDS);
        this.putTokenType(ThymesElementTypes.IDENTIFIER, ELHighlighter.EL_IDENT);
        this.putTokenType(ThymesElementTypes.DOT, ELHighlighter.EL_DOT);
        this.putTokenType(ThymesElementTypes.COMMA, ELHighlighter.EL_COMMA);
        this.putTokenType(ThymesElementTypes.INTEGER_LITERAL, ELHighlighter.EL_NUMBER);
        this.putTokenType(ThymesElementTypes.FLOATING_POINT_LITERAL, ELHighlighter.EL_NUMBER);
        this.putTokenType(ThymesElementTypes.STRING_LITERAL, ELHighlighter.EL_STRING);
        this.putTokenType(ThymesElementTypes.LPARENTH, ELHighlighter.EL_PARENTHS);
        this.putTokenType(ThymesElementTypes.RPARENTH, ELHighlighter.EL_PARENTHS);
        this.putTokenType(ThymesElementTypes.LBRACKET, ELHighlighter.EL_BRACKETS);
        this.putTokenType(ThymesElementTypes.RBRACKET, ELHighlighter.EL_BRACKETS);
        this.putTokenType(ThymesElementTypes.OGNL_EXPR_START, ELHighlighter.EL_BOUNDS);
    }

    protected void fillMap(TokenSet tokenSet, TextAttributesKey key) {
        SyntaxHighlighterBase.fillMap(this.keys1, (TokenSet)tokenSet, (TextAttributesKey)key);
        SyntaxHighlighterBase.fillMap(this.keys2, (TokenSet)tokenSet, (TextAttributesKey)ELHighlighter.EL_BACKGROUND);
    }

    protected void putTokenType(IElementType elementType, TextAttributesKey key) {
        this.keys1.put(elementType, key);
        this.keys2.put(elementType, ELHighlighter.EL_BACKGROUND);
    }

    @NotNull
    public TextAttributesKey[] getTokenHighlights(IElementType tokenType) {
        TextAttributesKey[] textAttributesKeyArray = ThymeleafSyntaxHighlighter.pack((TextAttributesKey)this.keys2.get(tokenType), (TextAttributesKey)this.keys1.get(tokenType));
        if (textAttributesKeyArray == null) {
            ThymeleafSyntaxHighlighter.$$$reportNull$$$0(0);
        }
        return textAttributesKeyArray;
    }

    @NotNull
    public Lexer getHighlightingLexer() {
        ThymeleafLexer thymeleafLexer = new ThymeleafLexer();
        if (thymeleafLexer == null) {
            ThymeleafSyntaxHighlighter.$$$reportNull$$$0(1);
        }
        return thymeleafLexer;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/thymeleaf/lang/highlight/ThymeleafSyntaxHighlighter";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getTokenHighlights";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getHighlightingLexer";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

