/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.thymeleaf.lang.support;

import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionInitializationContext;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.ide.highlighter.HtmlFileType;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PatternCondition;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.patterns.PsiElementPattern;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.thymeleaf.lang.ThymeleafPsiFile;
import com.intellij.thymeleaf.lang.psi.ThymeleafReference;
import com.intellij.thymeleaf.lang.psi.ThymesTemplateFragmentName;
import com.intellij.thymeleaf.lang.psi.ThymesTemplateName;
import com.intellij.thymeleaf.lang.psi.impl.ThymeleafTemplateNameReferenceImpl;
import com.intellij.util.ProcessingContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ThymeleafCompletionContributor
extends CompletionContributor {
    public void beforeCompletion(@NotNull CompletionInitializationContext context) {
        if (context == null) {
            ThymeleafCompletionContributor.$$$reportNull$$$0(0);
        }
        if (context.getCompletionType() == CompletionType.SMART) {
            return;
        }
        super.beforeCompletion(context);
        PsiFile file = context.getFile();
        if (file instanceof ThymeleafPsiFile) {
            context.setDummyIdentifier("IntellijIdeaRulezzz");
        }
    }

    public ThymeleafCompletionContributor() {
        PsiElementPattern.Capture with = (PsiElementPattern.Capture)PlatformPatterns.psiElement().with((PatternCondition)new PatternCondition<PsiElement>("ThymeleafTemplateName"){

            public boolean accepts(@NotNull PsiElement psiElement, ProcessingContext context) {
                XmlAttribute contextAttribute;
                PsiElement contextElement;
                PsiFile containingFile;
                if (psiElement == null) {
                    1.$$$reportNull$$$0(0);
                }
                if ((containingFile = psiElement.getContainingFile()) instanceof ThymeleafPsiFile && (contextElement = containingFile.getContext()) != null && (contextAttribute = (XmlAttribute)PsiTreeUtil.getParentOfType((PsiElement)contextElement, XmlAttribute.class)) != null) {
                    String localName = contextAttribute.getLocalName();
                    return "replace".equals(localName) || "include".equals(localName);
                }
                return false;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiElement", "com/intellij/thymeleaf/lang/support/ThymeleafCompletionContributor$1", "accepts"));
            }
        });
        this.extend(CompletionType.BASIC, (ElementPattern)with, (CompletionProvider)new CompletionProvider<CompletionParameters>(){

            protected void addCompletions(@NotNull CompletionParameters parameters, ProcessingContext context, @NotNull CompletionResultSet result) {
                boolean isTemplateFragment;
                PsiElement originalPosition;
                if (parameters == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (result == null) {
                    2.$$$reportNull$$$0(1);
                }
                if (((originalPosition = parameters.getOriginalPosition()) == null || originalPosition.getParent() instanceof ThymesTemplateName) && !(isTemplateFragment = parameters.getPosition().getParent() instanceof ThymesTemplateFragmentName)) {
                    PsiDirectory directory = ThymeleafTemplateNameReferenceImpl.getContextDirectory(parameters.getPosition().getContainingFile());
                    if (directory != null) {
                        for (PsiFile file : directory.getFiles()) {
                            if (file.getFileType() != HtmlFileType.INSTANCE) continue;
                            String nameWithoutExtension = FileUtil.getNameWithoutExtension((String)file.getName());
                            result.addElement((LookupElement)LookupElementBuilder.create((String)nameWithoutExtension).withIcon(file.getIcon(0)).bold().withTypeText(file.getName(), true));
                        }
                    }
                    result.addElement((LookupElement)LookupElementBuilder.create((String)"this").bold());
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "parameters";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "result";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/thymeleaf/lang/support/ThymeleafCompletionContributor$2";
                objectArray[2] = "addCompletions";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    public void fillCompletionVariants(@NotNull CompletionParameters parameters, @NotNull CompletionResultSet result) {
        if (parameters == null) {
            ThymeleafCompletionContributor.$$$reportNull$$$0(1);
        }
        if (result == null) {
            ThymeleafCompletionContributor.$$$reportNull$$$0(2);
        }
    }

    @Nullable
    public static ThymeleafReference findThymeleafReference(PsiFile file, int offset) {
        PsiReference reference;
        if (file instanceof ThymeleafPsiFile && (reference = file.findReferenceAt(offset)) instanceof ThymeleafReference) {
            return (ThymeleafReference)reference;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
        }
        objectArray2[1] = "com/intellij/thymeleaf/lang/support/ThymeleafCompletionContributor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "beforeCompletion";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "fillCompletionVariants";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

