/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.thymeleaf.providers.contexts;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.XmlElementVisitor;
import com.intellij.psi.impl.PsiImplUtil;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlComment;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlText;
import com.intellij.thymeleaf.lang.support.ThymeleafContextVariablesProvider;
import com.intellij.thymeleaf.lang.support.beans.ThymeleafVariable;
import com.intellij.util.containers.hash.HashMap;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ThymeleafCommentedELVariablesProvider
extends ThymeleafContextVariablesProvider {
    @NonNls
    public static final String THYMES_VAR = "@thymesVar";
    @NonNls
    private static final Pattern THYMES_VAR_PATTERN = Pattern.compile("@thymesVar id=\"(.+)\" type=\"(.*)\"");

    @Override
    @NotNull
    public Collection<? extends PsiVariable> getContextVariables(@NotNull PsiElement contextElement) {
        PsiElement context;
        PsiFile containingFile;
        if (contextElement == null) {
            ThymeleafCommentedELVariablesProvider.$$$reportNull$$$0(0);
        }
        if ((containingFile = contextElement.getContainingFile()) != null && (context = containingFile.getContext()) != null) {
            HashMap variables = new HashMap();
            for (XmlTag xmlTag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)context, XmlTag.class); xmlTag != null; xmlTag = xmlTag.getParentTag()) {
                for (Map.Entry<String, ThymeleafVariable> entry : ThymeleafCommentedELVariablesProvider.getVarsFromComments(xmlTag).entrySet()) {
                    if (variables.containsKey(entry.getKey())) continue;
                    variables.put(entry.getKey(), entry.getValue());
                }
            }
            Collection collection = variables.values();
            if (collection == null) {
                ThymeleafCommentedELVariablesProvider.$$$reportNull$$$0(1);
            }
            return collection;
        }
        Set set = Collections.emptySet();
        if (set == null) {
            ThymeleafCommentedELVariablesProvider.$$$reportNull$$$0(2);
        }
        return set;
    }

    public static Map<String, ThymeleafVariable> getVarsFromComments(final XmlTag tag) {
        return (Map)CachedValuesManager.getCachedValue((PsiElement)tag, (CachedValueProvider)new CachedValueProvider<Map<String, ThymeleafVariable>>(){

            @Nullable
            public CachedValueProvider.Result<Map<String, ThymeleafVariable>> compute() {
                HashMap variables = new HashMap();
                tag.acceptChildren((PsiElementVisitor)new XmlElementVisitor((Map)variables){
                    final /* synthetic */ Map val$variables;
                    {
                        this.val$variables = map;
                    }

                    public void visitXmlText(XmlText text) {
                        text.acceptChildren((PsiElementVisitor)this);
                    }

                    public void visitXmlComment(XmlComment comment) {
                        Matcher matcher;
                        String s = ThymeleafCommentedELVariablesProvider.getTextToMatch(comment.getText());
                        if (s.startsWith(ThymeleafCommentedELVariablesProvider.THYMES_VAR) && (matcher = THYMES_VAR_PATTERN.matcher(s)).matches()) {
                            String name = matcher.group(1);
                            PsiFile file = tag.getContainingFile();
                            String typeName = matcher.group(2);
                            String fqn = typeName.indexOf(36) >= 0 ? typeName.replace('$', '.') : typeName;
                            PsiType type = PsiImplUtil.buildTypeFromTypeString((String)fqn, (PsiElement)file, (PsiFile)file);
                            this.val$variables.put(name, new ThymeleafVariable(name, type, (PsiElement)comment));
                        }
                    }
                });
                return CachedValueProvider.Result.create((Object)variables, (Object[])new Object[]{tag.getContainingFile()});
            }
        });
    }

    private static String getTextToMatch(String s) {
        String commentText = ThymeleafCommentedELVariablesProvider.substringBetween(s, "<!--", "-->");
        return ThymeleafCommentedELVariablesProvider.substringBetween(commentText.trim(), "/*", "*/").trim();
    }

    @NotNull
    private static String substringBetween(@NotNull String s, @NotNull String start, @NotNull String end) {
        String text;
        String after;
        if (s == null) {
            ThymeleafCommentedELVariablesProvider.$$$reportNull$$$0(3);
        }
        if (start == null) {
            ThymeleafCommentedELVariablesProvider.$$$reportNull$$$0(4);
        }
        if (end == null) {
            ThymeleafCommentedELVariablesProvider.$$$reportNull$$$0(5);
        }
        if ((after = StringUtil.substringAfter((String)s, (String)start)) != null && (text = StringUtil.substringBefore((String)after, (String)end)) != null) {
            String string = text;
            if (string == null) {
                ThymeleafCommentedELVariablesProvider.$$$reportNull$$$0(6);
            }
            return string;
        }
        String string = s;
        if (string == null) {
            ThymeleafCommentedELVariablesProvider.$$$reportNull$$$0(7);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contextElement";
                break;
            }
            case 1: 
            case 2: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/thymeleaf/providers/contexts/ThymeleafCommentedELVariablesProvider";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "start";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "end";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/thymeleaf/providers/contexts/ThymeleafCommentedELVariablesProvider";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getContextVariables";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "substringBetween";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getContextVariables";
                break;
            }
            case 1: 
            case 2: 
            case 6: 
            case 7: {
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "substringBetween";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

