/*
 * Decompiled with CFR 0.152.
 */
package android.net.wifi.nan;

import android.net.wifi.nan.ConfigRequest;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;

public interface IWifiNanEventListener
extends IInterface {
    public void onConfigCompleted(ConfigRequest var1) throws RemoteException;

    public void onConfigFailed(ConfigRequest var1, int var2) throws RemoteException;

    public void onNanDown(int var1) throws RemoteException;

    public void onIdentityChanged() throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IWifiNanEventListener {
        private static final String DESCRIPTOR = "android.net.wifi.nan.IWifiNanEventListener";
        static final int TRANSACTION_onConfigCompleted = 1;
        static final int TRANSACTION_onConfigFailed = 2;
        static final int TRANSACTION_onNanDown = 3;
        static final int TRANSACTION_onIdentityChanged = 4;

        public Stub() {
            this.attachInterface(this, DESCRIPTOR);
        }

        public static IWifiNanEventListener asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(DESCRIPTOR);
            if (iin != null && iin instanceof IWifiNanEventListener) {
                return (IWifiNanEventListener)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            switch (code) {
                case 1598968902: {
                    reply.writeString(DESCRIPTOR);
                    return true;
                }
                case 1: {
                    data.enforceInterface(DESCRIPTOR);
                    ConfigRequest _arg0 = 0 != data.readInt() ? ConfigRequest.CREATOR.createFromParcel(data) : null;
                    this.onConfigCompleted(_arg0);
                    return true;
                }
                case 2: {
                    data.enforceInterface(DESCRIPTOR);
                    ConfigRequest _arg0 = 0 != data.readInt() ? ConfigRequest.CREATOR.createFromParcel(data) : null;
                    int _arg1 = data.readInt();
                    this.onConfigFailed(_arg0, _arg1);
                    return true;
                }
                case 3: {
                    data.enforceInterface(DESCRIPTOR);
                    int _arg0 = data.readInt();
                    this.onNanDown(_arg0);
                    return true;
                }
                case 4: {
                    data.enforceInterface(DESCRIPTOR);
                    this.onIdentityChanged();
                    return true;
                }
            }
            return super.onTransact(code, data, reply, flags);
        }

        private static class Proxy
        implements IWifiNanEventListener {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return Stub.DESCRIPTOR;
            }

            @Override
            public void onConfigCompleted(ConfigRequest completedConfig) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (completedConfig != null) {
                        _data.writeInt(1);
                        completedConfig.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    this.mRemote.transact(1, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onConfigFailed(ConfigRequest failedConfig, int reason) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (failedConfig != null) {
                        _data.writeInt(1);
                        failedConfig.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeInt(reason);
                    this.mRemote.transact(2, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            @Override
            public void onNanDown(int reason) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(reason);
                    this.mRemote.transact(3, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            @Override
            public void onIdentityChanged() throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(4, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }
}

