/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.app;

import android.app.AlertDialog;
import android.app.Dialog;
import android.app.DialogFragment;
import android.content.ComponentName;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.SharedPreferences;
import android.net.Uri;
import android.os.Bundle;
import com.android.internal.app.ChooserActivity;

public class ResolverTargetActionsDialogFragment
extends DialogFragment
implements DialogInterface.OnClickListener {
    private static final String NAME_KEY = "componentName";
    private static final String PINNED_KEY = "pinned";
    private static final String TITLE_KEY = "title";
    private static final int TOGGLE_PIN_INDEX = 0;
    private static final int APP_INFO_INDEX = 1;

    public ResolverTargetActionsDialogFragment() {
    }

    public ResolverTargetActionsDialogFragment(CharSequence title, ComponentName name, boolean pinned) {
        Bundle args = new Bundle();
        args.putCharSequence(TITLE_KEY, title);
        args.putParcelable(NAME_KEY, name);
        args.putBoolean(PINNED_KEY, pinned);
        this.setArguments(args);
    }

    @Override
    public Dialog onCreateDialog(Bundle savedInstanceState) {
        Bundle args = this.getArguments();
        int itemRes = args.getBoolean(PINNED_KEY, false) ? 17235981 : 17235980;
        return new AlertDialog.Builder(this.getContext()).setCancelable(true).setItems(itemRes, (DialogInterface.OnClickListener)this).setTitle(args.getCharSequence(TITLE_KEY)).create();
    }

    @Override
    public void onClick(DialogInterface dialog, int which) {
        Bundle args = this.getArguments();
        ComponentName name = (ComponentName)args.getParcelable(NAME_KEY);
        switch (which) {
            case 0: {
                SharedPreferences sp = ChooserActivity.getPinnedSharedPrefs(this.getContext());
                String key = name.flattenToString();
                boolean currentVal = sp.getBoolean(name.flattenToString(), false);
                if (currentVal) {
                    sp.edit().remove(key).apply();
                } else {
                    sp.edit().putBoolean(key, true).apply();
                }
                this.getActivity().recreate();
                break;
            }
            case 1: {
                Intent in = new Intent().setAction("android.settings.APPLICATION_DETAILS_SETTINGS").setData(Uri.fromParts("package", name.getPackageName(), null)).addFlags(524288);
                this.startActivity(in);
            }
        }
        this.dismiss();
    }
}

