/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.testFramework.exports;

import com.intellij.javascript.testFramework.AbstractTestFileStructureBuilder;
import com.intellij.javascript.testFramework.exports.ExportsNode;
import com.intellij.javascript.testFramework.exports.ExportsTestFileStructure;
import com.intellij.javascript.testFramework.util.JsPsiUtils;
import com.intellij.lang.javascript.psi.JSAssignmentExpression;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSExpressionStatement;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSIndexedPropertyAccessExpression;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExportsTestFileStructureBuilder
extends AbstractTestFileStructureBuilder<ExportsTestFileStructure> {
    private static final ExportsTestFileStructureBuilder INSTANCE = new ExportsTestFileStructureBuilder();

    @Override
    @NotNull
    public ExportsTestFileStructure buildTestFileStructure(@NotNull JSFile jsFile) {
        if (jsFile == null) {
            ExportsTestFileStructureBuilder.$$$reportNull$$$0(0);
        }
        List<JSStatement> jsElements = JsPsiUtils.listStatementsInExecutionOrder(jsFile);
        ExportsNode root = new ExportsNode("root", null);
        for (JSElement jSElement : jsElements) {
            JSDefinitionExpression definitionExpression;
            ExportsNode node;
            JSAssignmentExpression assignmentExpression;
            JSExpression leftOperand;
            JSExpressionStatement expressionStatement;
            JSExpression inner;
            if (!(jSElement instanceof JSExpressionStatement) || !((inner = (expressionStatement = (JSExpressionStatement)jSElement).getExpression()) instanceof JSAssignmentExpression) || !((leftOperand = (assignmentExpression = (JSAssignmentExpression)inner).getLOperand()) instanceof JSDefinitionExpression) || (node = ExportsTestFileStructureBuilder.findNode(root, definitionExpression = (JSDefinitionExpression)leftOperand)) == null) continue;
            JSExpression rightOperand = assignmentExpression.getROperand();
            ExportsTestFileStructureBuilder.fill(node, rightOperand);
        }
        ExportsTestFileStructure exportsTestFileStructure = new ExportsTestFileStructure(jsFile, root);
        if (exportsTestFileStructure == null) {
            ExportsTestFileStructureBuilder.$$$reportNull$$$0(1);
        }
        return exportsTestFileStructure;
    }

    private static void fill(@NotNull ExportsNode parent, JSExpression expr) {
        if (parent == null) {
            ExportsTestFileStructureBuilder.$$$reportNull$$$0(2);
        }
        if (expr instanceof JSObjectLiteralExpression) {
            JSProperty[] properties;
            JSObjectLiteralExpression objectLiteral = (JSObjectLiteralExpression)expr;
            for (JSProperty property : properties = JsPsiUtils.getProperties(objectLiteral)) {
                PsiElement propertyNamePsiElement = JsPsiUtils.getPropertyNamePsiElement(property);
                if (propertyNamePsiElement == null) continue;
                String name = StringUtil.unquoteString((String)propertyNamePsiElement.getText());
                ExportsNode child = new ExportsNode(name, propertyNamePsiElement);
                parent.addChild(child);
                ExportsTestFileStructureBuilder.fill(child, (JSExpression)property.getObjectLiteralExpressionInitializer());
            }
        }
    }

    @Nullable
    private static ExportsNode findNode(@NotNull ExportsNode root, @NotNull JSDefinitionExpression definitionExpression) {
        JSExpression startExpression;
        if (root == null) {
            ExportsTestFileStructureBuilder.$$$reportNull$$$0(3);
        }
        if (definitionExpression == null) {
            ExportsTestFileStructureBuilder.$$$reportNull$$$0(4);
        }
        if ((startExpression = definitionExpression.getExpression()) == null) {
            return null;
        }
        JSExpression expression = startExpression;
        ArrayList refNameChain = ContainerUtil.newArrayList();
        while (expression != null) {
            JSExpression parent;
            if (expression instanceof JSReferenceExpression) {
                JSReferenceExpression referenceExpression = (JSReferenceExpression)expression;
                parent = referenceExpression.getQualifier();
                String name = referenceExpression.getReferenceName();
                if (name == null) {
                    return null;
                }
                refNameChain.add(name);
            } else if (expression instanceof JSIndexedPropertyAccessExpression) {
                JSIndexedPropertyAccessExpression propertyAccessExpression = (JSIndexedPropertyAccessExpression)expression;
                String indexStr = JsPsiUtils.extractStringValue(propertyAccessExpression.getIndexExpression());
                parent = propertyAccessExpression.getQualifier();
                if (parent != null && indexStr != null) {
                    refNameChain.add(indexStr);
                }
            } else {
                parent = null;
            }
            expression = parent;
        }
        Collections.reverse(refNameChain);
        List<String> usefulRefChain = ExportsTestFileStructureBuilder.removeExportsPrefix(refNameChain);
        if (usefulRefChain == null) {
            return null;
        }
        PsiElement navigateToElement = ExportsTestFileStructureBuilder.getNavigateToElement(startExpression);
        return ExportsTestFileStructureBuilder.findOrCreateBucket(root, usefulRefChain, navigateToElement);
    }

    @Nullable
    private static ExportsNode findOrCreateBucket(@NotNull ExportsNode root, @NotNull List<String> names, @NotNull PsiElement navigateTo) {
        if (root == null) {
            ExportsTestFileStructureBuilder.$$$reportNull$$$0(5);
        }
        if (names == null) {
            ExportsTestFileStructureBuilder.$$$reportNull$$$0(6);
        }
        if (navigateTo == null) {
            ExportsTestFileStructureBuilder.$$$reportNull$$$0(7);
        }
        ExportsNode current = root;
        for (int i = 0; i < names.size() - 1; ++i) {
            String name = names.get(i);
            ExportsNode next = current.getChild(name);
            if (next == null) {
                return null;
            }
            current = next;
        }
        if (names.size() > 0) {
            String name = names.get(names.size() - 1);
            ExportsNode leaf = new ExportsNode(name, navigateTo);
            current.addChild(leaf);
            current = leaf;
        }
        return current;
    }

    @NotNull
    private static PsiElement getNavigateToElement(@NotNull JSExpression expression) {
        if (expression == null) {
            ExportsTestFileStructureBuilder.$$$reportNull$$$0(8);
        }
        PsiElement navigateToElement = null;
        if (expression instanceof JSReferenceExpression) {
            JSReferenceExpression jsReferenceExpression = (JSReferenceExpression)expression;
            navigateToElement = jsReferenceExpression.getReferenceNameElement();
        } else if (expression instanceof JSIndexedPropertyAccessExpression) {
            JSIndexedPropertyAccessExpression propertyAccessExpression = (JSIndexedPropertyAccessExpression)expression;
            navigateToElement = propertyAccessExpression.getIndexExpression();
        }
        PsiElement psiElement = (PsiElement)ObjectUtils.notNull((Object)navigateToElement, (Object)expression);
        if (psiElement == null) {
            ExportsTestFileStructureBuilder.$$$reportNull$$$0(9);
        }
        return psiElement;
    }

    @Nullable
    private static List<String> removeExportsPrefix(@NotNull List<String> fullChain) {
        if (fullChain == null) {
            ExportsTestFileStructureBuilder.$$$reportNull$$$0(10);
        }
        if (fullChain.isEmpty()) {
            return null;
        }
        String first = fullChain.get(0);
        if (fullChain.size() >= 2) {
            String second = fullChain.get(1);
            if ("module".equals(first) && "exports".equals(second)) {
                return fullChain.subList(2, fullChain.size());
            }
        }
        if ("exports".equals(first)) {
            return fullChain.subList(1, fullChain.size());
        }
        return null;
    }

    public static ExportsTestFileStructureBuilder getInstance() {
        return INSTANCE;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jsFile";
                break;
            }
            case 1: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/testFramework/exports/ExportsTestFileStructureBuilder";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "definitionExpression";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "names";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "navigateTo";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fullChain";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/testFramework/exports/ExportsTestFileStructureBuilder";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildTestFileStructure";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getNavigateToElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildTestFileStructure";
                break;
            }
            case 1: 
            case 9: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "fill";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "findNode";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "findOrCreateBucket";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getNavigateToElement";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "removeExportsPrefix";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

