/*
 * Decompiled with CFR 0.152.
 */
package org.coffeescript.lang.lexer;

import com.intellij.lexer.DelegateLexer;
import com.intellij.lexer.Lexer;
import com.intellij.lexer.LexerPosition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.tree.IElementType;
import org.coffeescript.lang.lexer.CoffeeScriptFlexLexer;
import org.coffeescript.lang.lexer.CoffeeScriptTokenTypes;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CoffeeScriptLiterateLexer
extends DelegateLexer {
    public static final int FIRST_LEVEL_BLOCK_COMMENT_STATE = Integer.MAX_VALUE;
    private int myTokenStart = 0;
    private boolean indented = false;
    private boolean newLine = false;
    public static final String LINE_BREAK_WITH_INDENT = "\n ";

    public CoffeeScriptLiterateLexer() {
        super((Lexer)new CoffeeScriptFlexLexer());
    }

    private void calculateTokenEnd() {
        if (this.myDelegate.getTokenType() == null) {
            this.indented = true;
            return;
        }
        String tokenText = this.myDelegate.getTokenText();
        if (this.newLine || this.getTokenStart() == 0) {
            this.indented = tokenText.startsWith(" ");
        }
        this.newLine = false;
        if (tokenText.endsWith("\n")) {
            this.newLine = true;
            return;
        }
        if (tokenText.contains(LINE_BREAK_WITH_INDENT)) {
            this.indented = true;
            return;
        }
        if (!this.indented) {
            LexerPosition previousPosition = null;
            while (this.myDelegate.getTokenEnd() < this.myDelegate.getBufferEnd() && this.myDelegate.getTokenType() != null && !tokenText.contains(LINE_BREAK_WITH_INDENT)) {
                previousPosition = this.myDelegate.getCurrentPosition();
                this.myDelegate.advance();
                tokenText = this.myDelegate.getTokenText();
            }
            if (tokenText.contains(LINE_BREAK_WITH_INDENT) && previousPosition != null) {
                this.myDelegate.restore(previousPosition);
            }
        }
    }

    @NotNull
    public LexerPosition getCurrentPosition() {
        LexerPosition lexerPosition = super.getCurrentPosition();
        if (lexerPosition == null) {
            CoffeeScriptLiterateLexer.$$$reportNull$$$0(0);
        }
        return lexerPosition;
    }

    public void advance() {
        this.myDelegate.advance();
        this.myTokenStart = this.myDelegate.getTokenStart();
        this.calculateTokenEnd();
    }

    @Nullable
    public IElementType getTokenType() {
        if (this.indented) {
            return this.myDelegate.getTokenType();
        }
        return CoffeeScriptTokenTypes.BLOCK_COMMENT;
    }

    public int getState() {
        if (this.indented) {
            return super.getState();
        }
        return Integer.MAX_VALUE;
    }

    @NotNull
    public CharSequence getTokenSequence() {
        CharSequence charSequence = super.getTokenSequence();
        if (charSequence == null) {
            CoffeeScriptLiterateLexer.$$$reportNull$$$0(1);
        }
        return charSequence;
    }

    public void start(@NotNull CharSequence buffer, int startOffset, int endOffset, int initialState) {
        if (buffer == null) {
            CoffeeScriptLiterateLexer.$$$reportNull$$$0(2);
        }
        this.newLine = false;
        this.indented = false;
        super.start(buffer, startOffset, endOffset, initialState);
        this.myTokenStart = this.myDelegate.getTokenStart();
        if (this.myTokenStart > 0) {
            int i;
            for (i = this.myTokenStart; i >= 0 && buffer.charAt(i) != '\n'; --i) {
            }
            this.indented = StringUtil.isWhiteSpace((char)buffer.charAt(i + 1));
        }
        this.calculateTokenEnd();
    }

    public int getTokenStart() {
        return this.myTokenStart;
    }

    public void restore(@NotNull LexerPosition position) {
        if (position == null) {
            CoffeeScriptLiterateLexer.$$$reportNull$$$0(3);
        }
        super.restore(position);
        this.myTokenStart = this.myDelegate.getTokenStart();
        this.calculateTokenEnd();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/coffeescript/lang/lexer/CoffeeScriptLiterateLexer";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buffer";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "position";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getCurrentPosition";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getTokenSequence";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "org/coffeescript/lang/lexer/CoffeeScriptLiterateLexer";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "start";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "restore";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

