/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.load.kotlin.reflect;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.ArraysKt;
import kotlin.collections.IndexedValue;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.load.java.structure.reflect.ReflectClassUtilKt;
import org.jetbrains.kotlin.load.kotlin.KotlinJvmBinaryClass;
import org.jetbrains.kotlin.load.kotlin.reflect.ReflectAnnotationSource;
import org.jetbrains.kotlin.load.kotlin.reflect.ReflectKotlinClassKt;
import org.jetbrains.kotlin.load.kotlin.reflect.SignatureSerializer;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.Name;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u001b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c2\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\u00020\u00042\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u001c\u0010\t\u001a\u00020\u00042\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u00062\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u001c\u0010\f\u001a\u00020\u00042\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u00062\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u001c\u0010\r\u001a\u00020\u00042\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u00062\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0018\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J \u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0001H\u0002J$\u0010\u0016\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00122\u0006\u0010\u000f\u001a\u00020\u00102\n\u0010\u0017\u001a\u0006\u0012\u0002\b\u00030\u0006H\u0002J\u001a\u0010\u0018\u001a\u00020\u00042\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u00062\u0006\u0010\n\u001a\u00020\u000b\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/kotlin/load/kotlin/reflect/ReflectClassStructure;", "", "()V", "loadClassAnnotations", "", "klass", "Ljava/lang/Class;", "visitor", "Lorg/jetbrains/kotlin/load/kotlin/KotlinJvmBinaryClass$AnnotationVisitor;", "loadConstructorAnnotations", "memberVisitor", "Lorg/jetbrains/kotlin/load/kotlin/KotlinJvmBinaryClass$MemberVisitor;", "loadFieldAnnotations", "loadMethodAnnotations", "processAnnotation", "annotation", "", "processAnnotationArgumentValue", "Lorg/jetbrains/kotlin/load/kotlin/KotlinJvmBinaryClass$AnnotationArgumentVisitor;", "name", "Lorg/jetbrains/kotlin/name/Name;", "value", "processAnnotationArguments", "annotationType", "visitMembers", "core"})
final class ReflectClassStructure {
    public static final ReflectClassStructure INSTANCE;

    public final void loadClassAnnotations(@NotNull Class<?> klass, @NotNull KotlinJvmBinaryClass.AnnotationVisitor visitor) {
        Intrinsics.checkParameterIsNotNull(klass, (String)"klass");
        Intrinsics.checkParameterIsNotNull((Object)visitor, (String)"visitor");
        Annotation[] annotationArray = klass.getDeclaredAnnotations();
        for (int i = 0; i < annotationArray.length; ++i) {
            Annotation annotation;
            Annotation annotation2 = annotation = annotationArray[i];
            Intrinsics.checkExpressionValueIsNotNull((Object)annotation2, (String)"annotation");
            this.processAnnotation(visitor, annotation2);
        }
        visitor.visitEnd();
    }

    public final void visitMembers(@NotNull Class<?> klass, @NotNull KotlinJvmBinaryClass.MemberVisitor memberVisitor) {
        Intrinsics.checkParameterIsNotNull(klass, (String)"klass");
        Intrinsics.checkParameterIsNotNull((Object)memberVisitor, (String)"memberVisitor");
        this.loadMethodAnnotations(klass, memberVisitor);
        this.loadConstructorAnnotations(klass, memberVisitor);
        this.loadFieldAnnotations(klass, memberVisitor);
    }

    private final void loadMethodAnnotations(Class<?> klass, KotlinJvmBinaryClass.MemberVisitor memberVisitor) {
        Method[] methodArray = klass.getDeclaredMethods();
        for (int i = 0; i < methodArray.length; ++i) {
            KotlinJvmBinaryClass.MethodAnnotationVisitor visitor;
            Method method;
            Method method2 = method = methodArray[i];
            Intrinsics.checkExpressionValueIsNotNull((Object)method2, (String)"method");
            Name name = Name.identifier(method2.getName());
            Intrinsics.checkExpressionValueIsNotNull((Object)name, (String)"Name.identifier(method.name)");
            if (memberVisitor.visitMethod(name, SignatureSerializer.INSTANCE.methodDesc(method)) == null) {
                continue;
            }
            Annotation[] annotationArray = method.getDeclaredAnnotations();
            for (int j = 0; j < annotationArray.length; ++j) {
                Annotation annotation = annotationArray[j];
                KotlinJvmBinaryClass.AnnotationVisitor annotationVisitor = visitor;
                Annotation annotation2 = annotation;
                Intrinsics.checkExpressionValueIsNotNull((Object)annotation2, (String)"annotation");
                this.processAnnotation(annotationVisitor, annotation2);
            }
            Annotation[][] annotationArray2 = method.getParameterAnnotations();
            Intrinsics.checkExpressionValueIsNotNull((Object)annotationArray2, (String)"method.parameterAnnotations");
            for (IndexedValue indexedValue : ArraysKt.withIndex((Object[])((Object[])annotationArray2))) {
                int parameterIndex = indexedValue.component1();
                Annotation[] annotations2 = (Annotation[])indexedValue.component2();
                for (int j = 0; j < annotations2.length; ++j) {
                    KotlinJvmBinaryClass.AnnotationArgumentVisitor annotationArgumentVisitor;
                    Annotation annotation = annotations2[j];
                    Class annotationType = JvmClassMappingKt.getJavaClass((KClass)JvmClassMappingKt.getAnnotationClass((Annotation)annotation));
                    ClassId classId = ReflectClassUtilKt.getClassId(annotationType);
                    Annotation annotation3 = annotation;
                    Intrinsics.checkExpressionValueIsNotNull((Object)annotation3, (String)"annotation");
                    if (visitor.visitParameterAnnotation(parameterIndex, classId, new ReflectAnnotationSource(annotation3)) == null) continue;
                    KotlinJvmBinaryClass.AnnotationArgumentVisitor it = annotationArgumentVisitor;
                    INSTANCE.processAnnotationArguments(it, annotation, annotationType);
                }
            }
            visitor.visitEnd();
        }
    }

    private final void loadConstructorAnnotations(Class<?> klass, KotlinJvmBinaryClass.MemberVisitor memberVisitor) {
        Constructor<?>[] constructorArray = klass.getDeclaredConstructors();
        for (int i = 0; i < constructorArray.length; ++i) {
            KotlinJvmBinaryClass.MethodAnnotationVisitor visitor;
            Constructor<?> constructor = constructorArray[i];
            Name name = Name.special("<init>");
            Intrinsics.checkExpressionValueIsNotNull((Object)name, (String)"Name.special(\"<init>\")");
            Constructor<?> constructor2 = constructor;
            Intrinsics.checkExpressionValueIsNotNull(constructor2, (String)"constructor");
            if (memberVisitor.visitMethod(name, SignatureSerializer.INSTANCE.constructorDesc(constructor2)) == null) {
                continue;
            }
            IndexedValue indexedValue2 = constructor.getDeclaredAnnotations();
            for (int j = 0; j < ((Annotation[])indexedValue2).length; ++j) {
                Annotation annotation = indexedValue2[j];
                KotlinJvmBinaryClass.AnnotationVisitor annotationVisitor = visitor;
                Annotation annotation2 = annotation;
                Intrinsics.checkExpressionValueIsNotNull((Object)annotation2, (String)"annotation");
                this.processAnnotation(annotationVisitor, annotation2);
            }
            Annotation[][] parameterAnnotations = constructor.getParameterAnnotations();
            Intrinsics.checkExpressionValueIsNotNull((Object)parameterAnnotations, (String)"parameterAnnotations");
            Object[] objectArray = (Object[])parameterAnnotations;
            indexedValue2 = objectArray;
            if (!(((Object[])indexedValue2).length == 0)) {
                int shift = ((Object[])constructor.getParameterTypes()).length - ((Object[])parameterAnnotations).length;
                for (IndexedValue indexedValue2 : ArraysKt.withIndex((Object[])((Object[])parameterAnnotations))) {
                    int parameterIndex = indexedValue2.component1();
                    Annotation[] annotations2 = (Annotation[])indexedValue2.component2();
                    for (int j = 0; j < annotations2.length; ++j) {
                        KotlinJvmBinaryClass.AnnotationArgumentVisitor annotationArgumentVisitor;
                        Annotation annotation = annotations2[j];
                        Class annotationType = JvmClassMappingKt.getJavaClass((KClass)JvmClassMappingKt.getAnnotationClass((Annotation)annotation));
                        ClassId classId = ReflectClassUtilKt.getClassId(annotationType);
                        Annotation annotation3 = annotation;
                        Intrinsics.checkExpressionValueIsNotNull((Object)annotation3, (String)"annotation");
                        if (visitor.visitParameterAnnotation(parameterIndex + shift, classId, new ReflectAnnotationSource(annotation3)) == null) continue;
                        KotlinJvmBinaryClass.AnnotationArgumentVisitor it = annotationArgumentVisitor;
                        INSTANCE.processAnnotationArguments(it, annotation, annotationType);
                    }
                }
            }
            visitor.visitEnd();
        }
    }

    private final void loadFieldAnnotations(Class<?> klass, KotlinJvmBinaryClass.MemberVisitor memberVisitor) {
        Field[] fieldArray = klass.getDeclaredFields();
        for (int i = 0; i < fieldArray.length; ++i) {
            KotlinJvmBinaryClass.AnnotationVisitor visitor;
            Field field;
            Field field2 = field = fieldArray[i];
            Intrinsics.checkExpressionValueIsNotNull((Object)field2, (String)"field");
            Name name = Name.identifier(field2.getName());
            Intrinsics.checkExpressionValueIsNotNull((Object)name, (String)"Name.identifier(field.name)");
            if (memberVisitor.visitField(name, SignatureSerializer.INSTANCE.fieldDesc(field), null) == null) {
                continue;
            }
            Annotation[] annotationArray = field.getDeclaredAnnotations();
            for (int j = 0; j < annotationArray.length; ++j) {
                Annotation annotation;
                Annotation annotation2 = annotation = annotationArray[j];
                Intrinsics.checkExpressionValueIsNotNull((Object)annotation2, (String)"annotation");
                this.processAnnotation(visitor, annotation2);
            }
            visitor.visitEnd();
        }
    }

    private final void processAnnotation(KotlinJvmBinaryClass.AnnotationVisitor visitor, Annotation annotation) {
        block0: {
            KotlinJvmBinaryClass.AnnotationArgumentVisitor annotationArgumentVisitor;
            Class annotationType = JvmClassMappingKt.getJavaClass((KClass)JvmClassMappingKt.getAnnotationClass((Annotation)annotation));
            KotlinJvmBinaryClass.AnnotationArgumentVisitor annotationArgumentVisitor2 = visitor.visitAnnotation(ReflectClassUtilKt.getClassId(annotationType), new ReflectAnnotationSource(annotation));
            if (annotationArgumentVisitor2 == null) break block0;
            KotlinJvmBinaryClass.AnnotationArgumentVisitor it = annotationArgumentVisitor = annotationArgumentVisitor2;
            INSTANCE.processAnnotationArguments(it, annotation, annotationType);
        }
    }

    private final void processAnnotationArguments(KotlinJvmBinaryClass.AnnotationArgumentVisitor visitor, Annotation annotation, Class<?> annotationType) {
        Method[] methodArray = annotationType.getDeclaredMethods();
        for (int i = 0; i < methodArray.length; ++i) {
            Object object;
            Method method;
            block3: {
                method = methodArray[i];
                try {
                    if (method.invoke((Object)annotation, new Object[0]) != null) break block3;
                    Intrinsics.throwNpe();
                }
                catch (IllegalAccessException e) {
                    continue;
                }
            }
            Object value = object;
            Method method2 = method;
            Intrinsics.checkExpressionValueIsNotNull((Object)method2, (String)"method");
            Name name = Name.identifier(method2.getName());
            Intrinsics.checkExpressionValueIsNotNull((Object)name, (String)"Name.identifier(method.name)");
            this.processAnnotationArgumentValue(visitor, name, value);
        }
        visitor.visitEnd();
    }

    private final void processAnnotationArgumentValue(KotlinJvmBinaryClass.AnnotationArgumentVisitor visitor, Name name, Object value) {
        Class<?> clazz = value.getClass();
        if (ReflectKotlinClassKt.access$getTYPES_ELIGIBLE_FOR_SIMPLE_VISIT$p().contains(clazz)) {
            visitor.visit(name, value);
        } else if (ReflectClassUtilKt.isEnumClassOrSpecializedEnumEntryClass(clazz)) {
            Class<?> clazz2 = clazz.isEnum() ? clazz : clazz.getEnclosingClass();
            Intrinsics.checkExpressionValueIsNotNull(clazz2, (String)"(if (clazz.isEnum) clazz\u2026lse clazz.enclosingClass)");
            ClassId classId = ReflectClassUtilKt.getClassId(clazz2);
            Object object = value;
            if (object == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.Enum<*>");
            }
            Name name2 = Name.identifier(((Enum)object).name());
            Intrinsics.checkExpressionValueIsNotNull((Object)name2, (String)"Name.identifier((value as Enum<*>).name)");
            visitor.visitEnum(name, classId, name2);
        } else if (Annotation.class.isAssignableFrom(clazz)) {
            Class annotationClass;
            Class<?>[] classArray = clazz.getInterfaces();
            Intrinsics.checkExpressionValueIsNotNull(classArray, (String)"clazz.interfaces");
            Class clazz3 = annotationClass = (Class)ArraysKt.single((Object[])classArray);
            Intrinsics.checkExpressionValueIsNotNull((Object)clazz3, (String)"annotationClass");
            KotlinJvmBinaryClass.AnnotationArgumentVisitor annotationArgumentVisitor = visitor.visitAnnotation(name, ReflectClassUtilKt.getClassId(clazz3));
            if (annotationArgumentVisitor == null) {
                return;
            }
            KotlinJvmBinaryClass.AnnotationArgumentVisitor v = annotationArgumentVisitor;
            Object object = value;
            if (object == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.Annotation");
            }
            this.processAnnotationArguments(v, (Annotation)object, annotationClass);
        } else if (clazz.isArray()) {
            Class<?> componentType;
            KotlinJvmBinaryClass.AnnotationArrayArgumentVisitor annotationArrayArgumentVisitor = visitor.visitArray(name);
            if (annotationArrayArgumentVisitor == null) {
                return;
            }
            KotlinJvmBinaryClass.AnnotationArrayArgumentVisitor v = annotationArrayArgumentVisitor;
            Class<?> clazz4 = componentType = clazz.getComponentType();
            Intrinsics.checkExpressionValueIsNotNull(clazz4, (String)"componentType");
            if (clazz4.isEnum()) {
                ClassId enumClassId = ReflectClassUtilKt.getClassId(componentType);
                Object object = value;
                if (object == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<*>");
                }
                Object[] objectArray = (Object[])object;
                for (int i = 0; i < objectArray.length; ++i) {
                    Object element;
                    Object object2 = element = objectArray[i];
                    if (object2 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type kotlin.Enum<*>");
                    }
                    Name name3 = Name.identifier(((Enum)object2).name());
                    Intrinsics.checkExpressionValueIsNotNull((Object)name3, (String)"Name.identifier((element as Enum<*>).name)");
                    v.visitEnum(enumClassId, name3);
                }
            } else {
                Object object = value;
                if (object == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<*>");
                }
                Object[] objectArray = (Object[])object;
                for (int i = 0; i < objectArray.length; ++i) {
                    Object element = objectArray[i];
                    v.visit(element);
                }
            }
            v.visitEnd();
        } else {
            throw (Throwable)new UnsupportedOperationException("Unsupported annotation argument value (" + clazz + "): " + value);
        }
    }

    private ReflectClassStructure() {
    }

    static {
        ReflectClassStructure reflectClassStructure;
        INSTANCE = reflectClassStructure = new ReflectClassStructure();
    }
}

