/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dmserver.libraries.tree;

import com.intellij.dmserver.editor.AvailableBundlesProvider;
import com.intellij.dmserver.libraries.BundleDefinition;
import com.intellij.dmserver.libraries.BundleWrapper;
import com.intellij.dmserver.libraries.LibraryDefinition;
import com.intellij.dmserver.libraries.ServerLibrariesContext;
import com.intellij.dmserver.libraries.tree.ArtifactFolderElementBase;
import com.intellij.dmserver.libraries.tree.BundleItemElementBase;
import com.intellij.dmserver.libraries.tree.LibraryBundleElement;
import com.intellij.dmserver.libraries.tree.UnparsableLibraryBundleElement;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.osmorc.manifest.lang.psi.Clause;

public class LibraryElement
extends ArtifactFolderElementBase {
    private static final Comparator<BundleDefinition> BY_SYMBOLIC_NAME = (o1, o2) -> {
        String name1 = o1.getSymbolicName();
        String name2 = o2.getSymbolicName();
        return name1.compareTo(name2);
    };
    private LibraryDefinition myLibraryDefinition;

    public LibraryElement(ServerLibrariesContext context, LibraryDefinition libraryDefinition) {
        super(context, LibraryElement.createKey(libraryDefinition));
        this.myLibraryDefinition = libraryDefinition;
    }

    public LibraryDefinition getLibraryDefinition() {
        return this.myLibraryDefinition;
    }

    @NonNls
    private static String createKey(LibraryDefinition libraryDefinition) {
        return "library::" + libraryDefinition.getLibDefFile().getPath();
    }

    protected void update(PresentationData presentation) {
        presentation.setPresentableText(this.myLibraryDefinition.getSymbolicName() + " (" + this.myLibraryDefinition.getVersion() + ")");
        LibraryElement.updateIcons(presentation);
    }

    @NotNull
    public Collection<? extends AbstractTreeNode> getChildren() {
        ArrayList<BundleItemElementBase> result = new ArrayList<BundleItemElementBase>();
        HashMap<String, BundleWrapper> bundles = new HashMap<String, BundleWrapper>();
        for (BundleWrapper bundle : AvailableBundlesProvider.getInstance(this.getProject()).getAllRepositoryBundles()) {
            bundles.put(LibraryElement.createBundleKey(bundle.getSymbolicName(), bundle.getVersion()), bundle);
        }
        ArrayList<BundleDefinition> bundleDefs = new ArrayList<BundleDefinition>(this.myLibraryDefinition.getBundleDefs());
        Collections.sort(bundleDefs, BY_SYMBOLIC_NAME);
        for (BundleDefinition bundleDef : bundleDefs) {
            BundleWrapper bundle = (BundleWrapper)bundles.get(LibraryElement.createBundleKey(bundleDef.getSymbolicName(), bundleDef.getVersion()));
            boolean missing = bundle == null;
            result.add(new LibraryBundleElement(this.getProject(), bundleDef, missing, missing ? null : bundle.getJarFile()));
        }
        for (Clause clause : this.myLibraryDefinition.getUnparsableClauses()) {
            result.add(new UnparsableLibraryBundleElement(this.getProject(), clause));
        }
        ArrayList<BundleItemElementBase> arrayList = result;
        if (arrayList == null) {
            LibraryElement.$$$reportNull$$$0(0);
        }
        return arrayList;
    }

    private static String createBundleKey(String symbolicName, String version) {
        return symbolicName + "::" + version;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dmserver/libraries/tree/LibraryElement", "getChildren"));
    }
}

