/*
 * Decompiled with CFR 0.152.
 */
package org.angularjs.cli;

import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.CapturingProcessHandler;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.javascript.nodejs.CompletionModuleInfo;
import com.intellij.javascript.nodejs.NodeModuleSearchUtil;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterManager;
import com.intellij.javascript.nodejs.interpreter.local.NodeJsLocalInterpreter;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.gist.GistManager;
import com.intellij.util.gist.VirtualFileGist;
import com.intellij.util.io.DataExternalizer;
import java.io.File;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import org.angularjs.cli.AngularJSProjectConfigurator;
import org.angularjs.cli.Blueprint;
import org.angularjs.cli.BlueprintParser;
import org.angularjs.cli.BlueprintsExternalizer;
import org.angularjs.cli.BlueprintsLoaderKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=2, d1={"\u0000 \n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u001e\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00030\u00022\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002\u001a\u001a\u0010\n\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\u000b\u001a\u0004\u0018\u00010\t\"(\u0010\u0000\u001a\u001c\u0012\u0018\u0012\u0016\u0012\u0004\u0012\u00020\u0003 \u0004*\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u00020\u00020\u0001X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"ourGist", "Lcom/intellij/util/gist/VirtualFileGist;", "", "Lorg/angularjs/cli/Blueprint;", "kotlin.jvm.PlatformType", "doLoad", "project", "Lcom/intellij/openapi/project/Project;", "cli", "Lcom/intellij/openapi/vfs/VirtualFile;", "findAngularCliFolder", "file", "AngularJS"})
public final class BlueprintsLoaderKt {
    private static VirtualFileGist<List<Blueprint>> ourGist = GistManager.getInstance().newVirtualFileGist("AngularBlueprints", 1, (DataExternalizer)new BlueprintsExternalizer(), (VirtualFileGist.GistCalculator)ourGist.1.INSTANCE);

    private static final List<Blueprint> doLoad(Project project, VirtualFile cli) {
        NodeJsInterpreter interpreter = NodeJsInterpreterManager.getInstance((Project)project).getInterpreter();
        NodeJsLocalInterpreter nodeJsLocalInterpreter = NodeJsLocalInterpreter.tryCast((NodeJsInterpreter)interpreter);
        if (nodeJsLocalInterpreter == null) {
            return CollectionsKt.emptyList();
        }
        NodeJsLocalInterpreter node = nodeJsLocalInterpreter;
        List modules = new ArrayList();
        NodeModuleSearchUtil.findModulesWithName((List)modules, (String)"@angular/cli", (VirtualFile)cli, (boolean)false, (NodeJsInterpreter)((NodeJsInterpreter)node));
        CompletionModuleInfo completionModuleInfo = (CompletionModuleInfo)CollectionsKt.firstOrNull((List)modules);
        if (completionModuleInfo == null) {
            return CollectionsKt.emptyList();
        }
        CompletionModuleInfo module = completionModuleInfo;
        StringBuilder stringBuilder = new StringBuilder().append("");
        VirtualFile virtualFile = module.getVirtualFile();
        if (virtualFile == null) {
            Intrinsics.throwNpe();
        }
        String moduleExe = stringBuilder.append(virtualFile.getPath()).append("").append(File.separator).append("bin").append(File.separator).append("ng").toString();
        GeneralCommandLine commandLine = new GeneralCommandLine(new String[]{node.getInterpreterSystemDependentPath(), moduleExe, "help", "generate"});
        commandLine.withWorkDirectory(cli.getPath());
        CapturingProcessHandler handler = new CapturingProcessHandler(commandLine);
        ProcessOutput output = handler.runProcess();
        if (output.getExitCode() == 0) {
            BlueprintParser blueprintParser = new BlueprintParser();
            String string = output.getStdout();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"output.stdout");
            Iterable $receiver$iv = blueprintParser.parse(string);
            return CollectionsKt.sortedWith((Iterable)$receiver$iv, (Comparator)new Comparator<T>(){

                public final int compare(T a, T b) {
                    Blueprint it = (Blueprint)a;
                    Comparable comparable = (Comparable)((Object)it.getName());
                    it = (Blueprint)b;
                    Comparable comparable2 = comparable;
                    String string = it.getName();
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)string)));
                }
            });
        }
        return CollectionsKt.emptyList();
    }

    @Nullable
    public static final VirtualFile findAngularCliFolder(@NotNull Project project, @Nullable VirtualFile file) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        for (VirtualFile current = file; current != null; current = current.getParent()) {
            if (!current.isDirectory() || AngularJSProjectConfigurator.findCliJson(current) == null) continue;
            return current;
        }
        if (AngularJSProjectConfigurator.findCliJson(project.getBaseDir()) != null) {
            return project.getBaseDir();
        }
        return null;
    }

    @NotNull
    public static final /* synthetic */ VirtualFileGist access$getOurGist$p() {
        return ourGist;
    }

    public static final /* synthetic */ void access$setOurGist$p(@NotNull VirtualFileGist virtualFileGist) {
        ourGist = virtualFileGist;
    }

    @NotNull
    public static final /* synthetic */ List access$doLoad(@NotNull Project project, @NotNull VirtualFile cli) {
        return BlueprintsLoaderKt.doLoad(project, cli);
    }
}

