/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.mvc.config.viewresolver;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.spring.boot.mvc.config.viewresolver.SpringBootAutoConfigurationViewResolverFactoryBase;
import com.intellij.spring.contexts.model.SpringModel;
import com.intellij.spring.model.CommonSpringBean;
import com.intellij.spring.model.utils.SpringCommonUtils;
import com.intellij.spring.web.mvc.views.ViewResolver;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FreemarkerWebAutoConfigurationViewResolverFactory
extends SpringBootAutoConfigurationViewResolverFactoryBase {
    private static final Set<String> VIEW_RESOLVER_CLASS_NAMES = ContainerUtil.immutableSet((Object[])new String[]{"org.springframework.web.servlet.view.freemarker.FreeMarkerViewResolver"});
    private static final Set<String> AUTOCONFIG_CLASSES = ContainerUtil.immutableSet((Object[])new String[]{"org.springframework.boot.autoconfigure.freemarker.FreeMarkerAutoConfiguration.FreeMarkerWebConfiguration"});

    @Override
    @NotNull
    protected String getViewResolverBeanName() {
        if ("freeMarkerViewResolver" == null) {
            FreemarkerWebAutoConfigurationViewResolverFactory.$$$reportNull$$$0(0);
        }
        return "freeMarkerViewResolver";
    }

    @Override
    @NotNull
    protected Set<String> getViewResolverClassNames() {
        Set<String> set = VIEW_RESOLVER_CLASS_NAMES;
        if (set == null) {
            FreemarkerWebAutoConfigurationViewResolverFactory.$$$reportNull$$$0(1);
        }
        return set;
    }

    @Override
    @NotNull
    protected Set<String> getAutoConfigurationClassNames() {
        Set<String> set = AUTOCONFIG_CLASSES;
        if (set == null) {
            FreemarkerWebAutoConfigurationViewResolverFactory.$$$reportNull$$$0(2);
        }
        return set;
    }

    @NotNull
    protected Set<ViewResolver> doCreate(@Nullable CommonSpringBean bean, SpringModel model) {
        String prefix = StringUtil.notNullize((String)FreemarkerWebAutoConfigurationViewResolverFactory.getConfigurationOrDefaultValue(model, "spring.freemarker.prefix"), (String)"");
        String suffix = StringUtil.notNullize((String)FreemarkerWebAutoConfigurationViewResolverFactory.getConfigurationOrDefaultValue(model, "spring.freemarker.suffix"), (String)".ftl");
        List<String> paths = FreemarkerWebAutoConfigurationViewResolverFactory.getTemplateLoaderPaths(model);
        LinkedHashSet<ViewResolver> resolvers = new LinkedHashSet<ViewResolver>(paths.size());
        for (String path : paths) {
            resolvers.add(this.createURLBasedViewResolver(path + prefix, suffix));
        }
        LinkedHashSet<ViewResolver> linkedHashSet = resolvers;
        if (linkedHashSet == null) {
            FreemarkerWebAutoConfigurationViewResolverFactory.$$$reportNull$$$0(3);
        }
        return linkedHashSet;
    }

    private static List<String> getTemplateLoaderPaths(SpringModel model) {
        String value = FreemarkerWebAutoConfigurationViewResolverFactory.getConfigurationOrDefaultValue(model, "spring.freemarker.template-loader-path");
        if (value == null) {
            return Collections.emptyList();
        }
        value = value.replace('[', ' ').replace(']', ' ').replace('\"', ' ');
        return SpringCommonUtils.tokenize((String)value);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/spring/boot/mvc/config/viewresolver/FreemarkerWebAutoConfigurationViewResolverFactory";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getViewResolverBeanName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getViewResolverClassNames";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getAutoConfigurationClassNames";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "doCreate";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

