/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.nodeJs;

import com.intellij.conversion.ConversionContext;
import com.intellij.conversion.ConversionProcessor;
import com.intellij.conversion.ConverterProvider;
import com.intellij.conversion.ProjectConverter;
import com.intellij.conversion.RunManagerSettings;
import com.jetbrains.debugger.wip.JSRemoteDebugConfigurationType;
import com.jetbrains.nodeJs.NodeJsRemoteDebugConfigurationConverterProvider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jdom.Attribute;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\fH\u0016J\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u000f"}, d2={"Lcom/jetbrains/nodeJs/NodeJsRemoteDebugConfigurationConverterProvider;", "Lcom/intellij/conversion/ConverterProvider;", "()V", "convert", "", "element", "Lorg/jdom/Element;", "createConverter", "Lcom/intellij/conversion/ProjectConverter;", "context", "Lcom/intellij/conversion/ConversionContext;", "getConversionDescription", "", "isNodeJsRemoteDebugConfiguration", "", "ChromeConnector"})
public final class NodeJsRemoteDebugConfigurationConverterProvider
extends ConverterProvider {
    @NotNull
    public String getConversionDescription() {
        return "Node.js Remote debug configuration will be converted into unified \"Attach to Node.js/Chrome\" configuration";
    }

    @NotNull
    public ProjectConverter createConverter(@NotNull ConversionContext context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        return new ProjectConverter(this){
            final /* synthetic */ NodeJsRemoteDebugConfigurationConverterProvider this$0;

            @Nullable
            public ConversionProcessor<RunManagerSettings> createRunConfigurationsConverter() {
                return (ConversionProcessor)new ConversionProcessor<RunManagerSettings>(this){
                    final /* synthetic */ createConverter.1 this$0;

                    public boolean isConversionNeeded(@NotNull RunManagerSettings settings) {
                        boolean bl;
                        block3: {
                            Intrinsics.checkParameterIsNotNull((Object)settings, (String)"settings");
                            Iterable $receiver$iv = settings.getRunConfigurations();
                            if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                                bl = false;
                            } else {
                                for (T element$iv : $receiver$iv) {
                                    Element it = (Element)element$iv;
                                    NodeJsRemoteDebugConfigurationConverterProvider nodeJsRemoteDebugConfigurationConverterProvider = this.this$0.this$0;
                                    Element element = it;
                                    Intrinsics.checkExpressionValueIsNotNull((Object)element, (String)"it");
                                    if (!nodeJsRemoteDebugConfigurationConverterProvider.isNodeJsRemoteDebugConfiguration(element)) continue;
                                    bl = true;
                                    break block3;
                                }
                                bl = false;
                            }
                        }
                        return bl;
                    }

                    /*
                     * WARNING - void declaration
                     */
                    public void process(@NotNull RunManagerSettings settings) {
                        void $receiver$iv$iv;
                        Intrinsics.checkParameterIsNotNull((Object)settings, (String)"settings");
                        Iterable $receiver$iv = settings.getRunConfigurations();
                        Iterable iterable = $receiver$iv;
                        Collection destination$iv$iv = new ArrayList<E>();
                        for (T element$iv$iv : $receiver$iv$iv) {
                            Element it = (Element)element$iv$iv;
                            NodeJsRemoteDebugConfigurationConverterProvider nodeJsRemoteDebugConfigurationConverterProvider = this.this$0.this$0;
                            Element element = it;
                            Intrinsics.checkExpressionValueIsNotNull((Object)element, (String)"it");
                            if (!nodeJsRemoteDebugConfigurationConverterProvider.isNodeJsRemoteDebugConfiguration(element)) continue;
                            destination$iv$iv.add(element$iv$iv);
                        }
                        $receiver$iv = (List)destination$iv$iv;
                        for (E element$iv : $receiver$iv) {
                            Element it = (Element)element$iv;
                            NodeJsRemoteDebugConfigurationConverterProvider nodeJsRemoteDebugConfigurationConverterProvider = this.this$0.this$0;
                            Element element = it;
                            Intrinsics.checkExpressionValueIsNotNull((Object)element, (String)"it");
                            nodeJsRemoteDebugConfigurationConverterProvider.convert(element);
                        }
                    }
                    {
                        this.this$0 = $outer;
                    }
                };
            }
            {
                this.this$0 = $outer;
            }
        };
    }

    public final boolean isNodeJsRemoteDebugConfiguration(@NotNull Element element) {
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        String string = element.getAttributeValue("type");
        if (string == null) {
            Intrinsics.throwNpe();
        }
        return StringsKt.equals((String)"NodeJSRemoteDebug", (String)string, (boolean)true) && Intrinsics.areEqual((Object)"true", (Object)element.getAttributeValue("default")) ^ true;
    }

    public final void convert(@NotNull Element element) {
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        element.setAttribute("type", JSRemoteDebugConfigurationType.Companion.getID());
        element.setAttribute("factoryName", JSRemoteDebugConfigurationType.Companion.getFACTORY_ID());
        element.setAttribute("isV8Legacy", "true");
        ListIterator iterator = element.getChildren().listIterator();
        while (iterator.hasNext()) {
            Attribute it;
            Attribute attribute;
            Element next = (Element)iterator.next();
            if (!Intrinsics.areEqual((Object)next.getName(), (Object)"node-js-remote-debug")) continue;
            if (next.getAttribute("host") != null) {
                it = attribute;
                element.setAttribute("host", it.getValue());
            }
            if (next.getAttribute("debug-port") != null) {
                it = attribute;
                element.setAttribute("port", it.getValue());
            }
            iterator.remove();
        }
    }

    public NodeJsRemoteDebugConfigurationConverterProvider() {
        super("nodejs-remote-debug-configuration-converter");
    }
}

