/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.reactnative;

import com.intellij.execution.ExecutionResult;
import com.intellij.execution.Executor;
import com.intellij.execution.configuration.EnvironmentVariablesData;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.LocatableConfigurationBase;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.ide.browsers.BrowserFamily;
import com.intellij.ide.browsers.WebBrowser;
import com.intellij.ide.browsers.WebBrowserManager;
import com.intellij.javascript.JSRunProfileWithCompileBeforeLaunchOption;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterRef;
import com.intellij.javascript.nodejs.interpreter.local.NodeJsLocalInterpreter;
import com.intellij.javascript.nodejs.util.NodePackage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.JDOMExternalizerUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.execution.ParametersListUtil;
import com.intellij.xdebugger.XDebugProcess;
import com.intellij.xdebugger.XDebugSession;
import com.jetbrains.nodeJs.NodeJSDebuggableConfiguration;
import com.jetbrains.plugins.reactnative.ReactNativeConfigurationEditor;
import com.jetbrains.plugins.reactnative.ReactNativePlatform;
import com.jetbrains.plugins.reactnative.ReactNativeProcessState;
import com.jetbrains.plugins.reactnative.ReactNativeRunConfigurationKt;
import java.net.InetSocketAddress;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u00a2\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B\u0015\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010@\u001a\u00020AH\u0016J*\u0010B\u001a\u00020C2\u0006\u0010D\u001a\u00020E2\u0006\u0010F\u001a\u00020G2\b\u0010H\u001a\u0004\u0018\u00010I2\u0006\u0010J\u001a\u00020KH\u0016J\u0006\u0010L\u001a\u00020\u000eJ\b\u0010M\u001a\u00020NH\u0016J\u0018\u0010O\u001a\u00020P2\u0006\u0010Q\u001a\u00020R2\u0006\u0010J\u001a\u00020KH\u0016J\u0012\u0010S\u001a\u00020A2\b\u0010T\u001a\u0004\u0018\u00010UH\u0016J\u0012\u0010V\u001a\u00020A2\b\u0010T\u001a\u0004\u0018\u00010UH\u0016R\u0013\u0010\t\u001a\u0004\u0018\u00010\n8F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u001c\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0013\u001a\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0010R\u001a\u0010\u0015\u001a\u00020\u0016X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\u001a\u0010\u001b\u001a\u00020\u001cX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 R\u001a\u0010!\u001a\u00020\"X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010$\"\u0004\b%\u0010&R\u001a\u0010'\u001a\u00020\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b(\u0010\u0010\"\u0004\b)\u0010\u0012R\u0011\u0010*\u001a\u00020+8F\u00a2\u0006\u0006\u001a\u0004\b,\u0010-R\u001a\u0010.\u001a\u00020/X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b0\u00101\"\u0004\b2\u00103R\u001c\u00104\u001a\u0004\u0018\u000105X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b6\u00107\"\u0004\b8\u00109R\u001a\u0010:\u001a\u00020\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b;\u0010\u0010\"\u0004\b<\u0010\u0012R\u001a\u0010=\u001a\u00020\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b>\u0010\u0010\"\u0004\b?\u0010\u0012\u00a8\u0006W"}, d2={"Lcom/jetbrains/plugins/reactnative/ReactNativeRunConfiguration;", "Lcom/intellij/execution/configurations/LocatableConfigurationBase;", "Lcom/jetbrains/nodeJs/NodeJSDebuggableConfiguration;", "Lcom/intellij/javascript/JSRunProfileWithCompileBeforeLaunchOption;", "project", "Lcom/intellij/openapi/project/Project;", "factory", "Lcom/intellij/execution/configurations/ConfigurationFactory;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/execution/configurations/ConfigurationFactory;)V", "browser", "Lcom/intellij/ide/browsers/WebBrowser;", "getBrowser", "()Lcom/intellij/ide/browsers/WebBrowser;", "browserId", "", "getBrowserId", "()Ljava/lang/String;", "setBrowserId", "(Ljava/lang/String;)V", "effectiveWorkingDirectory", "getEffectiveWorkingDirectory", "envData", "Lcom/intellij/execution/configuration/EnvironmentVariablesData;", "getEnvData", "()Lcom/intellij/execution/configuration/EnvironmentVariablesData;", "setEnvData", "(Lcom/intellij/execution/configuration/EnvironmentVariablesData;)V", "nodePath", "Lcom/intellij/javascript/nodejs/interpreter/NodeJsInterpreterRef;", "getNodePath", "()Lcom/intellij/javascript/nodejs/interpreter/NodeJsInterpreterRef;", "setNodePath", "(Lcom/intellij/javascript/nodejs/interpreter/NodeJsInterpreterRef;)V", "onlyStartPackager", "", "getOnlyStartPackager", "()Z", "setOnlyStartPackager", "(Z)V", "packagerArguments", "getPackagerArguments", "setPackagerArguments", "packagerPort", "", "getPackagerPort", "()I", "platform", "Lcom/jetbrains/plugins/reactnative/ReactNativePlatform;", "getPlatform", "()Lcom/jetbrains/plugins/reactnative/ReactNativePlatform;", "setPlatform", "(Lcom/jetbrains/plugins/reactnative/ReactNativePlatform;)V", "reactNativePackage", "Lcom/intellij/javascript/nodejs/util/NodePackage;", "getReactNativePackage", "()Lcom/intellij/javascript/nodejs/util/NodePackage;", "setReactNativePackage", "(Lcom/intellij/javascript/nodejs/util/NodePackage;)V", "runArguments", "getRunArguments", "setRunArguments", "workingDirectory", "getWorkingDirectory", "setWorkingDirectory", "checkConfiguration", "", "createDebugProcess", "Lcom/intellij/xdebugger/XDebugProcess;", "socketAddress", "Ljava/net/InetSocketAddress;", "session", "Lcom/intellij/xdebugger/XDebugSession;", "executionResult", "Lcom/intellij/execution/ExecutionResult;", "environment", "Lcom/intellij/execution/runners/ExecutionEnvironment;", "findWorkingDirectory", "getConfigurationEditor", "Lcom/jetbrains/plugins/reactnative/ReactNativeConfigurationEditor;", "getState", "Lcom/intellij/execution/configurations/RunProfileState;", "executor", "Lcom/intellij/execution/Executor;", "readExternal", "element", "Lorg/jdom/Element;", "writeExternal", "ReactNativeDebugger"})
public final class ReactNativeRunConfiguration
extends LocatableConfigurationBase
implements NodeJSDebuggableConfiguration,
JSRunProfileWithCompileBeforeLaunchOption {
    @Nullable
    private NodePackage reactNativePackage;
    @NotNull
    private NodeJsInterpreterRef nodePath;
    @NotNull
    private String workingDirectory;
    private boolean onlyStartPackager;
    @NotNull
    private String packagerArguments;
    @NotNull
    private ReactNativePlatform platform;
    @NotNull
    private String runArguments;
    @NotNull
    private EnvironmentVariablesData envData;
    @Nullable
    private String browserId;

    @Nullable
    public final NodePackage getReactNativePackage() {
        return this.reactNativePackage;
    }

    public final void setReactNativePackage(@Nullable NodePackage nodePackage) {
        this.reactNativePackage = nodePackage;
    }

    @NotNull
    public final NodeJsInterpreterRef getNodePath() {
        return this.nodePath;
    }

    public final void setNodePath(@NotNull NodeJsInterpreterRef nodeJsInterpreterRef) {
        Intrinsics.checkParameterIsNotNull((Object)nodeJsInterpreterRef, (String)"<set-?>");
        this.nodePath = nodeJsInterpreterRef;
    }

    @NotNull
    public final String getWorkingDirectory() {
        return this.workingDirectory;
    }

    public final void setWorkingDirectory(@NotNull String string) {
        Intrinsics.checkParameterIsNotNull((Object)string, (String)"<set-?>");
        this.workingDirectory = string;
    }

    public final boolean getOnlyStartPackager() {
        return this.onlyStartPackager;
    }

    public final void setOnlyStartPackager(boolean bl) {
        this.onlyStartPackager = bl;
    }

    @NotNull
    public final String getPackagerArguments() {
        return this.packagerArguments;
    }

    public final void setPackagerArguments(@NotNull String string) {
        Intrinsics.checkParameterIsNotNull((Object)string, (String)"<set-?>");
        this.packagerArguments = string;
    }

    @NotNull
    public final ReactNativePlatform getPlatform() {
        return this.platform;
    }

    public final void setPlatform(@NotNull ReactNativePlatform reactNativePlatform) {
        Intrinsics.checkParameterIsNotNull((Object)reactNativePlatform, (String)"<set-?>");
        this.platform = reactNativePlatform;
    }

    @NotNull
    public final String getRunArguments() {
        return this.runArguments;
    }

    public final void setRunArguments(@NotNull String string) {
        Intrinsics.checkParameterIsNotNull((Object)string, (String)"<set-?>");
        this.runArguments = string;
    }

    @NotNull
    public final EnvironmentVariablesData getEnvData() {
        return this.envData;
    }

    public final void setEnvData(@NotNull EnvironmentVariablesData environmentVariablesData) {
        Intrinsics.checkParameterIsNotNull((Object)environmentVariablesData, (String)"<set-?>");
        this.envData = environmentVariablesData;
    }

    @Nullable
    public final String getBrowserId() {
        return this.browserId;
    }

    public final void setBrowserId(@Nullable String string) {
        this.browserId = string;
    }

    @NotNull
    public final String getEffectiveWorkingDirectory() {
        String string;
        CharSequence charSequence = this.workingDirectory;
        if (charSequence.length() == 0) {
            String string2 = this.findWorkingDirectory();
            string = string2;
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"findWorkingDirectory()");
        } else {
            string = this.workingDirectory;
        }
        return string;
    }

    @NotNull
    public final String findWorkingDirectory() {
        return StringUtil.notNullize((String)this.getProject().getBasePath());
    }

    @NotNull
    public XDebugProcess createDebugProcess(@NotNull InetSocketAddress socketAddress, @NotNull XDebugSession session2, @Nullable ExecutionResult executionResult, @NotNull ExecutionEnvironment environment) {
        Intrinsics.checkParameterIsNotNull((Object)socketAddress, (String)"socketAddress");
        Intrinsics.checkParameterIsNotNull((Object)session2, (String)"session");
        Intrinsics.checkParameterIsNotNull((Object)environment, (String)"environment");
        throw (Throwable)new RuntimeException("should not be called");
    }

    @NotNull
    public ReactNativeConfigurationEditor getConfigurationEditor() {
        Project project = this.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"project");
        return new ReactNativeConfigurationEditor(project);
    }

    @NotNull
    public RunProfileState getState(@NotNull Executor executor, @NotNull ExecutionEnvironment environment) {
        Intrinsics.checkParameterIsNotNull((Object)executor, (String)"executor");
        Intrinsics.checkParameterIsNotNull((Object)environment, (String)"environment");
        return new ReactNativeProcessState(this, environment);
    }

    public void checkConfiguration() {
        CharSequence charSequence;
        super.checkConfiguration();
        NodeJsInterpreter interpreter = this.nodePath.resolve(this.getProject());
        NodeJsLocalInterpreter.checkForRunConfiguration((NodeJsInterpreter)interpreter);
        NodePackage reactNative = this.reactNativePackage;
        if (reactNative == null || (charSequence = (CharSequence)reactNative.getSystemDependentPath()).length() == 0) {
            throw (Throwable)new RuntimeConfigurationException("react-native is not specified");
        }
        if (!reactNative.isValid()) {
            throw (Throwable)new RuntimeConfigurationException("invalid react-native");
        }
        WebBrowser webBrowser = this.getBrowser();
        if (webBrowser != null && webBrowser.getPath() == null) {
            throw (Throwable)new RuntimeConfigurationException("browser path is empty");
        }
    }

    public void writeExternal(@Nullable Element element) {
        super.writeExternal(element);
        if (element == null) {
            return;
        }
        CharSequence charSequence = this.workingDirectory;
        if (!(charSequence.length() == 0)) {
            JDOMExternalizerUtil.writeCustomField((Element)element, (String)ReactNativeRunConfigurationKt.access$getWORKING_DIR_TAG$p(), (String)this.workingDirectory);
        }
        JDOMExternalizerUtil.writeCustomField((Element)element, (String)ReactNativeRunConfigurationKt.access$getNODE_INTERPRETER_TAG$p(), (String)this.nodePath.getReferenceName());
        if (this.reactNativePackage != null) {
            NodePackage nodePackage = this.reactNativePackage;
            JDOMExternalizerUtil.writeCustomField((Element)element, (String)ReactNativeRunConfigurationKt.access$getREACT_NATIVE_TAG$p(), (String)(nodePackage != null ? nodePackage.getSystemIndependentPath() : null));
        }
        JDOMExternalizerUtil.writeCustomField((Element)element, (String)ReactNativeRunConfigurationKt.access$getPLATFORM_TAG$p(), (String)this.platform.name());
        charSequence = this.packagerArguments;
        if (!(charSequence.length() == 0)) {
            JDOMExternalizerUtil.writeCustomField((Element)element, (String)ReactNativeRunConfigurationKt.access$getPACKAGER_ARGUMENTS_TAG$p(), (String)this.packagerArguments);
        }
        if (!((charSequence = (CharSequence)this.runArguments).length() == 0)) {
            JDOMExternalizerUtil.writeCustomField((Element)element, (String)ReactNativeRunConfigurationKt.access$getRUN_ARGUMENTS_TAG$p(), (String)this.runArguments);
        }
        this.envData.writeExternal(element);
        if (this.onlyStartPackager) {
            JDOMExternalizerUtil.writeCustomField((Element)element, (String)ReactNativeRunConfigurationKt.access$getONLY_START_PACKAGER$p(), (String)String.valueOf(Boolean.TRUE));
        }
        if (this.browserId != null) {
            JDOMExternalizerUtil.writeCustomField((Element)element, (String)ReactNativeRunConfigurationKt.access$getBROWSER_TAG$p(), (String)this.browserId);
        }
    }

    public void readExternal(@Nullable Element element) {
        String runArguments;
        String packagerArguments;
        String platformTag;
        String reactNativeTag;
        String interpreterRefName;
        super.readExternal(element);
        if (element == null) {
            return;
        }
        String workingDir = JDOMExternalizerUtil.readCustomField((Element)element, (String)ReactNativeRunConfigurationKt.access$getWORKING_DIR_TAG$p());
        if (workingDir != null) {
            this.workingDirectory = workingDir;
        }
        if ((interpreterRefName = JDOMExternalizerUtil.readCustomField((Element)element, (String)ReactNativeRunConfigurationKt.access$getNODE_INTERPRETER_TAG$p())) != null) {
            NodeJsInterpreterRef nodeJsInterpreterRef = NodeJsInterpreterRef.create((String)interpreterRefName);
            Intrinsics.checkExpressionValueIsNotNull((Object)nodeJsInterpreterRef, (String)"NodeJsInterpreterRef.create(interpreterRefName)");
            this.nodePath = nodeJsInterpreterRef;
        }
        if ((reactNativeTag = JDOMExternalizerUtil.readCustomField((Element)element, (String)ReactNativeRunConfigurationKt.access$getREACT_NATIVE_TAG$p())) != null) {
            this.reactNativePackage = new NodePackage(reactNativeTag);
        }
        if ((platformTag = JDOMExternalizerUtil.readCustomField((Element)element, (String)ReactNativeRunConfigurationKt.access$getPLATFORM_TAG$p())) != null) {
            this.platform = ReactNativePlatform.valueOf(platformTag);
        }
        if ((packagerArguments = JDOMExternalizerUtil.readCustomField((Element)element, (String)ReactNativeRunConfigurationKt.access$getPACKAGER_ARGUMENTS_TAG$p())) != null) {
            this.packagerArguments = packagerArguments;
        }
        if ((runArguments = JDOMExternalizerUtil.readCustomField((Element)element, (String)ReactNativeRunConfigurationKt.access$getRUN_ARGUMENTS_TAG$p())) != null) {
            this.runArguments = runArguments;
        }
        EnvironmentVariablesData environmentVariablesData = EnvironmentVariablesData.readExternal((Element)element);
        Intrinsics.checkExpressionValueIsNotNull((Object)environmentVariablesData, (String)"EnvironmentVariablesData.readExternal(element)");
        this.envData = environmentVariablesData;
        String onlyStartPackager = JDOMExternalizerUtil.readCustomField((Element)element, (String)ReactNativeRunConfigurationKt.access$getONLY_START_PACKAGER$p());
        Boolean bl = Boolean.valueOf(onlyStartPackager);
        Intrinsics.checkExpressionValueIsNotNull((Object)bl, (String)"valueOf(onlyStartPackager)");
        this.onlyStartPackager = bl;
        this.browserId = JDOMExternalizerUtil.readCustomField((Element)element, (String)ReactNativeRunConfigurationKt.access$getBROWSER_TAG$p());
    }

    @Nullable
    public final WebBrowser getBrowser() {
        return WebBrowserManager.getInstance().findBrowserById(this.browserId);
    }

    public final int getPackagerPort() {
        List arguments = ParametersListUtil.parse((String)this.packagerArguments);
        int indexOfPort = arguments.indexOf("--port");
        if (indexOfPort >= 0 && indexOfPort + 1 < arguments.size()) {
            String portString = (String)arguments.get(indexOfPort + 1);
            int portInt = -1;
            try {
                Integer n = Integer.valueOf(portString);
                Intrinsics.checkExpressionValueIsNotNull((Object)n, (String)"Integer.valueOf(portString)");
                portInt = n;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (portInt >= 0) {
                return portInt;
            }
        }
        return 8081;
    }

    public ReactNativeRunConfiguration(@NotNull Project project, @NotNull ConfigurationFactory factory) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)factory, (String)"factory");
        super(project, factory, "");
        NodeJsInterpreterRef nodeJsInterpreterRef = NodeJsInterpreterRef.createProjectRef();
        Intrinsics.checkExpressionValueIsNotNull((Object)nodeJsInterpreterRef, (String)"NodeJsInterpreterRef.createProjectRef()");
        this.nodePath = nodeJsInterpreterRef;
        this.workingDirectory = "";
        this.packagerArguments = "";
        this.platform = ReactNativePlatform.ANDROID;
        this.runArguments = "";
        EnvironmentVariablesData environmentVariablesData = EnvironmentVariablesData.DEFAULT;
        Intrinsics.checkExpressionValueIsNotNull((Object)environmentVariablesData, (String)"EnvironmentVariablesData.DEFAULT");
        this.envData = environmentVariablesData;
        this.browserId = WebBrowserManager.getInstance().getFirstBrowser(BrowserFamily.CHROME).getId().toString();
    }
}

