/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.run;

import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.dashboard.RunDashboardManager;
import com.intellij.internal.statistic.AbstractProjectsUsagesCollector;
import com.intellij.internal.statistic.beans.GroupDescriptor;
import com.intellij.internal.statistic.beans.UsageDescriptor;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.spring.boot.library.SpringBootLibraryUtil;
import com.intellij.spring.boot.run.SpringBootAdditionalParameter;
import com.intellij.spring.boot.run.SpringBootApplicationConfigurationTypeBase;
import com.intellij.spring.boot.run.SpringBootApplicationRunConfiguration;
import com.intellij.util.containers.HashMap;
import com.intellij.util.containers.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class SpringBootRunUsagesCollector
extends AbstractProjectsUsagesCollector {
    @NotNull
    public GroupDescriptor getGroupId() {
        GroupDescriptor groupDescriptor = GroupDescriptor.create((String)"Spring Boot Run");
        if (groupDescriptor == null) {
            SpringBootRunUsagesCollector.$$$reportNull$$$0(0);
        }
        return groupDescriptor;
    }

    @NotNull
    public Set<UsageDescriptor> getProjectUsages(@NotNull Project project) {
        if (project == null) {
            SpringBootRunUsagesCollector.$$$reportNull$$$0(1);
        }
        HashSet usages = new HashSet();
        ApplicationManager.getApplication().runReadAction(() -> SpringBootRunUsagesCollector.lambda$getProjectUsages$1(project, (Set)usages));
        HashSet hashSet = usages;
        if (hashSet == null) {
            SpringBootRunUsagesCollector.$$$reportNull$$$0(2);
        }
        return hashSet;
    }

    private static void recordRunConfigBoolean(Set<UsageDescriptor> usages, String name, boolean value) {
        String key = "RunConfig_" + name + "_" + (value ? "ON" : "OFF");
        usages.add(new UsageDescriptor(key));
    }

    private static /* synthetic */ void lambda$getProjectUsages$1(@NotNull Project project, Set usages) {
        if (project == null) {
            SpringBootRunUsagesCollector.$$$reportNull$$$0(3);
        }
        if (!SpringBootLibraryUtil.hasSpringBootLibrary((Project)project)) {
            return;
        }
        List runnerAndConfigurationSettings = RunManager.getInstance((Project)project).getConfigurationSettingsList((ConfigurationType)SpringBootApplicationConfigurationTypeBase.getInstance());
        usages.add(new UsageDescriptor("RunConfigsPerProject_" + runnerAndConfigurationSettings.size()));
        HashMap mainClassCounter = new HashMap();
        for (RunnerAndConfigurationSettings settings : runnerAndConfigurationSettings) {
            RunConfiguration configuration = settings.getConfiguration();
            if (!(configuration instanceof SpringBootApplicationRunConfiguration)) continue;
            SpringBootApplicationRunConfiguration sbRunConfig = (SpringBootApplicationRunConfiguration)configuration;
            mainClassCounter.merge(sbRunConfig.getSpringBootMainClass(), 1, (integer, integer2) -> integer + 1);
            SpringBootRunUsagesCollector.recordRunConfigBoolean(usages, "ActiveProfilesSet", StringUtil.isNotEmpty((String)sbRunConfig.getActiveProfiles()));
            SpringBootRunUsagesCollector.recordRunConfigBoolean(usages, "HideBanner", sbRunConfig.isHideBanner());
            SpringBootRunUsagesCollector.recordRunConfigBoolean(usages, "DebugMode", sbRunConfig.isDebugMode());
            SpringBootRunUsagesCollector.recordRunConfigBoolean(usages, "EnableLaunchOptimization", sbRunConfig.isEnableLaunchOptimization());
            SpringBootRunUsagesCollector.recordRunConfigBoolean(usages, "EnableJmxAgent", sbRunConfig.isEnableJmxAgent());
            List<SpringBootAdditionalParameter> parameters = sbRunConfig.getAdditionalParameters();
            int additionalParamsSize = parameters.size();
            usages.add(new UsageDescriptor("RunConfig_AdditionalParams_Total_" + additionalParamsSize));
            if (additionalParamsSize <= 0) continue;
            long enabledParams = parameters.stream().filter(SpringBootAdditionalParameter::isEnabled).count();
            usages.add(new UsageDescriptor("RunConfig_AdditionalParams_Enabled_" + enabledParams));
            usages.add(new UsageDescriptor("RunConfig_AdditionalParams_Disabled_" + ((long)additionalParamsSize - enabledParams)));
        }
        boolean showRunDashboard = RunDashboardManager.getInstance((Project)project).getTypes().contains(SpringBootApplicationConfigurationTypeBase.getInstance().getId());
        usages.add(new UsageDescriptor("RunDashboardInProject_" + (showRunDashboard ? "ON" : "OFF")));
        for (Integer integer3 : mainClassCounter.values()) {
            usages.add(new UsageDescriptor("RunConfig_MainClass_Count_" + integer3));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/boot/run/SpringBootRunUsagesCollector";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroupId";
                break;
            }
            case 1: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/boot/run/SpringBootRunUsagesCollector";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getProjectUsages";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getProjectUsages";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getProjectUsages$1";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

