/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.run.lifecycle;

import com.intellij.openapi.Disposable;
import com.intellij.spring.boot.run.lifecycle.AsyncApplicationLiveProperty;
import com.intellij.spring.boot.run.lifecycle.LifecycleErrorHandler;
import com.intellij.spring.boot.run.lifecycle.LiveProperty;
import com.intellij.spring.boot.run.lifecycle.SpringBootApplicationConnector;
import com.intellij.spring.boot.run.lifecycle.SpringBootApplicationServerConfiguration;
import com.intellij.spring.boot.run.lifecycle.SpringBootModuleDescriptor;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.Nullable;

class ServerConfigurationLiveProperty
extends AsyncApplicationLiveProperty<SpringBootApplicationServerConfiguration> {
    private LiveProperty<Integer> myServerPort;
    private LiveProperty<SpringBootModuleDescriptor> myModuleDescriptor;
    private AtomicInteger myDependenciesCount = new AtomicInteger(0);

    ServerConfigurationLiveProperty(LiveProperty<String> applicationAdminJmxName, int jmxPort, LifecycleErrorHandler errorHandler, Disposable parent) {
        super(applicationAdminJmxName, jmxPort, errorHandler, parent);
    }

    ServerConfigurationLiveProperty withServerPort(LiveProperty<Integer> serverPort) {
        if (this.myServerPort == null) {
            this.myDependenciesCount.incrementAndGet();
            this.myServerPort = serverPort;
            this.myServerPort.addPropertyListener(() -> this.dependencyComputationFinished());
        }
        return this;
    }

    ServerConfigurationLiveProperty withModuleDescriptor(LiveProperty<SpringBootModuleDescriptor> moduleDescriptor) {
        if (this.myModuleDescriptor == null) {
            this.myDependenciesCount.incrementAndGet();
            this.myModuleDescriptor = moduleDescriptor;
            this.myModuleDescriptor.addPropertyListener(() -> this.dependencyComputationFinished());
        }
        return this;
    }

    private void dependencyComputationFinished() {
        int dependenciesCount = this.myDependenciesCount.decrementAndGet();
        if (dependenciesCount <= 0) {
            this.compute();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected SpringBootApplicationServerConfiguration doCompute() {
        try (SpringBootApplicationConnector connector = this.getApplicationConnector();){
            SpringBootModuleDescriptor moduleDescriptor;
            boolean sslEnabled = false;
            Object keyStore = connector.getProperty("server.ssl.key-store");
            if (keyStore != null) {
                sslEnabled = connector.getBooleanProperty("server.ssl.enabled", true);
            }
            boolean isSB20 = false;
            if (this.myModuleDescriptor != null && (moduleDescriptor = (SpringBootModuleDescriptor)this.myModuleDescriptor.getValue()) != null) {
                isSB20 = moduleDescriptor.isSB20();
            }
            Object contextPath = connector.getProperty(isSB20 ? "server.servlet.context-path" : "server.context-path");
            Object servletPath = connector.getProperty(isSB20 ? "server.servlet.path" : "server.servlet-path");
            Object address = connector.getProperty("server.address");
            MyApplicationServerConfiguration myApplicationServerConfiguration = new MyApplicationServerConfiguration(sslEnabled, contextPath == null ? null : contextPath.toString(), servletPath == null ? null : servletPath.toString(), address == null ? null : address.toString());
            return myApplicationServerConfiguration;
        }
        catch (Exception ignored) {
            return null;
        }
    }

    private static class MyApplicationServerConfiguration
    implements SpringBootApplicationServerConfiguration {
        private final boolean mySslEnabled;
        private final String myContextPath;
        private final String myServletPath;
        private final String myAddress;

        MyApplicationServerConfiguration(boolean sslEnabled, String contextPath, String servletPath, String address) {
            this.mySslEnabled = sslEnabled;
            this.myContextPath = contextPath;
            this.myServletPath = servletPath;
            this.myAddress = address;
        }

        public boolean isSslEnabled() {
            return this.mySslEnabled;
        }

        @Nullable
        public String getContextPath() {
            return this.myContextPath;
        }

        @Nullable
        public String getServletPath() {
            return this.myServletPath;
        }

        @Nullable
        public String getAddress() {
            return this.myAddress;
        }
    }
}

