/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.run.lifecycle;

import com.intellij.execution.ExecutionListener;
import com.intellij.execution.ExecutionManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.dashboard.RunDashboardListener;
import com.intellij.execution.dashboard.RunDashboardManager;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.spring.boot.run.SpringBootApplicationRunConfiguration;
import com.intellij.spring.boot.run.lifecycle.LiveProperty;
import com.intellij.spring.boot.run.lifecycle.SpringBootApplicationInfo;
import com.intellij.spring.boot.run.lifecycle.SpringBootApplicationInfoImpl;
import com.intellij.spring.boot.run.lifecycle.SpringBootApplicationLifecycleManager;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebugSessionListener;
import com.intellij.xdebugger.XDebuggerManager;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpringBootApplicationLifecycleManagerImpl
implements SpringBootApplicationLifecycleManager,
Disposable {
    private final Project myProject;
    private final Map<ProcessHandler, SpringBootApplicationInfo> myInfos = new ConcurrentHashMap<ProcessHandler, SpringBootApplicationInfo>();
    private final List<SpringBootApplicationLifecycleManager.InfoListener> myListeners = ContainerUtil.createLockFreeCopyOnWriteList();

    public SpringBootApplicationLifecycleManagerImpl(Project project) {
        this.myProject = project;
        this.init();
        Disposer.register((Disposable)project, (Disposable)this);
    }

    private void init() {
        this.myProject.getMessageBus().connect((Disposable)this.myProject).subscribe(ExecutionManager.EXECUTION_TOPIC, (Object)new ExecutionListener(){

            public void processStarted(@NotNull String executorId, @NotNull ExecutionEnvironment env, @NotNull ProcessHandler handler) {
                RunnerAndConfigurationSettings configurationSettings;
                if (executorId == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (env == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (handler == null) {
                    1.$$$reportNull$$$0(2);
                }
                if ((configurationSettings = env.getRunnerAndConfigurationSettings()) == null) {
                    return;
                }
                if (configurationSettings.getConfiguration() instanceof SpringBootApplicationRunConfiguration) {
                    Integer jmxPort = (Integer)handler.getUserData(SpringBootApplicationLifecycleManager.JMX_PORT);
                    if (jmxPort == null || jmxPort <= 0) {
                        return;
                    }
                    SpringBootApplicationInfo info = SpringBootApplicationInfoImpl.createInfo(SpringBootApplicationLifecycleManagerImpl.this.myProject, env, (SpringBootApplicationRunConfiguration)configurationSettings.getConfiguration(), jmxPort);
                    Disposer.register((Disposable)SpringBootApplicationLifecycleManagerImpl.this, (Disposable)info);
                    SpringBootApplicationLifecycleManagerImpl.this.myInfos.put(handler, info);
                    SpringBootApplicationLifecycleManagerImpl.this.myListeners.forEach(listener -> {
                        if (handler == null) {
                            1.$$$reportNull$$$0(7);
                        }
                        listener.infoAdded(handler, info);
                    });
                    final XDebugSession session = SpringBootApplicationLifecycleManagerImpl.getDebugSession(SpringBootApplicationLifecycleManagerImpl.this.myProject, handler);
                    if (session != null) {
                        final XDebugSessionListener sessionListener = new XDebugSessionListener(){

                            public void sessionResumed() {
                                ((RunDashboardListener)SpringBootApplicationLifecycleManagerImpl.this.myProject.getMessageBus().syncPublisher(RunDashboardManager.DASHBOARD_TOPIC)).contentChanged(false);
                            }
                        };
                        session.addSessionListener(sessionListener);
                        info.getReadyState().addPropertyListener(new LiveProperty.LivePropertyListener(){

                            public void propertyChanged() {
                            }

                            public void computationFinished() {
                                session.removeSessionListener(sessionListener);
                            }
                        });
                        Disposer.register((Disposable)info, () -> session.removeSessionListener(sessionListener));
                    }
                }
            }

            public void processTerminating(@NotNull String executorId, @NotNull ExecutionEnvironment env, @NotNull ProcessHandler handler) {
                SpringBootApplicationInfo info;
                if (executorId == null) {
                    1.$$$reportNull$$$0(3);
                }
                if (env == null) {
                    1.$$$reportNull$$$0(4);
                }
                if (handler == null) {
                    1.$$$reportNull$$$0(5);
                }
                if ((info = (SpringBootApplicationInfo)SpringBootApplicationLifecycleManagerImpl.this.myInfos.remove(handler)) != null) {
                    Disposer.dispose((Disposable)info);
                    SpringBootApplicationLifecycleManagerImpl.this.myListeners.forEach(listener -> {
                        if (handler == null) {
                            1.$$$reportNull$$$0(6);
                        }
                        listener.infoRemoved(handler, info);
                    });
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "executorId";
                        break;
                    }
                    case 1: 
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "env";
                        break;
                    }
                    case 2: 
                    case 5: 
                    case 6: 
                    case 7: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "handler";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/spring/boot/run/lifecycle/SpringBootApplicationLifecycleManagerImpl$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "processStarted";
                        break;
                    }
                    case 3: 
                    case 4: 
                    case 5: {
                        objectArray = objectArray2;
                        objectArray2[2] = "processTerminating";
                        break;
                    }
                    case 6: {
                        objectArray = objectArray2;
                        objectArray2[2] = "lambda$processTerminating$2";
                        break;
                    }
                    case 7: {
                        objectArray = objectArray2;
                        objectArray2[2] = "lambda$processStarted$0";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    public void dispose() {
        this.myInfos.forEach((handler, info) -> this.myListeners.forEach(listener -> listener.infoRemoved(handler, info)));
        this.myInfos.clear();
    }

    public boolean isLifecycleManagementEnabled(@NotNull ProcessHandler handler) {
        Integer jmxPort;
        if (handler == null) {
            SpringBootApplicationLifecycleManagerImpl.$$$reportNull$$$0(0);
        }
        return (jmxPort = (Integer)handler.getUserData(JMX_PORT)) != null && jmxPort > 0;
    }

    @Nullable
    public SpringBootApplicationInfo getSpringBootApplicationInfo(ProcessHandler handler) {
        return this.myInfos.get(handler);
    }

    public void addInfoListener(@NotNull SpringBootApplicationLifecycleManager.InfoListener listener) {
        if (listener == null) {
            SpringBootApplicationLifecycleManagerImpl.$$$reportNull$$$0(1);
        }
        this.myListeners.add(listener);
    }

    public void removeInfoListener(@NotNull SpringBootApplicationLifecycleManager.InfoListener listener) {
        if (listener == null) {
            SpringBootApplicationLifecycleManagerImpl.$$$reportNull$$$0(2);
        }
        this.myListeners.remove(listener);
    }

    @Nullable
    public static XDebugSession getDebugSession(Project project, ProcessHandler processHandler) {
        for (XDebugSession session : XDebuggerManager.getInstance((Project)project).getDebugSessions()) {
            if (!Comparing.equal((Object)session.getDebugProcess().getProcessHandler(), (Object)processHandler)) continue;
            return session;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "handler";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
        }
        objectArray2[1] = "com/intellij/spring/boot/run/lifecycle/SpringBootApplicationLifecycleManagerImpl";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isLifecycleManagementEnabled";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "addInfoListener";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "removeInfoListener";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

