/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.run.lifecycle;

import com.intellij.openapi.module.Module;
import com.intellij.spring.boot.library.SpringBootLibraryUtil;
import org.jetbrains.annotations.Nullable;

class SpringBootModuleDescriptor {
    private final boolean mySB20;
    private final boolean myActuatorsEnabled;
    private final boolean myMappingsEnabled;

    static SpringBootModuleDescriptor getDescriptor(@Nullable Module module) {
        return new SpringBootModuleDescriptor(SpringBootLibraryUtil.isAtLeastVersion((Module)module, (SpringBootLibraryUtil.SpringBootVersion)SpringBootLibraryUtil.SpringBootVersion.VERSION_2_0_0), SpringBootLibraryUtil.hasActuators((Module)module), SpringBootLibraryUtil.hasRequestMappings((Module)module));
    }

    private SpringBootModuleDescriptor(boolean isSB20, boolean actuatorsEnabled, boolean mappingsEnabled) {
        this.mySB20 = isSB20;
        this.myActuatorsEnabled = actuatorsEnabled;
        this.myMappingsEnabled = mappingsEnabled;
    }

    public boolean isSB20() {
        return this.mySB20;
    }

    public boolean isActuatorsEnabled() {
        return this.myActuatorsEnabled;
    }

    public boolean isMappingsEnabled() {
        return this.myMappingsEnabled;
    }
}

