/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.webDeployment.ui;

import com.intellij.notification.Notification;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.jetbrains.plugins.webDeployment.WDBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DeploymentNotifier {
    private static final String WEB_DEPLOYMENT_BALLOON_GROUP = WDBundle.message("web.deployment.balloon.group.id", new Object[0]);
    private static final NotificationGroup BALLOON_GROUP = NotificationGroup.balloonGroup((String)WEB_DEPLOYMENT_BALLOON_GROUP);

    private DeploymentNotifier() {
    }

    public static void notifyWithBalloon(@Nullable String title, String message, NotificationType messageType, Project project, @Nullable ToolWindowIdProvider toolWindowIdProvider, AnAction ... actions) {
        ToolWindow toolWindow = null;
        if (toolWindowIdProvider != null && project != null && !project.isDefault()) {
            ToolWindowManager mgr = ToolWindowManager.getInstance((Project)project);
            toolWindow = mgr.getToolWindow(toolWindowIdProvider.getId());
        }
        if (toolWindow == null) {
            Notification notification = BALLOON_GROUP.createNotification(StringUtil.notNullize((String)title), message, messageType, null);
            for (AnAction action : actions) {
                notification.addAction(action);
            }
            notification.notify(project);
            return;
        }
        ToolWindowManager.getInstance((Project)project).invokeLater(() -> {
            Notification notification = toolWindowIdProvider.getGroup().createNotification(StringUtil.notNullize((String)title), message, messageType, null);
            for (AnAction action : actions) {
                notification.addAction(action);
            }
            notification.notify(project);
        });
    }

    public static class ToolWindowIdProvider {
        private final NotificationGroup myGroup;
        @NotNull
        private final String myId;

        public ToolWindowIdProvider(@NotNull String toolWindowId) {
            if (toolWindowId == null) {
                ToolWindowIdProvider.$$$reportNull$$$0(0);
            }
            this.myId = toolWindowId;
            this.myGroup = NotificationGroup.toolWindowGroup((String)(WEB_DEPLOYMENT_BALLOON_GROUP + ": " + toolWindowId), (String)toolWindowId, (boolean)false);
        }

        @NotNull
        public String getId() {
            String string = this.myId;
            if (string == null) {
                ToolWindowIdProvider.$$$reportNull$$$0(1);
            }
            return string;
        }

        public NotificationGroup getGroup() {
            return this.myGroup;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "toolWindowId";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/plugins/webDeployment/ui/DeploymentNotifier$ToolWindowIdProvider";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/plugins/webDeployment/ui/DeploymentNotifier$ToolWindowIdProvider";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getId";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

