/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ecmascript6.psi.impl;

import com.intellij.javascript.JSFileReference;
import com.intellij.lang.ecmascript6.psi.impl.ES6CreateImportUtil;
import com.intellij.lang.ecmascript6.psi.impl.JSImportPathBuilder;
import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.javascript.frameworks.modules.JSModulePathSubstitution;
import com.intellij.lang.javascript.frameworks.modules.JSModulePattern;
import com.intellij.lang.javascript.frameworks.modules.JSPathMappingsUtil;
import com.intellij.lang.javascript.modules.JSModuleNameInfo;
import com.intellij.lang.typescript.psi.TypeScriptAutoImportUtil;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfig;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptImportPathBuilder
extends JSImportPathBuilder {
    @Nullable
    private final TypeScriptConfig myConfigFile;

    public TypeScriptImportPathBuilder(@NotNull PsiElement place, @Nullable PsiElement elementToImport, @NotNull VirtualFile importedFile, @Nullable TypeScriptConfig configFile) {
        if (place == null) {
            TypeScriptImportPathBuilder.$$$reportNull$$$0(0);
        }
        if (importedFile == null) {
            TypeScriptImportPathBuilder.$$$reportNull$$$0(1);
        }
        super(place, elementToImport, importedFile);
        this.myConfigFile = configFile;
    }

    @Override
    protected boolean useNodeResolution() {
        if (!super.useNodeResolution()) {
            return false;
        }
        if (this.myConfigFile == null) {
            return true;
        }
        TypeScriptConfig.ModuleResolution resolution = this.myConfigFile.getResolution();
        if (resolution == TypeScriptConfig.ModuleResolution.NODE) {
            return true;
        }
        return TypeScriptConfig.ModuleTarget.COMMON_JS == this.myConfigFile.getModule();
    }

    @Override
    public void processModuleNames(@NotNull Processor<JSModuleNameInfo> processor) {
        JSModuleNameInfo mappings;
        if (processor == null) {
            TypeScriptImportPathBuilder.$$$reportNull$$$0(2);
        }
        if (!this.processModuleNameUsingNodeModules(processor)) {
            return;
        }
        if (this.myConfigFile != null && (mappings = this.getModuleNameUsingPathMappings()) != null && !processor.process((Object)mappings)) {
            return;
        }
        super.processModuleNames(processor);
    }

    @Nullable
    private JSModuleNameInfo getModuleNameUsingPathMappings() {
        if (this.myConfigFile == null) {
            return null;
        }
        VirtualFile baseUrl = this.myConfigFile.getBaseUrl();
        if (baseUrl == null) {
            return null;
        }
        JSModuleNameInfo currentMapping = null;
        for (JSModulePathSubstitution substitution : this.myConfigFile.getPaths()) {
            String pattern = substitution.getPattern();
            if (StringUtil.isEmpty((String)pattern)) continue;
            for (String mapping : substitution.getMappings()) {
                JSModuleNameInfo possibleMapping;
                if (StringUtil.isEmpty((String)mapping) || (possibleMapping = this.getModuleNameForMapping(baseUrl, pattern, mapping)) == null || !TypeScriptImportPathBuilder.shouldUseNewMapping(currentMapping, possibleMapping)) continue;
                currentMapping = possibleMapping;
            }
        }
        return currentMapping;
    }

    @Nullable
    private JSModuleNameInfo getModuleNameForMapping(@NotNull VirtualFile baseUrl, @NotNull String pattern, @NotNull String mapping) {
        boolean hasSeparatorInFirstPart;
        if (baseUrl == null) {
            TypeScriptImportPathBuilder.$$$reportNull$$$0(3);
        }
        if (pattern == null) {
            TypeScriptImportPathBuilder.$$$reportNull$$$0(4);
        }
        if (mapping == null) {
            TypeScriptImportPathBuilder.$$$reportNull$$$0(5);
        }
        mapping = FileUtil.toSystemIndependentName((String)mapping);
        int starIndex = mapping.indexOf("*");
        if (pattern.length() < 2) {
            return null;
        }
        if (starIndex < 0) {
            VirtualFile pathFile = TypeScriptImportPathBuilder.getPossibleFileWithExtension(baseUrl, mapping);
            if (pathFile == null) {
                return null;
            }
            VirtualFile file = TypeScriptImportPathBuilder.isFromNestedDirectory(pathFile, this.myFileToImport) ? this.checkSymbolAndGetFile(pathFile) : null;
            return file == null ? null : new JSModuleNameInfo(pattern, pathFile, file, (PsiElement)this.myPlacePsiFile);
        }
        String firstPart = mapping.substring(0, starIndex);
        int separatorIndex = firstPart.lastIndexOf(47);
        VirtualFile startDirectory = baseUrl;
        boolean bl = hasSeparatorInFirstPart = separatorIndex >= 0;
        if (hasSeparatorInFirstPart) {
            startDirectory = JSPathMappingsUtil.getPathRelativeBaseUrlOrSelfIfAbsolute(baseUrl, firstPart.substring(0, separatorIndex));
        }
        if (startDirectory == null) {
            return null;
        }
        List<VirtualFile> parents = TypeScriptImportPathBuilder.collectParents(this.myFileToImport, startDirectory);
        if (parents.isEmpty()) {
            return null;
        }
        VirtualFile placeDirectory = this.myPlacePsiFile.getVirtualFile().getParent();
        String partOfString = mapping.substring(hasSeparatorInFirstPart ? separatorIndex : 0);
        for (VirtualFile pathFile : ContainerUtil.reverse(parents)) {
            VirtualFile file;
            String stringToCheckPattern;
            if (pathFile.equals(placeDirectory) || StringUtil.isEmpty((String)(stringToCheckPattern = VfsUtil.getPath((VirtualFile)startDirectory, (VirtualFile)pathFile, (char)'/')))) continue;
            JSModulePattern pathSubstitution = JSPathMappingsUtil.createPatternForString(partOfString);
            Pair matchedStar = JSPathMappingsUtil.findMaxElementByPaths((hasSeparatorInFirstPart ? "/" : "") + stringToCheckPattern, ContainerUtil.createMaybeSingletonList((Object)pathSubstitution));
            if (matchedStar == null || (file = this.checkSymbolAndGetFile(pathFile)) == null) continue;
            return new JSModuleNameInfo(pattern.replace("*", (CharSequence)matchedStar.second), file, pathFile, (PsiElement)this.myPlacePsiFile);
        }
        return null;
    }

    private boolean processModuleNameUsingNodeModules(@NotNull Processor<JSModuleNameInfo> processor) {
        Pair<VirtualFile, VirtualFile> libraryDirectory;
        if (processor == null) {
            TypeScriptImportPathBuilder.$$$reportNull$$$0(6);
        }
        if ((libraryDirectory = ES6CreateImportUtil.findParentLibraryDirectory(this.myProject, this.myFileToImport, TypeScriptAutoImportUtil.NODE_MODULES)) == null) {
            return true;
        }
        VirtualFile moduleDirectory = (VirtualFile)libraryDirectory.first;
        VirtualFile directoryToCalcModuleName = TypeScriptImportPathBuilder.getDirectoryToCalcModuleNameInNodeModules(this.myPlacePsiFile, moduleDirectory);
        if (directoryToCalcModuleName == null) {
            return true;
        }
        ArrayList elements = ContainerUtil.newArrayList(TypeScriptImportPathBuilder.collectParents(this.myFileToImport, moduleDirectory));
        elements.add(moduleDirectory);
        List virtualFiles = ContainerUtil.reverse((List)elements);
        for (VirtualFile moduleFileOrDirectory : virtualFiles) {
            String path;
            VirtualFile candidate;
            if (moduleFileOrDirectory.equals(this.myFileToImport) || (candidate = this.checkSymbolAndGetFile(moduleFileOrDirectory)) == null || !TypeScriptUtil.isDefinitionFile(candidate) || processor.process((Object)new JSModuleNameInfo(path = VfsUtil.getPath((VirtualFile)directoryToCalcModuleName, (VirtualFile)moduleFileOrDirectory, (char)'/'), moduleFileOrDirectory, candidate, (PsiElement)this.myPlacePsiFile))) continue;
            return false;
        }
        if (this.myElementToImport != null && !moduleDirectory.equals(this.myFileToImport.getParent())) {
            for (VirtualFile candidate : moduleDirectory.getChildren()) {
                String path;
                JSModuleNameInfo moduleInfo;
                if (candidate.isDirectory() || !TypeScriptUtil.isDefinitionFile(candidate) || !ES6CreateImportUtil.checkSymbolInFile(this.myProject, candidate, this.myElementToImport, (PsiElement)this.myPlacePsiFile) || processor.process((Object)(moduleInfo = new JSModuleNameInfo(path = VfsUtil.getPath((VirtualFile)directoryToCalcModuleName, (VirtualFile)candidate, (char)'/'), candidate, candidate, this.myElementToImport)))) continue;
                return false;
            }
        }
        String path = VfsUtil.getPath((VirtualFile)directoryToCalcModuleName, (VirtualFile)this.myFileToImport, (char)'/');
        JSModuleNameInfo moduleInfo = new JSModuleNameInfo(path, this.myFileToImport, this.myFileToImport, (PsiElement)this.myPlacePsiFile);
        return processor.process((Object)moduleInfo);
    }

    private static boolean shouldUseNewMapping(@Nullable JSModuleNameInfo oldMapping, @NotNull JSModuleNameInfo newMapping) {
        if (newMapping == null) {
            TypeScriptImportPathBuilder.$$$reportNull$$$0(7);
        }
        if (oldMapping == null) {
            return true;
        }
        return oldMapping.getPath().length() > newMapping.getPath().length();
    }

    private static VirtualFile getPossibleFileWithExtension(@NotNull VirtualFile baseUrl, @NotNull String mapping) {
        if (baseUrl == null) {
            TypeScriptImportPathBuilder.$$$reportNull$$$0(8);
        }
        if (mapping == null) {
            TypeScriptImportPathBuilder.$$$reportNull$$$0(9);
        }
        if (JSFileReference.findExtension(mapping, TypeScriptUtil.TYPESCRIPT_EXTENSIONS) != null) {
            return JSPathMappingsUtil.getPathRelativeBaseUrlOrSelfIfAbsolute(baseUrl, mapping);
        }
        for (String extension : TypeScriptUtil.TYPESCRIPT_EXTENSIONS) {
            VirtualFile possibleFile = JSPathMappingsUtil.getPathRelativeBaseUrlOrSelfIfAbsolute(baseUrl, mapping + extension);
            if (possibleFile == null) continue;
            return possibleFile;
        }
        return JSPathMappingsUtil.getPathRelativeBaseUrlOrSelfIfAbsolute(baseUrl, mapping);
    }

    private static boolean isFromNestedDirectory(VirtualFile parentFile, VirtualFile dstFile) {
        if (parentFile.equals(dstFile)) {
            return true;
        }
        if (!parentFile.isDirectory()) {
            parentFile = parentFile.getParent();
        }
        return VfsUtilCore.isAncestor((VirtualFile)parentFile, (VirtualFile)dstFile, (boolean)false);
    }

    @NotNull
    private static List<VirtualFile> collectParents(@NotNull VirtualFile dstFile, @NotNull VirtualFile startDirectory) {
        if (dstFile == null) {
            TypeScriptImportPathBuilder.$$$reportNull$$$0(10);
        }
        if (startDirectory == null) {
            TypeScriptImportPathBuilder.$$$reportNull$$$0(11);
        }
        ArrayList parents = ContainerUtil.newArrayList((Object[])new VirtualFile[]{dstFile});
        boolean hasParent = false;
        for (VirtualFile parent = dstFile.getParent(); parent != null; parent = parent.getParent()) {
            if (startDirectory.equals(parent)) {
                hasParent = true;
                break;
            }
            parents.add(parent);
        }
        if (!hasParent) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                TypeScriptImportPathBuilder.$$$reportNull$$$0(12);
            }
            return list;
        }
        ArrayList arrayList = parents;
        if (arrayList == null) {
            TypeScriptImportPathBuilder.$$$reportNull$$$0(13);
        }
        return arrayList;
    }

    @Nullable
    private VirtualFile getRootFromConfig() {
        if (this.myConfigFile == null) {
            return null;
        }
        VirtualFile baseUrl = this.myConfigFile.getBaseUrl();
        return baseUrl != null ? baseUrl : this.myConfigFile.getConfigDirectory();
    }

    @Override
    @Nullable
    protected JSModuleNameInfo processRootPaths(@NotNull VirtualFile moduleFileOrDirectory, @NotNull VirtualFile resolvedModuleFile) {
        VirtualFile rootFile;
        if (moduleFileOrDirectory == null) {
            TypeScriptImportPathBuilder.$$$reportNull$$$0(14);
        }
        if (resolvedModuleFile == null) {
            TypeScriptImportPathBuilder.$$$reportNull$$$0(15);
        }
        if ((rootFile = this.getRootFromConfig()) != null) {
            return this.getPathForRoot(moduleFileOrDirectory, resolvedModuleFile, rootFile);
        }
        return super.processRootPaths(moduleFileOrDirectory, resolvedModuleFile);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 12: 
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 12: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "importedFile";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 3: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseUrl";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pattern";
                break;
            }
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mapping";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newMapping";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dstFile";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startDirectory";
                break;
            }
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/ecmascript6/psi/impl/TypeScriptImportPathBuilder";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleFileOrDirectory";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolvedModuleFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/ecmascript6/psi/impl/TypeScriptImportPathBuilder";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "collectParents";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "processModuleNames";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getModuleNameForMapping";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "processModuleNameUsingNodeModules";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "shouldUseNewMapping";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getPossibleFileWithExtension";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "collectParents";
                break;
            }
            case 12: 
            case 13: {
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "processRootPaths";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 12: 
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

