/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.completion;

import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.lang.javascript.completion.JSLookupPriority;
import com.intellij.lang.javascript.completion.JSLookupUtilImpl;
import com.intellij.lang.javascript.completion.JSReferenceCompletionContributor;
import com.intellij.lang.javascript.dialects.JSDialectSpecificHandlersFactory;
import com.intellij.lang.javascript.psi.JSDestructuringObject;
import com.intellij.lang.javascript.psi.JSDestructuringProperty;
import com.intellij.lang.javascript.psi.JSQualifiedName;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.resolve.CompletionResultSink;
import com.intellij.lang.javascript.psi.resolve.JSEvaluateContext;
import com.intellij.lang.javascript.psi.resolve.JSTypeEvaluator;
import com.intellij.lang.javascript.psi.resolve.QualifiedItemProcessor;
import com.intellij.lang.javascript.psi.resolve.ResultSink;
import com.intellij.lang.javascript.psi.resolve.VariantsProcessor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public class JSDestructuringPropertyCompletionProvider
extends CompletionProvider<CompletionParameters> {
    protected void addCompletions(@NotNull CompletionParameters parameters, ProcessingContext context, @NotNull CompletionResultSet result) {
        JSDestructuringObject objectPattern;
        PsiElement position;
        PsiElement parent;
        if (parameters == null) {
            JSDestructuringPropertyCompletionProvider.$$$reportNull$$$0(0);
        }
        if (result == null) {
            JSDestructuringPropertyCompletionProvider.$$$reportNull$$$0(1);
        }
        if ((parent = (position = parameters.getPosition()).getParent()) instanceof JSVariable) {
            parent = parent.getParent();
        }
        assert (parent instanceof JSDestructuringProperty) : "must be filtered in JSPatternBasedCompletionContributor";
        JSDestructuringProperty destructuringProperty = (JSDestructuringProperty)parent;
        CompletionResultSink sink = new CompletionResultSink((PsiElement)destructuringProperty);
        PsiFile file = destructuringProperty.getContainingFile();
        QualifiedItemProcessor<? extends ResultSink> localProcessor = JSDialectSpecificHandlersFactory.forElement((PsiElement)destructuringProperty).createCompletionItemProcessor(sink, file);
        JSDestructuringObject jSDestructuringObject = objectPattern = destructuringProperty.getParent() instanceof JSDestructuringObject ? (JSDestructuringObject)destructuringProperty.getParent() : null;
        if (objectPattern == null) {
            return;
        }
        Set existingProperties = ContainerUtil.map2Set((Object[])objectPattern.getProperties(), property -> property.getName());
        JSTypeEvaluator.evaluateExpressionOrElementTypes(file, localProcessor, (PsiElement)objectPattern, JSEvaluateContext.JSEvaluationPlace.DEFAULT);
        List<PsiElement> localResults = localProcessor.getResults();
        VariantsProcessor processor = new VariantsProcessor(file, (PsiElement)destructuringProperty, true, result);
        if (localResults != null) {
            List localLookupElements = localResults.stream().filter(e -> {
                JSQualifiedName namespace;
                if (e instanceof JSQualifiedNamedElement && (namespace = ((JSQualifiedNamedElement)e).getNamespace()) != null && ("Object".equals(namespace.getName()) || "Function".equals(namespace.getName()))) {
                    return false;
                }
                return !(e instanceof PsiNamedElement) || !existingProperties.contains(((PsiNamedElement)e).getName());
            }).map(e -> JSLookupUtilImpl.createPrioritizedLookupElement(e, JSLookupPriority.SMART_PRIORITY)).collect(Collectors.toList());
            processor.populateCompletionList(localLookupElements, false, result);
        }
        JSReferenceCompletionContributor.processCompeteMatchedElements(processor);
        Collection<? extends LookupElement> variantProcessorResults = processor.getCurrentResults();
        processor.populateCompletionList(variantProcessorResults, false, result);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "parameters";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "result";
                break;
            }
        }
        objectArray[1] = "com/intellij/lang/javascript/completion/JSDestructuringPropertyCompletionProvider";
        objectArray[2] = "addCompletions";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

