/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.findUsages;

import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSPsiElementBase;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.resolve.JSInheritanceUtil;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.ui.JSFormatUtil;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.psi.PsiElement;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.Map;
import javax.swing.Icon;
import org.jetbrains.annotations.Nullable;

public class SuperMethodUtil {
    @Nullable
    public static JSFunction checkSuperMethod(JSFunction method, String actionTitle, String questionText) {
        JSClass jsClass = JSResolveUtil.getClassOfContext((PsiElement)method);
        if (jsClass == null) {
            return method;
        }
        Map<JSClass, JSPsiElementBase> map = JSInheritanceUtil.findDeclaringClassesMap((JSQualifiedNamedElement)method);
        if (map.size() == 0) {
            return method;
        }
        if (map.size() != 1 && DialectDetector.isTypeScript((PsiElement)method)) {
            return null;
        }
        Map.Entry item = (Map.Entry)ContainerUtil.getFirstItem(map.entrySet());
        assert (item != null);
        JSClass baseClass = (JSClass)item.getKey();
        if (baseClass != null && jsClass != baseClass) {
            String message = JSBundle.message((String)(baseClass.isInterface() ? "find.usages.of.base.interface" : "find.usages.of.base.class"), (Object[])new Object[]{JSFormatUtil.formatMethod(method, 257, 2), JSFormatUtil.formatClass(jsClass, 1), JSFormatUtil.formatClass(baseClass, 2048), questionText});
            int choice = ApplicationManagerEx.getApplicationEx().isUnitTestMode() ? 0 : Messages.showYesNoCancelDialog((Project)method.getProject(), (String)message, (String)actionTitle, (Icon)Messages.getQuestionIcon());
            switch (choice) {
                case 0: {
                    return (JSFunction)ObjectUtils.tryCast(item.getValue(), JSFunction.class);
                }
                case 1: {
                    return method;
                }
            }
            return null;
        }
        return method;
    }
}

