/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.frameworks.commonjs;

import com.intellij.lang.ecmascript6.resolve.JSFileReferencesUtil;
import com.intellij.lang.javascript.JSStubElementTypes;
import com.intellij.lang.javascript.psi.JSAssignmentExpression;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSExpressionStatement;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSQualifiedName;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.impl.JSFileImpl;
import com.intellij.lang.javascript.psi.types.JSRequireCallExpressionType;
import com.intellij.lang.javascript.psi.types.JSTypeImpl;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.stubs.StubElement;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CommonJSUtil {
    public static boolean calculateIsRequireCall(@NotNull JSCallExpression callExpression) {
        JSReferenceExpression methodExpression;
        if (callExpression == null) {
            CommonJSUtil.$$$reportNull$$$0(0);
        }
        return (methodExpression = (JSReferenceExpression)ObjectUtils.tryCast((Object)callExpression.getMethodExpression(), JSReferenceExpression.class)) != null && callExpression.getArguments().length == 1 && methodExpression.getQualifier() == null && "require".equals(methodExpression.getReferenceName());
    }

    @Nullable
    public static String getRequireCallModulePath(@NotNull JSCallExpression call) {
        if (call == null) {
            CommonJSUtil.$$$reportNull$$$0(1);
        }
        assert (call.isRequireCall());
        JSExpression[] arguments = call.getArguments();
        assert (arguments.length == 1);
        JSExpression argument = arguments[0];
        if (!(argument instanceof JSLiteralExpression) || !((JSLiteralExpression)argument).isQuotedLiteral()) {
            return null;
        }
        return StringUtil.unquoteString((String)argument.getText());
    }

    @Nullable
    public static String getNodeJsRedirectPath(PsiFile mainModule) {
        if (!(mainModule instanceof JSFileImpl)) {
            return null;
        }
        StubElement stub = ((JSFileImpl)mainModule).getStub();
        JSAssignmentExpression candidate = null;
        if (stub != null) {
            PsiElement[] assignments = stub.getChildrenByType(JSStubElementTypes.ASSIGNMENT_EXPRESSION, PsiElement.ARRAY_FACTORY);
            if (assignments.length == 1 && assignments[0] instanceof JSAssignmentExpression) {
                candidate = (JSAssignmentExpression)assignments[0];
            }
        } else {
            JSExpression expression;
            JSExpressionStatement[] exprStatements = (JSExpressionStatement[])((JSFileImpl)mainModule).findChildrenByClass(JSExpressionStatement.class);
            if (exprStatements.length == 1 && (expression = exprStatements[0].getExpression()) instanceof JSAssignmentExpression) {
                candidate = (JSAssignmentExpression)expression;
            }
        }
        if (candidate == null) {
            return null;
        }
        JSDefinitionExpression definitionExpression = candidate.getDefinitionExpression();
        if (definitionExpression == null || !"module.exports".equals(definitionExpression.getQualifiedName())) {
            return null;
        }
        JSType exportsType = ((JSFileImpl)mainModule).getExportsInnerAlias();
        if (!(exportsType instanceof JSRequireCallExpressionType)) {
            return null;
        }
        return ((JSRequireCallExpressionType)exportsType).getReferencedModule();
    }

    public static boolean isModuleType(JSType type) {
        return type instanceof JSTypeImpl && type.getTypeText(JSType.TypeTextFormat.SIMPLE).startsWith("module:");
    }

    public static Collection<JSFile> resolveReferencedElements(@NotNull PsiElement context, @NotNull String path) {
        if (context == null) {
            CommonJSUtil.$$$reportNull$$$0(2);
        }
        if (path == null) {
            CommonJSUtil.$$$reportNull$$$0(3);
        }
        return JSFileReferencesUtil.getMostPriorityModules(context, path, true).stream().filter(el -> el instanceof JSFile).map(el -> (JSFile)el).collect(Collectors.toList());
    }

    public static boolean isExportNamespace(@Nullable JSQualifiedName qName) {
        return qName != null && "exports".equals(qName.getName()) && (qName.getParent() == null || "module".equals(qName.getParent().getName()) && qName.getParent().getParent() == null);
    }

    @NotNull
    public static Collection<PsiElement> findReferencedModulesIfRequireCall(@NotNull JSCallExpression callExpression) {
        if (callExpression == null) {
            CommonJSUtil.$$$reportNull$$$0(4);
        }
        if (!callExpression.isRequireCall()) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                CommonJSUtil.$$$reportNull$$$0(5);
            }
            return list;
        }
        JSExpression[] arguments = callExpression.getArguments();
        if (arguments.length > 0 && arguments[0] instanceof JSLiteralExpression) {
            PsiReference[] references = arguments[arguments.length - 1].getReferences();
            Collection<PsiElement> collection = JSFileReferencesUtil.getMostPriorityModules((PsiElement)callExpression, references);
            if (collection == null) {
                CommonJSUtil.$$$reportNull$$$0(6);
            }
            return collection;
        }
        List list = ContainerUtil.emptyList();
        if (list == null) {
            CommonJSUtil.$$$reportNull$$$0(7);
        }
        return list;
    }

    @Nullable
    public static PsiElement findReferencedModuleIfRequireCall(@NotNull JSCallExpression callExpression) {
        if (callExpression == null) {
            CommonJSUtil.$$$reportNull$$$0(8);
        }
        return (PsiElement)ContainerUtil.getFirstItem(CommonJSUtil.findReferencedModulesIfRequireCall(callExpression));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callExpression";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "call";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/frameworks/commonjs/CommonJSUtil";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/frameworks/commonjs/CommonJSUtil";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "findReferencedModulesIfRequireCall";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "calculateIsRequireCall";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getRequireCallModulePath";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "resolveReferencedElements";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "findReferencedModulesIfRequireCall";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "findReferencedModuleIfRequireCall";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

