/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.frameworks.react;

import com.intellij.codeInsight.daemon.ImplicitUsageProvider;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.frameworks.react.tsx.TypeScriptReactTagUtil;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSField;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.stubs.JSClassIndex;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.stubs.StubIndex;
import java.util.Collection;

public class ReactImplicitUsageProvider
implements ImplicitUsageProvider {
    private static final String LIFECYCLE_INTERFACE = "ComponentLifecycle";
    private static final String LIFECYCLE_INTERFACE_WITH_MARK = "^ComponentLifecycle";
    private static final String COMPONENT_CLASS = "Component";
    public static final String REACT = "React";

    public boolean isImplicitUsage(PsiElement element) {
        if (!DialectDetector.isJSX(element)) {
            return false;
        }
        if (element instanceof JSVariable && REACT.equals(((JSVariable)element).getName())) {
            return true;
        }
        if (element instanceof JSField) {
            String name = ((JSField)element).getName();
            return "defaultProps".equals(name) || "propTypes".equals(name) || "contextTypes".equals(name) || "childContextTypes".equals(name);
        }
        if (!(element instanceof JSFunction) && !(element instanceof JSProperty)) {
            return false;
        }
        JSNamedElement namedElement = (JSNamedElement)element;
        String name = namedElement.getName();
        if (name == null) {
            return false;
        }
        if (this.checkForClass(namedElement, name, LIFECYCLE_INTERFACE_WITH_MARK)) {
            return true;
        }
        return this.checkForClass(namedElement, name, COMPONENT_CLASS);
    }

    public boolean checkForClass(JSNamedElement namedElement, String name, String className) {
        Collection elements = StubIndex.getElements(JSClassIndex.KEY, (Object)className, (Project)namedElement.getProject(), (GlobalSearchScope)TypeScriptReactTagUtil.getReactLibraryScope(namedElement.getProject()), JSElement.class);
        for (JSElement jsElement : elements) {
            if (!(jsElement instanceof JSClass) || ((JSClass)jsElement).findFunctionByName(name) == null) continue;
            return true;
        }
        return false;
    }

    public boolean isImplicitRead(PsiElement element) {
        return false;
    }

    public boolean isImplicitWrite(PsiElement element) {
        return false;
    }
}

