/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.inspections;

import com.intellij.codeInspection.CleanupLocalInspectionTool;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.LocalQuickFixAndIntentionActionOnPsiElement;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.dialects.JSLanguageFeature;
import com.intellij.lang.javascript.flow.psi.impl.FlowJSMaybeTypeImpl;
import com.intellij.lang.javascript.inspections.JSInspection;
import com.intellij.lang.javascript.psi.JSDestructuringParameter;
import com.intellij.lang.javascript.psi.JSElementFactory;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSInheritedLanguagesHelper;
import com.intellij.lang.javascript.psi.JSParameterList;
import com.intellij.lang.javascript.psi.JSParenthesizedExpression;
import com.intellij.lang.javascript.psi.ecma6.JSTypeDeclaration;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptFunctionType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptUnionOrIntersectionType;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.jsdoc.JSDocComment;
import com.intellij.lang.javascript.psi.util.ParenthesesUtils;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.sixrr.inspectjs.utils.UnnecessaryParenthesesChecker;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSRemoveUnnecessaryParenthesesInspection
extends JSInspection
implements CleanupLocalInspectionTool {
    @NotNull
    public String getDisplayName() {
        String string = JSBundle.message((String)"unnecessary.parentheses.display.name", (Object[])new Object[0]);
        if (string == null) {
            JSRemoveUnnecessaryParenthesesInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    protected PsiElementVisitor createVisitor(final ProblemsHolder holder, LocalInspectionToolSession session) {
        JSElementVisitor jSElementVisitor = new JSElementVisitor(){

            public void visitElement(PsiElement element) {
                if (!JSInheritedLanguagesHelper.isRemoveUnnecessaryParenthesesEnabled(element)) {
                    return;
                }
                if (element instanceof JSParenthesizedExpression) {
                    if (UnnecessaryParenthesesChecker.shouldRemove((JSParenthesizedExpression)element)) {
                        holder.registerProblem(element, JSBundle.message((String)"unnecessary.parentheses.problem.descriptor", (Object[])new Object[0]), new LocalQuickFix[]{new RemoveParenthesesFix(element)});
                    }
                    return;
                }
                JSTypeDeclaration typeDeclaration = JSRemoveUnnecessaryParenthesesInspection.unparenthesizeType(element);
                if (typeDeclaration != null) {
                    if (JSRemoveUnnecessaryParenthesesInspection.canRemoveParenthesesAroundType(typeDeclaration)) {
                        holder.registerProblem(element, JSBundle.message((String)"unnecessary.parentheses.problem.descriptor", (Object[])new Object[0]), new LocalQuickFix[]{new RemoveParenthesesFix(element)});
                    }
                    return;
                }
                if (element instanceof JSParameterList && JSRemoveUnnecessaryParenthesesInspection.dialectSupportsArrows(element) && JSPsiImplUtils.isArrowFunction((JSFunction)ObjectUtils.tryCast((Object)element.getParent(), JSFunctionExpression.class)) && JSRemoveUnnecessaryParenthesesInspection.canRemoveParenthesesAroundArrowParameters((JSParameterList)element, (JSFunctionExpression)element.getParent())) {
                    holder.registerProblem(element, JSBundle.message((String)"unnecessary.parentheses.problem.descriptor", (Object[])new Object[0]), new LocalQuickFix[]{new RemoveParenthesesFix(element)});
                }
            }
        };
        if (jSElementVisitor == null) {
            JSRemoveUnnecessaryParenthesesInspection.$$$reportNull$$$0(1);
        }
        return jSElementVisitor;
    }

    private static boolean dialectSupportsArrows(@NotNull PsiElement context) {
        DialectOptionHolder dialectOptionHolder;
        if (context == null) {
            JSRemoveUnnecessaryParenthesesInspection.$$$reportNull$$$0(2);
        }
        return (dialectOptionHolder = DialectDetector.dialectOfElement(context)) != null && dialectOptionHolder.hasFeature(JSLanguageFeature.ARROW_FUNCTIONS);
    }

    private static boolean canRemoveParenthesesAroundArrowParameters(@NotNull JSParameterList parameterList, @NotNull JSFunctionExpression arrowFunction) {
        if (parameterList == null) {
            JSRemoveUnnecessaryParenthesesInspection.$$$reportNull$$$0(3);
        }
        if (arrowFunction == null) {
            JSRemoveUnnecessaryParenthesesInspection.$$$reportNull$$$0(4);
        }
        return parameterList.getParameters().length == 1 && parameterList.getNode().findChildByType(JSTokenTypes.LPAR) != null && !(parameterList.getParameters()[0] instanceof JSDestructuringParameter) && !parameterList.getParameters()[0].isRest() && parameterList.getParameters()[0].getTypeElement() == null && arrowFunction.getReturnTypeElement() == null && !ContainerUtil.or((Object[])parameterList.getChildren(), child -> child instanceof JSDocComment);
    }

    @Nullable
    private static JSTypeDeclaration unparenthesizeType(@NotNull PsiElement element) {
        block4: {
            block3: {
                if (element == null) {
                    JSRemoveUnnecessaryParenthesesInspection.$$$reportNull$$$0(5);
                }
                if (element.getNode().getElementType() != JSTokenTypes.LPAR) break block3;
                while (element != null && element.getNode().getElementType() == JSTokenTypes.LPAR) {
                    element = JSPsiImplUtils.findNextCodeElement(element);
                }
                break block4;
            }
            if (element.getNode().getElementType() != JSTokenTypes.RPAR) break block4;
            while (element != null && element.getNode().getElementType() == JSTokenTypes.RPAR) {
                element = JSPsiImplUtils.findPrevCodeElement(element);
            }
        }
        return element instanceof JSTypeDeclaration && JSRemoveUnnecessaryParenthesesInspection.isParenthesizedType((JSTypeDeclaration)element) ? (JSTypeDeclaration)element : null;
    }

    private static boolean isParenthesizedType(@NotNull JSTypeDeclaration element) {
        if (element == null) {
            JSRemoveUnnecessaryParenthesesInspection.$$$reportNull$$$0(6);
        }
        int parens = 0;
        PsiElement prev = JSPsiImplUtils.findPrevCodeElement((PsiElement)element);
        while (prev != null && prev.getNode().getElementType() == JSTokenTypes.LPAR) {
            prev = JSPsiImplUtils.findPrevCodeElement(prev);
            ++parens;
        }
        if (parens == 0) {
            return false;
        }
        PsiElement next = JSPsiImplUtils.findNextCodeElement((PsiElement)element);
        while (next != null && next.getNode().getElementType() == JSTokenTypes.RPAR) {
            --parens;
            next = JSPsiImplUtils.findNextCodeElement(next);
        }
        return parens == 0;
    }

    private static boolean canRemoveParenthesesAroundType(@NotNull JSTypeDeclaration element) {
        PsiElement parent;
        if (element == null) {
            JSRemoveUnnecessaryParenthesesInspection.$$$reportNull$$$0(7);
        }
        if ((parent = element.getParent()) instanceof FlowJSMaybeTypeImpl) {
            return false;
        }
        if (element instanceof TypeScriptUnionOrIntersectionType && parent instanceof TypeScriptUnionOrIntersectionType && ((TypeScriptUnionOrIntersectionType)parent).isIntersectionType() && ((TypeScriptUnionOrIntersectionType)element).isUnionType()) {
            return false;
        }
        if (element instanceof TypeScriptUnionOrIntersectionType && element.getParent() instanceof JSParameterList && element.getParent().getParent() instanceof TypeScriptFunctionType) {
            return false;
        }
        return !(element instanceof TypeScriptFunctionType) || !(element.getParent() instanceof JSParameterList);
    }

    private static void deleteParenthesesAroundType(@NotNull JSTypeDeclaration element) {
        if (element == null) {
            JSRemoveUnnecessaryParenthesesInspection.$$$reportNull$$$0(8);
        }
        PsiElement prev = JSPsiImplUtils.findPrevCodeElement((PsiElement)element);
        while (prev != null && prev.getNode().getElementType() == JSTokenTypes.LPAR) {
            prev.delete();
            prev = JSPsiImplUtils.findPrevCodeElement((PsiElement)element);
        }
        PsiElement next = JSPsiImplUtils.findNextCodeElement((PsiElement)element);
        while (next != null && next.getNode().getElementType() == JSTokenTypes.RPAR) {
            next.delete();
            next = JSPsiImplUtils.findNextCodeElement((PsiElement)element);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/inspections/JSRemoveUnnecessaryParenthesesInspection";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameterList";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arrowFunction";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createVisitor";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/inspections/JSRemoveUnnecessaryParenthesesInspection";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "dialectSupportsArrows";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "canRemoveParenthesesAroundArrowParameters";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "unparenthesizeType";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isParenthesizedType";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "canRemoveParenthesesAroundType";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "deleteParenthesesAroundType";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class RemoveParenthesesFix
    extends LocalQuickFixAndIntentionActionOnPsiElement {
        protected RemoveParenthesesFix(@Nullable PsiElement element) {
            super(element);
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            String string = JSBundle.message((String)"remove.unnecessary.parentheses.fix.text", (Object[])new Object[0]);
            if (string == null) {
                RemoveParenthesesFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @NotNull
        public String getText() {
            String string = this.getFamilyName();
            if (string == null) {
                RemoveParenthesesFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        public void invoke(@NotNull Project project, @NotNull PsiFile file, @Nullable Editor editor, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
            PsiElement element;
            JSTypeDeclaration typeDeclaration;
            if (project == null) {
                RemoveParenthesesFix.$$$reportNull$$$0(2);
            }
            if (file == null) {
                RemoveParenthesesFix.$$$reportNull$$$0(3);
            }
            if (startElement == null) {
                RemoveParenthesesFix.$$$reportNull$$$0(4);
            }
            if (endElement == null) {
                RemoveParenthesesFix.$$$reportNull$$$0(5);
            }
            if ((typeDeclaration = JSRemoveUnnecessaryParenthesesInspection.unparenthesizeType(element = startElement)) != null) {
                JSRemoveUnnecessaryParenthesesInspection.deleteParenthesesAroundType(typeDeclaration);
                return;
            }
            if (element instanceof JSParameterList) {
                PsiElement first = element.getFirstChild();
                while (first instanceof PsiWhiteSpace || first.getNode().getElementType() == JSTokenTypes.LPAR) {
                    first.delete();
                    first = element.getFirstChild();
                }
                PsiElement last = element.getLastChild();
                while (last instanceof PsiWhiteSpace || last.getNode().getElementType() == JSTokenTypes.RPAR) {
                    last.delete();
                    last = element.getFirstChild();
                }
                return;
            }
            if (element instanceof JSExpression) {
                JSExpression exp = (JSExpression)element;
                while (exp.getParent() instanceof JSExpression) {
                    exp = (JSExpression)exp.getParent();
                }
                JSElementFactory.replaceExpression(exp, ParenthesesUtils.removeParentheses(exp));
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/javascript/inspections/JSRemoveUnnecessaryParenthesesInspection$RemoveParenthesesFix";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "startElement";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "endElement";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getText";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/javascript/inspections/JSRemoveUnnecessaryParenthesesInspection$RemoveParenthesesFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "invoke";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

