/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.library.download;

import com.intellij.javascript.nodejs.interpreter.local.NodeJsLocalInterpreter;
import com.intellij.javascript.nodejs.interpreter.local.NodeJsLocalInterpreterManager;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.library.JSLibraryManager;
import com.intellij.lang.javascript.library.JSLibraryMappings;
import com.intellij.lang.javascript.library.download.JSDownloadManager;
import com.intellij.lang.javascript.library.download.TypeScriptDefinitionFilesRootsProvider;
import com.intellij.lang.javascript.library.download.TypeScriptRelatedPackagesCollector;
import com.intellij.lang.javascript.library.download.TypeScriptRelatedPackagesStorage;
import com.intellij.lang.javascript.library.ui.JSScriptingContextProvider;
import com.intellij.lang.javascript.modules.PackageInstaller;
import com.intellij.lang.typescript.library.download.TypeScriptDefinitionFilesDirectory;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.progress.impl.BackgroundableProcessIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.AdditionalLibraryRootsProvider;
import com.intellij.openapi.roots.SyntheticLibrary;
import com.intellij.openapi.roots.ex.ProjectRootManagerEx;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.EmptyRunnable;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.NavigatableWithText;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Consumer;
import com.intellij.util.PathUtil;
import com.intellij.util.ThrowableRunnable;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.download.DownloadableFileDescription;
import com.intellij.util.download.DownloadableFileSetDescription;
import com.intellij.webcore.libraries.ScriptingLibraryMappings;
import com.intellij.webcore.libraries.ScriptingLibraryModel;
import com.intellij.webcore.packaging.PackageManagementService;
import java.awt.Component;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u000e2\u00020\u0001:\u0002\u000e\u000fB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\tH\u0016J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\tH\u0002R\u0012\u0010\u0003\u001a\u00020\u00048\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/intellij/lang/javascript/library/download/TypeScriptDefinitionFilesRootsProvider;", "Lcom/intellij/openapi/roots/AdditionalLibraryRootsProvider;", "()V", "refreshed", "", "getAdditionalProjectLibraries", "", "Lcom/intellij/openapi/roots/SyntheticLibrary;", "project", "Lcom/intellij/openapi/project/Project;", "startRefresh", "", "directory", "Lcom/intellij/openapi/vfs/VirtualFile;", "LibraryCreator", "TypesSyntheticLibrary", "JavaScriptLanguage"})
public final class TypeScriptDefinitionFilesRootsProvider
extends AdditionalLibraryRootsProvider {
    private volatile boolean refreshed;
    public static final LibraryCreator LibraryCreator = new LibraryCreator(null);

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Collection<SyntheticLibrary> getAdditionalProjectLibraries(@NotNull Project project) {
        SyntheticLibrary delegate;
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        Iterable element$iv2;
        void $receiver$iv$iv2;
        Object[] $receiver$iv2;
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        JSLibraryManager libraryManager = JSLibraryManager.getInstance(project);
        LibraryTable libTable = libraryManager.getLibraryTable(ScriptingLibraryModel.LibraryLevel.GLOBAL);
        ScriptingLibraryMappings mappings = libraryManager.getLibraryMappings();
        Object[] objectArray = $receiver$iv2 = (Object[])libTable.getLibraries();
        Collection destination$iv$iv = new ArrayList();
        void $receiver$iv$iv$iv = $receiver$iv$iv2;
        for (int i = 0; i < ((void)$receiver$iv$iv$iv).length; ++i) {
            String string;
            String string2;
            void element$iv$iv$iv = $receiver$iv$iv$iv[i];
            void element$iv$iv = element$iv$iv$iv;
            Library it = (Library)element$iv$iv;
            String name = it.getName();
            if (name != null && StringsKt.startsWith$default((String)name, (String)"@types/", (boolean)false, (int)2, null) && mappings.isAssociatedWithProject(name)) {
                String string3 = name;
                int n = "@types/".length();
                String string4 = string3.substring(n);
                string2 = string4;
                Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"(this as java.lang.String).substring(startIndex)");
            } else {
                string2 = null;
            }
            if (string2 == null) continue;
            String it$iv$iv = string = string2;
            destination$iv$iv.add(it$iv$iv);
        }
        List fileNames = CollectionsKt.toList((Iterable)((List)destination$iv$iv));
        if (fileNames.isEmpty()) {
            return CollectionsKt.emptyList();
        }
        VirtualFile virtualFile = TypeScriptDefinitionFilesDirectory.getGlobalTypesDirectory();
        if (virtualFile == null) {
            return CollectionsKt.emptyList();
        }
        VirtualFile directory = virtualFile;
        if (!directory.isValid()) {
            if (!this.refreshed) {
                VirtualFile virtualFile2 = directory;
                Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile2, (String)"directory");
                this.startRefresh(virtualFile2, project);
            }
            return CollectionsKt.emptyList();
        }
        HashSet result = ContainerUtil.newHashSet((Iterable)fileNames);
        TypeScriptRelatedPackagesStorage storage = TypeScriptRelatedPackagesStorage.getStorage(project);
        if (storage != null) {
            Iterable $receiver$iv3 = fileNames;
            for (Iterable element$iv2 : $receiver$iv3) {
                String it = (String)((Object)element$iv2);
                result.addAll(storage.getRelatedPackageNames(directory, it));
            }
        }
        element$iv2 = $receiver$iv = (Iterable)result;
        Collection destination$iv$iv2 = new ArrayList();
        void $receiver$iv$iv$iv2 = $receiver$iv$iv;
        for (Object element$iv$iv$iv : $receiver$iv$iv$iv2) {
            VirtualFile virtualFile3;
            Object element$iv$iv = element$iv$iv$iv;
            String it = (String)element$iv$iv;
            if (directory.findChild(it) == null) continue;
            VirtualFile it$iv$iv = virtualFile3;
            destination$iv$iv2.add(it$iv$iv);
        }
        List files = CollectionsKt.toList((Iterable)((List)destination$iv$iv2));
        if (files.isEmpty()) {
            return CollectionsKt.emptyList();
        }
        SyntheticLibrary syntheticLibrary = delegate = SyntheticLibrary.newImmutableLibrary((Collection)files);
        Intrinsics.checkExpressionValueIsNotNull((Object)syntheticLibrary, (String)"delegate");
        return CollectionsKt.listOf((Object)((Object)new TypesSyntheticLibrary(syntheticLibrary)));
    }

    private final void startRefresh(VirtualFile directory, Project project) {
        this.refreshed = true;
        VfsUtil.markDirty((boolean)true, (boolean)true, (VirtualFile[])new VirtualFile[]{directory});
        LocalFileSystem.getInstance().refreshFiles((Iterable)CollectionsKt.listOf((Object)directory), true, true, new Runnable(project){
            final /* synthetic */ Project $project;

            public final void run() {
                if (this.$project.isDisposed()) {
                    return;
                }
                WriteAction.run((ThrowableRunnable)((ThrowableRunnable)new ThrowableRunnable<E>(this){
                    final /* synthetic */ startRefresh.1 this$0;

                    public final void run() {
                        ProjectRootManagerEx.getInstanceEx((Project)this.this$0.$project).makeRootsChange(EmptyRunnable.getInstance(), false, true);
                    }
                    {
                        this.this$0 = var1_1;
                    }
                }));
            }
            {
                this.$project = project;
            }
        });
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\b\u001a\u00020\u0007H\u0016J\u0013\u0010\t\u001a\u00020\u00072\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0096\u0002J\u0010\u0010\f\u001a\n\u0012\u0004\u0012\u00020\u000e\u0018\u00010\rH\u0016J\u0012\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u0007H\u0016J\n\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0016J\u0012\u0010\u0014\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0015\u001a\u00020\u0007H\u0016J\n\u0010\u0016\u001a\u0004\u0018\u00010\u0013H\u0016J\u000e\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0018H\u0016J\b\u0010\u0019\u001a\u00020\u001aH\u0016J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u0007H\u0016R\u000e\u0010\u0004\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/intellij/lang/javascript/library/download/TypeScriptDefinitionFilesRootsProvider$TypesSyntheticLibrary;", "Lcom/intellij/openapi/roots/SyntheticLibrary;", "Lcom/intellij/navigation/ItemPresentation;", "Lcom/intellij/pom/NavigatableWithText;", "delegateLibrary", "(Lcom/intellij/openapi/roots/SyntheticLibrary;)V", "canNavigate", "", "canNavigateToSource", "equals", "other", "", "getExcludeFileCondition", "Lcom/intellij/openapi/util/Condition;", "Lcom/intellij/openapi/vfs/VirtualFile;", "getIcon", "Ljavax/swing/Icon;", "unused", "getLocationString", "", "getNavigateActionText", "focusEditor", "getPresentableText", "getSourceRoots", "", "hashCode", "", "navigate", "", "requestFocus", "JavaScriptLanguage"})
    public static final class TypesSyntheticLibrary
    extends SyntheticLibrary
    implements ItemPresentation,
    NavigatableWithText {
        private final SyntheticLibrary delegateLibrary;

        public void navigate(boolean requestFocus) {
        }

        public boolean canNavigate() {
            return false;
        }

        @Nullable
        public String getNavigateActionText(boolean focusEditor) {
            return null;
        }

        public boolean canNavigateToSource() {
            return false;
        }

        @Nullable
        public String getPresentableText() {
            return "@types";
        }

        @Nullable
        public String getLocationString() {
            return "";
        }

        @Nullable
        public Icon getIcon(boolean unused) {
            return null;
        }

        @NotNull
        public Collection<VirtualFile> getSourceRoots() {
            Collection collection = this.delegateLibrary.getSourceRoots();
            Intrinsics.checkExpressionValueIsNotNull((Object)collection, (String)"delegateLibrary.sourceRoots");
            return collection;
        }

        public boolean equals(@Nullable Object other) {
            return Intrinsics.areEqual((Object)this.delegateLibrary, (Object)other);
        }

        public int hashCode() {
            return this.delegateLibrary.hashCode();
        }

        @Nullable
        public Condition<VirtualFile> getExcludeFileCondition() {
            return getExcludeFileCondition.1.INSTANCE;
        }

        public TypesSyntheticLibrary(@NotNull SyntheticLibrary delegateLibrary) {
            Intrinsics.checkParameterIsNotNull((Object)delegateLibrary, (String)"delegateLibrary");
            this.delegateLibrary = delegateLibrary;
        }
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J4\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J*\u0010\u0013\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\n2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\b\u0010\r\u001a\u0004\u0018\u00010\u000eJ<\u0010\u0014\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\u00162\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J.\u0010\u0017\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00190\u00182\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\n2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0002J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\t\u001a\u00020\nH\u0002J,\u0010\u001c\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\b\u0010\u001d\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u001e\u001a\u00020\u001bH\u0002\u00a8\u0006\u001f"}, d2={"Lcom/intellij/lang/javascript/library/download/TypeScriptDefinitionFilesRootsProvider$LibraryCreator;", "", "()V", "createRequiredDirectories", "", "file", "Ljava/io/File;", "downloadByUrl", "", "description", "Lcom/intellij/util/download/DownloadableFileSetDescription;", "project", "Lcom/intellij/openapi/project/Project;", "onLibraryCreated", "Ljava/lang/Runnable;", "notificationAreaComponent", "Ljava/awt/Component;", "modalityState", "Lcom/intellij/openapi/application/ModalityState;", "downloadTypesLibrary", "downloadUsingNpm", "interpreter", "Lcom/intellij/javascript/nodejs/interpreter/local/NodeJsLocalInterpreter;", "getCreateLibraryCallback", "Lcom/intellij/util/Consumer;", "", "getNameForLibrary", "", "logInstallingError", "message", "dialogTitle", "JavaScriptLanguage"})
    public static final class LibraryCreator {
        public final void downloadTypesLibrary(@NotNull Project project, @NotNull DownloadableFileSetDescription description, @Nullable Component notificationAreaComponent, @Nullable Runnable onLibraryCreated) {
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            Intrinsics.checkParameterIsNotNull((Object)description, (String)"description");
            ApplicationManager.getApplication().assertIsDispatchThread();
            ModalityState modalityState = ModalityState.current();
            NodeJsLocalInterpreter interpreter = NodeJsLocalInterpreterManager.getInstance().detectMostRelevant();
            ApplicationManager.getApplication().executeOnPooledThread(new Runnable(interpreter, description, project, onLibraryCreated, notificationAreaComponent, modalityState){
                final /* synthetic */ NodeJsLocalInterpreter $interpreter;
                final /* synthetic */ DownloadableFileSetDescription $description;
                final /* synthetic */ Project $project;
                final /* synthetic */ Runnable $onLibraryCreated;
                final /* synthetic */ Component $notificationAreaComponent;
                final /* synthetic */ ModalityState $modalityState;

                public final void run() {
                    if (this.$interpreter != null && this.$interpreter.isValid()) {
                        ModalityState modalityState = this.$modalityState;
                        Intrinsics.checkExpressionValueIsNotNull((Object)modalityState, (String)"modalityState");
                        com.intellij.lang.javascript.library.download.TypeScriptDefinitionFilesRootsProvider$LibraryCreator.access$downloadUsingNpm(TypeScriptDefinitionFilesRootsProvider.LibraryCreator, this.$description, this.$project, this.$interpreter, this.$onLibraryCreated, this.$notificationAreaComponent, modalityState);
                    } else {
                        ModalityState modalityState = this.$modalityState;
                        Intrinsics.checkExpressionValueIsNotNull((Object)modalityState, (String)"modalityState");
                        com.intellij.lang.javascript.library.download.TypeScriptDefinitionFilesRootsProvider$LibraryCreator.access$downloadByUrl(TypeScriptDefinitionFilesRootsProvider.LibraryCreator, this.$description, this.$project, this.$onLibraryCreated, this.$notificationAreaComponent, modalityState);
                    }
                }
                {
                    this.$interpreter = nodeJsLocalInterpreter;
                    this.$description = downloadableFileSetDescription;
                    this.$project = project;
                    this.$onLibraryCreated = runnable;
                    this.$notificationAreaComponent = component;
                    this.$modalityState = modalityState;
                }
            });
        }

        private final void downloadUsingNpm(DownloadableFileSetDescription description, Project project, NodeJsLocalInterpreter interpreter, Runnable onLibraryCreated, Component notificationAreaComponent, ModalityState modalityState) {
            String globalTypesTargetPath = TypeScriptDefinitionFilesDirectory.getGlobalTypesTopDirectory();
            File file = new File(globalTypesTargetPath);
            if (!this.createRequiredDirectories(file)) {
                String dialogTitle;
                String message = JSBundle.message((String)"npm.modules.install.global.types.directory.error", (Object[])new Object[0]);
                String string = dialogTitle = JSBundle.message((String)"npm.modules.install.global.types.dialog.title", (Object[])new Object[0]);
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"dialogTitle");
                this.logInstallingError(project, notificationAreaComponent, message, string);
                return;
            }
            Consumer<List<File>> callback = this.getCreateLibraryCallback(project, description, onLibraryCreated);
            PackageManagementService.Listener listener2 = new PackageManagementService.Listener(project, notificationAreaComponent, description, callback){
                final /* synthetic */ Project $project;
                final /* synthetic */ Component $notificationAreaComponent;
                final /* synthetic */ DownloadableFileSetDescription $description;
                final /* synthetic */ Consumer $callback;

                public void operationStarted(@Nullable String packageName) {
                }

                public void operationFinished(@Nullable String packageName, @Nullable PackageManagementService.ErrorDescription errorDescription) {
                    ApplicationManager.getApplication().invokeLater(new Runnable(this, errorDescription){
                        final /* synthetic */ downloadUsingNpm.listener.1 this$0;
                        final /* synthetic */ PackageManagementService.ErrorDescription $errorDescription;

                        public final void run() {
                            if (this.this$0.$project.isDisposed()) {
                                return;
                            }
                            if (this.$errorDescription != null) {
                                String message = JSBundle.message((String)"node.js.quickfix.install.node.module.error.prefix.text", (Object[])new Object[]{this.$errorDescription.getMessage()});
                                String dialogTitle = JSBundle.message((String)"node.js.quickfix.install.node.module.error.no.interpreter.title", (Object[])new Object[0]);
                                Project project = this.this$0.$project;
                                Component component = this.this$0.$notificationAreaComponent;
                                String string = dialogTitle;
                                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"dialogTitle");
                                com.intellij.lang.javascript.library.download.TypeScriptDefinitionFilesRootsProvider$LibraryCreator.access$logInstallingError(TypeScriptDefinitionFilesRootsProvider.LibraryCreator, project, component, message, string);
                                return;
                            }
                            String globalTypesDirectoryPath = TypeScriptDefinitionFilesDirectory.getGlobalTypesDirectoryPath();
                            File ioFile = new File(globalTypesDirectoryPath);
                            VirtualFile globalTypesDirectory2 = (VirtualFile)WriteAction.compute((ThrowableComputable)((ThrowableComputable)new ThrowableComputable<T, E>(ioFile){
                                final /* synthetic */ File $ioFile;

                                @Nullable
                                public final VirtualFile compute() {
                                    return VfsUtil.findFileByIoFile((File)this.$ioFile, (boolean)true);
                                }
                                {
                                    this.$ioFile = file;
                                }
                            }));
                            if (globalTypesDirectory2 == null) {
                                return;
                            }
                            String typesTargetPath = TypeScriptDefinitionFilesDirectory.getGlobalTypesTargetPath(this.this$0.$description.getName());
                            List<String> relatedPackages = new TypeScriptRelatedPackagesCollector(new File(typesTargetPath), globalTypesDirectory2).collectShortPackageNames();
                            Collection collection = relatedPackages;
                            if (!collection.isEmpty()) {
                                TypeScriptRelatedPackagesStorage typeScriptRelatedPackagesStorage = TypeScriptRelatedPackagesStorage.getStorage(this.this$0.$project);
                                if (typeScriptRelatedPackagesStorage != null) {
                                    typeScriptRelatedPackagesStorage.writeData(globalTypesDirectory2, this.this$0.$description.getName(), (Collection<String>)relatedPackages);
                                }
                            }
                            File packageFile = new File(typesTargetPath);
                            this.this$0.$callback.consume((Object)CollectionsKt.listOf((Object)packageFile));
                        }
                        {
                            this.this$0 = var1_1;
                            this.$errorDescription = errorDescription;
                        }
                    });
                }
                {
                    this.$project = $captured_local_variable$0;
                    this.$notificationAreaComponent = $captured_local_variable$1;
                    this.$description = $captured_local_variable$2;
                    this.$callback = $captured_local_variable$3;
                }
            };
            PackageInstaller packageInstaller = new PackageInstaller(project, interpreter, "@types/" + description.getName(), null, file, listener2, "--ignore-scripts");
            ApplicationManager.getApplication().invokeLater(new Runnable(project, packageInstaller){
                final /* synthetic */ Project $project;
                final /* synthetic */ PackageInstaller $packageInstaller;

                public final void run() {
                    if (this.$project.isDisposed()) {
                        return;
                    }
                    ProgressManager.getInstance().runProcessWithProgressAsynchronously((Task.Backgroundable)this.$packageInstaller, (ProgressIndicator)new BackgroundableProcessIndicator((Task.Backgroundable)this.$packageInstaller));
                }
                {
                    this.$project = project;
                    this.$packageInstaller = packageInstaller;
                }
            }, modalityState);
        }

        private final void logInstallingError(Project project, Component notificationAreaComponent, String message, String dialogTitle) {
            if (notificationAreaComponent != null) {
                Messages.showErrorDialog((Component)notificationAreaComponent, (String)message, (String)dialogTitle);
            } else {
                Messages.showErrorDialog((Project)project, (String)message, (String)dialogTitle);
            }
        }

        private final boolean createRequiredDirectories(File file) {
            if (!file.exists() && !FileUtil.createDirectory((File)file)) {
                return false;
            }
            File nodeModulesDir = new File(file, "node_modules");
            return nodeModulesDir.exists() || FileUtil.createDirectory((File)file);
        }

        /*
         * WARNING - void declaration
         */
        private final void downloadByUrl(DownloadableFileSetDescription description, Project project, Runnable onLibraryCreated, Component notificationAreaComponent, ModalityState modalityState) {
            try {
                void $receiver$iv$iv;
                Iterable $receiver$iv;
                Iterable iterable = $receiver$iv = (Iterable)description.getFiles();
                Collection destination$iv$iv = new ArrayList();
                void $receiver$iv$iv$iv = $receiver$iv$iv;
                for (Object element$iv$iv$iv : $receiver$iv$iv$iv) {
                    String string;
                    Object element$iv$iv = element$iv$iv$iv;
                    DownloadableFileDescription it = (DownloadableFileDescription)element$iv$iv;
                    if (it.getDownloadUrl() == null) continue;
                    String it$iv$iv = string;
                    destination$iv$iv.add(it$iv$iv);
                }
                List urls = (List)destination$iv$iv;
                Consumer<List<File>> callback = this.getCreateLibraryCallback(project, description, onLibraryCreated);
                ApplicationManager.getApplication().invokeLater(new Runnable(project, urls, notificationAreaComponent, callback, description){
                    final /* synthetic */ Project $project;
                    final /* synthetic */ List $urls;
                    final /* synthetic */ Component $notificationAreaComponent;
                    final /* synthetic */ Consumer $callback;
                    final /* synthetic */ DownloadableFileSetDescription $description;

                    public final void run() {
                        JSScriptingContextProvider.doDownload(this.$project, ContainerUtil.newArrayList((Iterable)ContainerUtil.newLinkedHashSet((Iterable)this.$urls)), "Downloading typings", this.$notificationAreaComponent, (Consumer<List<File>>)this.$callback, new JSDownloadManager(this, TypeScriptDefinitionFilesDirectory.getGlobalTypesTargetPath(this.$description.getName()), null){
                            final /* synthetic */ downloadByUrl.1 this$0;

                            @NotNull
                            protected String getResultFileName(@NotNull String extension, boolean name) {
                                String string;
                                Intrinsics.checkParameterIsNotNull((Object)extension, (String)"extension");
                                String source = this.getActualSource();
                                String fileName = PathUtil.getFileName((String)source);
                                CharSequence charSequence = fileName;
                                if (charSequence.length() > 0) {
                                    String string2 = fileName;
                                    string = string2;
                                    Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"fileName");
                                } else {
                                    string = extension;
                                }
                                return string;
                            }
                            {
                                this.this$0 = $outer;
                                super($super_call_param$1, $super_call_param$2);
                            }
                        });
                    }
                    {
                        this.$project = project;
                        this.$urls = list;
                        this.$notificationAreaComponent = component;
                        this.$callback = consumer;
                        this.$description = downloadableFileSetDescription;
                    }
                }, modalityState);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        private final Consumer<List<File>> getCreateLibraryCallback(Project project, DownloadableFileSetDescription description, Runnable onLibraryCreated) {
            return (Consumer)new Consumer<List<? extends File>>(description, project, onLibraryCreated){
                final /* synthetic */ DownloadableFileSetDescription $description;
                final /* synthetic */ Project $project;
                final /* synthetic */ Runnable $onLibraryCreated;

                public final void consume(List<? extends File> list) {
                    if (list.isEmpty()) {
                        return;
                    }
                    WriteAction.run((ThrowableRunnable)((ThrowableRunnable)new ThrowableRunnable<E>(this){
                        final /* synthetic */ getCreateLibraryCallback.1 this$0;

                        public final void run() {
                            block1: {
                                ApplicationManager.getApplication().assertIsDispatchThread();
                                String libName = com.intellij.lang.javascript.library.download.TypeScriptDefinitionFilesRootsProvider$LibraryCreator.access$getNameForLibrary(TypeScriptDefinitionFilesRootsProvider.LibraryCreator, this.this$0.$description);
                                JSLibraryManager libraryManager = JSLibraryManager.getInstance(this.this$0.$project);
                                LibraryTable libTable = libraryManager.getLibraryTable(ScriptingLibraryModel.LibraryLevel.GLOBAL);
                                if (libTable.getLibraryByName(libName) != null) {
                                    return;
                                }
                                libraryManager.createLibrary(libName, VirtualFile.EMPTY_ARRAY, VirtualFile.EMPTY_ARRAY, ArrayUtil.EMPTY_STRING_ARRAY, ScriptingLibraryModel.LibraryLevel.GLOBAL, false);
                                libraryManager.commitChanges();
                                JSLibraryMappings mappings = JSLibraryMappings.getInstance(this.this$0.$project);
                                mappings.associate(null, libName, false);
                                Runnable runnable = this.this$0.$onLibraryCreated;
                                if (runnable == null) break block1;
                                runnable.run();
                            }
                        }
                        {
                            this.this$0 = var1_1;
                        }
                    }));
                }
                {
                    this.$description = downloadableFileSetDescription;
                    this.$project = project;
                    this.$onLibraryCreated = runnable;
                }
            };
        }

        private final String getNameForLibrary(DownloadableFileSetDescription description) {
            return description.getVersionString() + "/" + description.getName();
        }

        private LibraryCreator() {
        }

        public static final /* synthetic */ void access$downloadUsingNpm(LibraryCreator $this, @NotNull DownloadableFileSetDescription description, @NotNull Project project, @NotNull NodeJsLocalInterpreter interpreter, @Nullable Runnable onLibraryCreated, @Nullable Component notificationAreaComponent, @NotNull ModalityState modalityState) {
            $this.downloadUsingNpm(description, project, interpreter, onLibraryCreated, notificationAreaComponent, modalityState);
        }

        public static final /* synthetic */ void access$downloadByUrl(LibraryCreator $this, @NotNull DownloadableFileSetDescription description, @NotNull Project project, @Nullable Runnable onLibraryCreated, @Nullable Component notificationAreaComponent, @NotNull ModalityState modalityState) {
            $this.downloadByUrl(description, project, onLibraryCreated, notificationAreaComponent, modalityState);
        }

        public static final /* synthetic */ void access$logInstallingError(LibraryCreator $this, @NotNull Project project, @Nullable Component notificationAreaComponent, @Nullable String message, @NotNull String dialogTitle) {
            $this.logInstallingError(project, notificationAreaComponent, message, dialogTitle);
        }

        @NotNull
        public static final /* synthetic */ String access$getNameForLibrary(LibraryCreator $this, @NotNull DownloadableFileSetDescription description) {
            return $this.getNameForLibrary(description);
        }

        public /* synthetic */ LibraryCreator(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

