/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.linter;

import com.intellij.lang.javascript.linter.PathHolder;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.BidirectionalMap;
import java.io.File;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.NotNull;

public class SharedConfigurationPaths {
    private final Project myProject;
    private final BidirectionalMap<VirtualFile, PathHolderImpl> myPaths;
    private final BidirectionalMap<String, PathHolderImpl> myNotExisting;
    private final Object myLock;

    public static SharedConfigurationPaths getInstance(@NotNull Project project) {
        if (project == null) {
            SharedConfigurationPaths.$$$reportNull$$$0(0);
        }
        return (SharedConfigurationPaths)ServiceManager.getService((Project)project, SharedConfigurationPaths.class);
    }

    public SharedConfigurationPaths(Project project) {
        this.myProject = project;
        this.myLock = new Object();
        this.myPaths = new BidirectionalMap();
        this.myNotExisting = new BidirectionalMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    PathHolderImpl remove(@NotNull VirtualFile file) {
        if (file == null) {
            SharedConfigurationPaths.$$$reportNull$$$0(1);
        }
        Object object = this.myLock;
        synchronized (object) {
            PathHolderImpl holder = (PathHolderImpl)this.myPaths.remove((Object)file);
            if (holder != null) {
                return holder;
            }
            return (PathHolderImpl)this.myNotExisting.remove((Object)FileUtil.toSystemIndependentName((String)file.getPath()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void add(@NotNull VirtualFile file, PathHolderImpl holder) {
        if (file == null) {
            SharedConfigurationPaths.$$$reportNull$$$0(2);
        }
        String name = FileUtil.toSystemIndependentName((String)file.getPath());
        Object object = this.myLock;
        synchronized (object) {
            this.myNotExisting.remove((Object)name);
            this.myPaths.put((Object)file, (Object)holder);
        }
        holder.rename(name);
    }

    public PathHolder createPathHolder(Runnable saver) {
        return new PathHolderImpl(saver);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/javascript/linter/SharedConfigurationPaths";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getInstance";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "remove";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "add";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public class PathHolderImpl
    implements PathHolder {
        private final Runnable mySaver;
        private final AtomicReference<String> myPath;

        public PathHolderImpl(Runnable saver) {
            this.mySaver = saver;
            this.myPath = new AtomicReference();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setPath(@NotNull String path) {
            if (path == null) {
                PathHolderImpl.$$$reportNull$$$0(0);
            }
            if (Comparing.equal((String)this.myPath.get(), (String)path)) {
                return;
            }
            this.myPath.set(path);
            File file = new File(path);
            file = file.isAbsolute() ? file : new File(SharedConfigurationPaths.this.myProject.getBasePath(), path);
            VirtualFile virtualFile = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(file);
            Object object = SharedConfigurationPaths.this.myLock;
            synchronized (object) {
                SharedConfigurationPaths.this.myPaths.removeValue((Object)this);
                SharedConfigurationPaths.this.myNotExisting.removeValue((Object)this);
                if (virtualFile != null) {
                    SharedConfigurationPaths.this.myPaths.put((Object)virtualFile, (Object)this);
                } else {
                    String independentName = FileUtil.toSystemIndependentName((String)path);
                    SharedConfigurationPaths.this.myNotExisting.put((Object)independentName, (Object)this);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void rename(@NotNull String newValue) {
            if (newValue == null) {
                PathHolderImpl.$$$reportNull$$$0(1);
            }
            Object object = SharedConfigurationPaths.this.myLock;
            synchronized (object) {
                this.myPath.set(FileUtil.toSystemDependentName((String)newValue));
            }
            this.mySaver.run();
        }

        @Override
        public String getPath() {
            return this.myPath.get();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "path";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "newValue";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/lang/javascript/linter/SharedConfigurationPaths$PathHolderImpl";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setPath";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "rename";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

