/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.linter.jshint.config;

import com.google.common.base.Splitter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.intellij.lang.javascript.linter.JSLinterConfigFileUtil;
import com.intellij.lang.javascript.linter.jshint.JSHintIgnoreInfo;
import com.intellij.lang.javascript.linter.jshint.JSHintOptionsState;
import com.intellij.lang.javascript.linter.jshint.config.JSHintConfigFileType;
import com.intellij.lang.javascript.linter.jshint.config.JSHintConfigLookupResult;
import com.intellij.lang.javascript.linter.jshint.config.JSHintConfigParser;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.webcore.util.JsonUtil;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSHintConfigFileUtil {
    public static final String EXTENDS_KEY = "extends";
    private static final String AUTO_SCAN_CONFIG_NAME = ".jshintrc";
    private static final String PACKAGE_JSON_JSHINT_CONFIG = "jshintConfig";
    private static final Logger LOG = Logger.getInstance(JSHintConfigFileUtil.class);

    private JSHintConfigFileUtil() {
    }

    public static boolean isJSHintConfigFile(@NotNull PsiElement element) {
        PsiFile file;
        if (element == null) {
            JSHintConfigFileUtil.$$$reportNull$$$0(0);
        }
        return (file = element.getContainingFile()) != null && JSHintConfigFileUtil.isJSHintConfigFile(file);
    }

    public static boolean isJSHintConfigFile(@NotNull PsiFile file) {
        if (file == null) {
            JSHintConfigFileUtil.$$$reportNull$$$0(1);
        }
        VirtualFile vFile = file.getViewProvider().getVirtualFile();
        return ((Object)((Object)JSHintConfigFileType.INSTANCE)).equals(vFile.getFileType());
    }

    public static boolean isWarningKey(@NotNull String key) {
        if (key == null) {
            JSHintConfigFileUtil.$$$reportNull$$$0(2);
        }
        return key.startsWith("+W") || key.startsWith("-W");
    }

    public static boolean isIgnored(@NotNull Project project, @NotNull VirtualFile file) {
        VirtualFile fileDir;
        if (project == null) {
            JSHintConfigFileUtil.$$$reportNull$$$0(3);
        }
        if (file == null) {
            JSHintConfigFileUtil.$$$reportNull$$$0(4);
        }
        if ((fileDir = file.getParent()) == null) {
            return true;
        }
        VirtualFile jshintIgnore = JSLinterConfigFileUtil.findFile(project, fileDir, ".jshintignore");
        if (jshintIgnore == null) {
            return false;
        }
        try {
            JSHintIgnoreInfo ignoreInfo = JSHintConfigFileUtil.parseIgnores(jshintIgnore);
            return ignoreInfo.isIgnore(file);
        }
        catch (IOException e) {
            LOG.warn("Cannot read " + jshintIgnore, (Throwable)e);
            return false;
        }
    }

    @NotNull
    private static JSHintIgnoreInfo parseIgnores(@NotNull VirtualFile jshintIgnore) throws IOException {
        if (jshintIgnore == null) {
            JSHintConfigFileUtil.$$$reportNull$$$0(5);
        }
        String text = JSLinterConfigFileUtil.loadActualText(jshintIgnore);
        Iterable lines = Splitter.on((String)"\n").split((CharSequence)text);
        ArrayList list = ContainerUtil.newArrayList();
        for (String line : lines) {
            if ((line = line.trim()).isEmpty()) continue;
            list.add(line);
        }
        JSHintIgnoreInfo jSHintIgnoreInfo = new JSHintIgnoreInfo(jshintIgnore, list);
        if (jSHintIgnoreInfo == null) {
            JSHintConfigFileUtil.$$$reportNull$$$0(6);
        }
        return jSHintIgnoreInfo;
    }

    @Nullable
    public static JSHintConfigLookupResult lookupConfig(@NotNull Project project, @NotNull VirtualFile file) {
        VirtualFile jshintConfig;
        VirtualFile fileDir;
        if (project == null) {
            JSHintConfigFileUtil.$$$reportNull$$$0(7);
        }
        if (file == null) {
            JSHintConfigFileUtil.$$$reportNull$$$0(8);
        }
        if ((fileDir = file.getParent()) == null) {
            return null;
        }
        VirtualFile packageJson = JSLinterConfigFileUtil.findFile(project, fileDir, "package.json");
        if (packageJson != null) {
            try {
                JSHintOptionsState optionsState = JSHintConfigFileUtil.parsePackageJson(packageJson);
                if (optionsState != null) {
                    return JSHintConfigLookupResult.createSuccessfulResult(packageJson, optionsState);
                }
            }
            catch (IOException e) {
                return JSHintConfigLookupResult.createErrorResult(packageJson, "Failed to read 'jshintConfig' property from package.json");
            }
        }
        if ((jshintConfig = JSLinterConfigFileUtil.findFileUpFileSystemRoot(fileDir, AUTO_SCAN_CONFIG_NAME)) != null) {
            return JSHintConfigParser.parse(jshintConfig);
        }
        return null;
    }

    @Nullable
    public static JSHintConfigLookupResult loadConfigByPath(@NotNull String configFilePath) {
        String systemIndependentPath;
        LocalFileSystem fileSystem;
        VirtualFile file;
        if (configFilePath == null) {
            JSHintConfigFileUtil.$$$reportNull$$$0(9);
        }
        if ((file = (fileSystem = LocalFileSystem.getInstance()).findFileByPath(systemIndependentPath = FileUtil.toSystemIndependentName((String)configFilePath))) == null || !file.isValid()) {
            file = fileSystem.refreshAndFindFileByPath(systemIndependentPath);
        }
        if (file != null && file.isValid() && !file.isDirectory()) {
            return JSHintConfigParser.parse(file);
        }
        return null;
    }

    @Nullable
    private static JSHintOptionsState parsePackageJson(@NotNull VirtualFile packageJson) throws IOException {
        if (packageJson == null) {
            JSHintConfigFileUtil.$$$reportNull$$$0(10);
        }
        String text = JSLinterConfigFileUtil.loadActualText(packageJson);
        JsonReader reader = new JsonReader((Reader)new StringReader(text));
        reader.setLenient(true);
        JsonToken topToken = reader.peek();
        if (topToken != JsonToken.BEGIN_OBJECT) {
            throw new IOException("Unexpected json element " + topToken);
        }
        reader.beginObject();
        while (reader.hasNext()) {
            String name = reader.nextName();
            if (name.equals(PACKAGE_JSON_JSHINT_CONFIG)) {
                return JSHintConfigFileUtil.parseOptionsState(reader);
            }
            reader.skipValue();
        }
        reader.endObject();
        reader.close();
        return null;
    }

    public static boolean isExtendsKey(@NotNull PsiElement element) {
        if (element == null) {
            JSHintConfigFileUtil.$$$reportNull$$$0(11);
        }
        return EXTENDS_KEY.equals(StringUtil.unquoteString((String)element.getText()));
    }

    @NotNull
    static JSHintOptionsState parseOptionsState(@NotNull JsonReader reader) throws IOException {
        JsonToken topToken;
        if (reader == null) {
            JSHintConfigFileUtil.$$$reportNull$$$0(12);
        }
        if ((topToken = reader.peek()) != JsonToken.BEGIN_OBJECT) {
            throw new IOException("Unexpected json element " + topToken);
        }
        reader.beginObject();
        JSHintOptionsState.Builder builder = new JSHintOptionsState.Builder();
        while (reader.hasNext()) {
            String name = reader.nextName();
            Object value = JsonUtil.nextAny((JsonReader)reader);
            builder.put(name, value);
        }
        reader.endObject();
        JSHintOptionsState jSHintOptionsState = builder.build();
        if (jSHintOptionsState == null) {
            JSHintConfigFileUtil.$$$reportNull$$$0(13);
        }
        return jSHintOptionsState;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jshintIgnore";
                break;
            }
            case 6: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/linter/jshint/config/JSHintConfigFileUtil";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configFilePath";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageJson";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reader";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/linter/jshint/config/JSHintConfigFileUtil";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "parseIgnores";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "parseOptionsState";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isJSHintConfigFile";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isWarningKey";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isIgnored";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "parseIgnores";
                break;
            }
            case 6: 
            case 13: {
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "lookupConfig";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "loadConfigByPath";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "parsePackageJson";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isExtendsKey";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "parseOptionsState";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

