/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.patterns;

import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.javascript.index.JSSymbolUtil;
import com.intellij.lang.javascript.patterns.JSElementPattern;
import com.intellij.lang.javascript.patterns.JSReferenceExpressionPattern;
import com.intellij.lang.javascript.psi.JSArgumentList;
import com.intellij.lang.javascript.psi.JSAssignmentExpression;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.ecma6.ES6TaggedTemplateExpression;
import com.intellij.lang.javascript.psi.ecma6.JSStringTemplateExpression;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.InitialPatternCondition;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.psi.PsiElement;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ProcessingContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSPatterns
extends PlatformPatterns {
    @NotNull
    public static JSElementPattern.Capture<JSStringTemplateExpression> stringTemplate() {
        JSElementPattern.Capture<JSStringTemplateExpression> capture = new JSElementPattern.Capture<JSStringTemplateExpression>(JSStringTemplateExpression.class);
        if (capture == null) {
            JSPatterns.$$$reportNull$$$0(0);
        }
        return capture;
    }

    @NotNull
    public static JSElementPattern.Capture<ES6TaggedTemplateExpression> taggedTemplate(@NotNull ElementPattern<? extends JSExpression> tagPattern) {
        if (tagPattern == null) {
            JSPatterns.$$$reportNull$$$0(1);
        }
        JSElementPattern.Capture capture = (JSElementPattern.Capture)new JSElementPattern.Capture<ES6TaggedTemplateExpression>(ES6TaggedTemplateExpression.class).withFirstChild(tagPattern);
        if (capture == null) {
            JSPatterns.$$$reportNull$$$0(2);
        }
        return capture;
    }

    @NotNull
    public static JSElementPattern.Capture<ES6TaggedTemplateExpression> taggedTemplate(final @NotNull String tag) {
        if (tag == null) {
            JSPatterns.$$$reportNull$$$0(3);
        }
        JSElementPattern.Capture<JSReferenceExpression> expressionPattern = new JSElementPattern.Capture<JSReferenceExpression>(new InitialPatternCondition<JSReferenceExpression>(JSReferenceExpression.class){

            public boolean accepts(@Nullable Object o, ProcessingContext context) {
                if (!super.accepts(o, context)) {
                    return false;
                }
                JSReferenceExpression referenceExpression = o instanceof JSReferenceExpression ? (JSReferenceExpression)o : null;
                return JSSymbolUtil.isAccurateReferenceExpressionName(referenceExpression, tag);
            }
        });
        JSElementPattern.Capture<ES6TaggedTemplateExpression> capture = JSPatterns.taggedTemplate(expressionPattern);
        if (capture == null) {
            JSPatterns.$$$reportNull$$$0(4);
        }
        return capture;
    }

    @NotNull
    public static JSElementPattern taggedString(@NotNull String tag) {
        if (tag == null) {
            JSPatterns.$$$reportNull$$$0(5);
        }
        JSElementPattern jSElementPattern = (JSElementPattern)JSPatterns.stringTemplate().withParent((ElementPattern)JSPatterns.taggedTemplate(tag));
        if (jSElementPattern == null) {
            JSPatterns.$$$reportNull$$$0(6);
        }
        return jSElementPattern;
    }

    public static JSElementPattern.Capture<JSLiteralExpression> jsLiteralExpression() {
        return new JSElementPattern.Capture<JSLiteralExpression>(new InitialPatternCondition<JSLiteralExpression>(JSLiteralExpression.class){

            public boolean accepts(@Nullable Object o, ProcessingContext context) {
                return o instanceof JSLiteralExpression;
            }
        });
    }

    @NotNull
    public static JSElementPattern.Capture<JSExpression> jsExpression() {
        JSElementPattern.Capture<JSExpression> capture = new JSElementPattern.Capture<JSExpression>(JSExpression.class);
        if (capture == null) {
            JSPatterns.$$$reportNull$$$0(7);
        }
        return capture;
    }

    @NotNull
    public static JSReferenceExpressionPattern jsReferenceExpression() {
        JSReferenceExpressionPattern jSReferenceExpressionPattern = new JSReferenceExpressionPattern();
        if (jSReferenceExpressionPattern == null) {
            JSPatterns.$$$reportNull$$$0(8);
        }
        return jSReferenceExpressionPattern;
    }

    public static JSElementPattern.Capture<JSExpression> jsArgument(String functionName, int index) {
        return JSPatterns.jsArgument(functionName, index, -1);
    }

    public static JSElementPattern.Capture<JSExpression> jsArgument(final String functionName, final int index, final int argCount) {
        return new JSElementPattern.Capture<JSExpression>(new InitialPatternCondition<JSExpression>(JSExpression.class){

            public boolean accepts(@Nullable Object o, ProcessingContext context) {
                if (!(o instanceof JSExpression)) {
                    return false;
                }
                PsiElement parent = ((JSExpression)o).getParent();
                if (!(parent instanceof JSArgumentList)) {
                    return false;
                }
                PsiElement parent1 = parent.getParent();
                if (!(parent1 instanceof JSCallExpression)) {
                    return false;
                }
                JSExpression methodExpression = ((JSCallExpression)parent1).getMethodExpression();
                if (!(methodExpression instanceof JSReferenceExpression)) {
                    return false;
                }
                String referencedName = ((JSReferenceExpression)methodExpression).getReferencedName();
                if (referencedName == null || !referencedName.equals(functionName)) {
                    return false;
                }
                JSExpression[] children = ((JSArgumentList)parent).getArguments();
                return (argCount == -1 || argCount == children.length) && index < children.length && children[index] == o;
            }
        });
    }

    public static JSElementPattern.Capture<JSExpression> asAssignedValue(final String propertyName, final String className, final String ... varNames) {
        return new JSElementPattern.Capture<JSExpression>(new InitialPatternCondition<JSExpression>(JSExpression.class){

            public boolean accepts(@Nullable Object o, ProcessingContext context) {
                if (!(o instanceof JSExpression)) {
                    return false;
                }
                PsiElement parent = ((JSExpression)o).getParent();
                if (!(parent instanceof JSAssignmentExpression)) {
                    return false;
                }
                if (parent.getContainingFile().getLanguage() != JavaScriptSupportLoader.ECMA_SCRIPT_L4) {
                    return false;
                }
                JSAssignmentExpression assignmentExpression = (JSAssignmentExpression)parent;
                if (assignmentExpression.getROperand() != o) {
                    return false;
                }
                JSExpression exp = assignmentExpression.getLOperand();
                if (!(exp instanceof JSDefinitionExpression)) {
                    return false;
                }
                if (!((exp = ((JSDefinitionExpression)exp).getExpression()) instanceof JSReferenceExpression)) {
                    return false;
                }
                JSReferenceExpression refExp = (JSReferenceExpression)exp;
                if (!propertyName.equals(refExp.getReferencedName())) {
                    return false;
                }
                if (varNames.length > 0) {
                    PsiElement firstChild = refExp.getFirstChild();
                    if (!(firstChild instanceof JSReferenceExpression)) {
                        return false;
                    }
                    if (ArrayUtil.find((Object[])varNames, (Object)((JSReferenceExpression)firstChild).getReferencedName()) < 0) {
                        return false;
                    }
                }
                if (className != null && className.length() > 0 && !className.equals("*")) {
                    PsiElement resolved = refExp.resolve();
                    if (!(resolved instanceof JSFunction) || !((JSFunction)resolved).isSetProperty()) {
                        return false;
                    }
                    PsiElement jsClass = resolved.getParent();
                    if (!(jsClass instanceof JSClass) || !className.equals(((JSClass)jsClass).getQualifiedName())) {
                        return false;
                    }
                }
                return true;
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/patterns/JSPatterns";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tagPattern";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tag";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "stringTemplate";
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/patterns/JSPatterns";
                break;
            }
            case 2: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "taggedTemplate";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "taggedString";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "jsExpression";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "jsReferenceExpression";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "taggedTemplate";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "taggedString";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

