/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi;

import com.intellij.lang.javascript.psi.JSNamepath;
import com.intellij.lang.javascript.psi.JSQualifiedName;
import com.intellij.lang.javascript.psi.JSQualifiedNameImpl;
import com.intellij.lang.javascript.psi.types.JSContext;
import com.intellij.openapi.util.text.StringUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSNamepathImpl
implements JSNamepath {
    private static final JSNamepathImpl EMPTY = new JSNamepathImpl("", null);
    @NotNull
    private final String myName;
    @Nullable
    private final JSNamepathImpl myParent;
    private final char myContextChar;

    public JSNamepathImpl(@NotNull String name, @Nullable JSNamepathImpl parent) {
        if (name == null) {
            JSNamepathImpl.$$$reportNull$$$0(0);
        }
        this(name, parent, '\u0000');
    }

    public JSNamepathImpl(@NotNull String name, @Nullable JSNamepathImpl parent, char contextChar) {
        if (name == null) {
            JSNamepathImpl.$$$reportNull$$$0(1);
        }
        this.myName = name;
        this.myContextChar = contextChar;
        this.myParent = parent;
    }

    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            JSNamepathImpl.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    public String getQualifiedName() {
        StringBuilder builder = new StringBuilder();
        this.appendQualifiedName(builder);
        String string = builder.toString();
        if (string == null) {
            JSNamepathImpl.$$$reportNull$$$0(3);
        }
        return string;
    }

    private void appendQualifiedName(@NotNull StringBuilder builder) {
        if (builder == null) {
            JSNamepathImpl.$$$reportNull$$$0(4);
        }
        if (this.myParent != null) {
            this.myParent.appendQualifiedName(builder);
            builder.append('.');
        }
        builder.append(this.myName);
    }

    @Nullable
    public JSNamepathImpl getParent() {
        return this.myParent;
    }

    @NotNull
    public List<String> toComponents() {
        List<String> list = JSQualifiedNameImpl.toComponents((JSQualifiedName)this);
        if (list == null) {
            JSNamepathImpl.$$$reportNull$$$0(5);
        }
        return list;
    }

    public char getForcedContextChar() {
        return this.myContextChar == '\u0000' ? (char)'.' : (char)this.myContextChar;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        if (this.myParent != null) {
            builder.append(this.myParent.getQualifiedName());
            if (this.myParent.myContextChar == '\u0000') {
                builder.append('.');
            }
        }
        builder.append(this.myName);
        if (this.myContextChar != '\u0000') {
            builder.append(this.myContextChar);
        }
        return builder.toString();
    }

    @NotNull
    public static JSNamepathImpl fromNamepath(@NotNull String namepath) {
        if (namepath == null) {
            JSNamepathImpl.$$$reportNull$$$0(6);
        }
        int pos = 0;
        JSNamepathImpl result = null;
        while (pos < namepath.length()) {
            int separatorPos = StringUtil.indexOfAny((String)namepath, (String)".#~", (int)pos, (int)namepath.length());
            if (separatorPos == -1) {
                separatorPos = namepath.length();
            }
            if (separatorPos > pos) {
                char contextChar = separatorPos < namepath.length() ? namepath.charAt(separatorPos) : (char)'\u0000';
                result = new JSNamepathImpl(namepath.substring(pos, separatorPos), result, contextChar);
            }
            pos = separatorPos + 1;
        }
        JSNamepathImpl jSNamepathImpl = result != null ? result : EMPTY;
        if (jSNamepathImpl == null) {
            JSNamepathImpl.$$$reportNull$$$0(7);
        }
        return jSNamepathImpl;
    }

    @NotNull
    public JSNamepathImpl withName(@NotNull String name) {
        if (name == null) {
            JSNamepathImpl.$$$reportNull$$$0(8);
        }
        JSNamepathImpl jSNamepathImpl = new JSNamepathImpl(name, this.myParent, this.myContextChar);
        if (jSNamepathImpl == null) {
            JSNamepathImpl.$$$reportNull$$$0(9);
        }
        return jSNamepathImpl;
    }

    @NotNull
    public JSContext getJSContext() {
        JSContext jSContext = this.myContextChar == '.' || this.myContextChar == '\u0000' ? JSContext.STATIC : (this.myContextChar == '#' ? JSContext.INSTANCE : JSContext.UNKNOWN);
        if (jSContext == null) {
            JSNamepathImpl.$$$reportNull$$$0(10);
        }
        return jSContext;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/JSNamepathImpl";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namepath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/JSNamepathImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getQualifiedName";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "toComponents";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "fromNamepath";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "withName";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getJSContext";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 10: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "appendQualifiedName";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "fromNamepath";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "withName";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

