/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.jsdoc.impl;

import com.intellij.codeInsight.daemon.EmptyResolveMessageProvider;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.documentation.JSDocumentationUtils;
import com.intellij.lang.javascript.psi.JSDestructuringContainer;
import com.intellij.lang.javascript.psi.JSDestructuringElement;
import com.intellij.lang.javascript.psi.JSDestructuringObject;
import com.intellij.lang.javascript.psi.JSDestructuringParameter;
import com.intellij.lang.javascript.psi.JSDestructuringProperty;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSParameterList;
import com.intellij.lang.javascript.psi.JSParameterListElement;
import com.intellij.lang.javascript.psi.jsdoc.JSDocComment;
import com.intellij.lang.javascript.psi.jsdoc.JSDocTag;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.ElementManipulator;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSDocParamReference
implements PsiReference,
EmptyResolveMessageProvider {
    @NotNull
    private JSDocTag myJSDocTag;
    @NotNull
    private TextRange myRangeInElement;
    @Nullable
    private final JSDocParamReference myQualifier;

    private JSDocParamReference(@NotNull JSDocTag elt, @NotNull TextRange rangeInElement, @Nullable JSDocParamReference qualifier) {
        if (elt == null) {
            JSDocParamReference.$$$reportNull$$$0(0);
        }
        if (rangeInElement == null) {
            JSDocParamReference.$$$reportNull$$$0(1);
        }
        this.myJSDocTag = elt;
        this.myRangeInElement = rangeInElement;
        this.myQualifier = qualifier;
    }

    public PsiElement getElement() {
        return this.myJSDocTag;
    }

    @NotNull
    public TextRange getRangeInElement() {
        TextRange textRange = this.myRangeInElement;
        if (textRange == null) {
            JSDocParamReference.$$$reportNull$$$0(2);
        }
        return textRange;
    }

    @NotNull
    public String getCanonicalText() {
        int offsetInText = this.myRangeInElement.getStartOffset();
        String string = this.myJSDocTag.getText().substring(offsetInText, offsetInText + this.myRangeInElement.getLength());
        if (string == null) {
            JSDocParamReference.$$$reportNull$$$0(3);
        }
        return string;
    }

    public PsiElement handleElementRename(String newElementName) throws IncorrectOperationException {
        ElementManipulator manipulator = ElementManipulators.getManipulator((PsiElement)this.myJSDocTag);
        this.myJSDocTag = (JSDocTag)manipulator.handleContentChange((PsiElement)this.myJSDocTag, this.myRangeInElement, newElementName);
        this.myRangeInElement = TextRange.from((int)this.myRangeInElement.getStartOffset(), (int)(this.myRangeInElement.getStartOffset() + newElementName.length()));
        return this.myJSDocTag;
    }

    public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            JSDocParamReference.$$$reportNull$$$0(4);
        }
        return null;
    }

    public boolean isReferenceTo(PsiElement element) {
        return element.isEquivalentTo(this.resolve());
    }

    private JSParameterList findParameterList() {
        JSDocComment docComment = this.getDocComment();
        return JSDocParamReference.findParameterList(docComment);
    }

    @Nullable
    public static JSParameterList findParameterList(@NotNull JSDocComment docComment) {
        JSFunction function;
        if (docComment == null) {
            JSDocParamReference.$$$reportNull$$$0(5);
        }
        return (function = JSDocumentationUtils.findFunctionAppliedTo(docComment)) != null ? function.getParameterList() : null;
    }

    public PsiElement resolve() {
        if (this.myQualifier != null) {
            JSDestructuringContainer target;
            PsiElement destructuringElement;
            PsiElement qualifierResolve = this.myQualifier.resolve();
            Object object = qualifierResolve instanceof JSDestructuringParameter ? qualifierResolve : (destructuringElement = qualifierResolve instanceof JSDestructuringProperty ? ((JSDestructuringProperty)qualifierResolve).getDestructuringElement() : null);
            if (destructuringElement instanceof JSDestructuringElement && (target = ((JSDestructuringElement)destructuringElement).getTarget()) instanceof JSDestructuringObject) {
                return ((JSDestructuringObject)target).findProperty(this.getCanonicalText());
            }
            return null;
        }
        JSDocComment docComment = this.getDocComment();
        JSFunction function = JSDocumentationUtils.findFunctionAppliedTo(docComment);
        if (function != null) {
            JSParameter[] parameters;
            String name = this.getCanonicalText();
            if ("arguments".equals(name)) {
                return this.getElement();
            }
            HashMap<Integer, String> tagNames = new HashMap<Integer, String>();
            JSDocumentationUtils.JSTagToParameterMap tagToParameters = JSDocumentationUtils.getTagToParameterMap(docComment, function, tagNames);
            for (Map.Entry entry : tagNames.entrySet()) {
                JSParameterListElement element;
                if (!name.equals(entry.getValue()) || (element = tagToParameters.getMatchedTags().get(entry.getKey())) == null) continue;
                return element;
            }
            for (JSParameter parameter : parameters = function.getParameterVariables()) {
                if (!name.equals(parameter.getName())) continue;
                return parameter;
            }
        }
        return null;
    }

    @NotNull
    private JSDocComment getDocComment() {
        JSDocComment docComment = (JSDocComment)PsiTreeUtil.getParentOfType((PsiElement)this.myJSDocTag, JSDocComment.class);
        assert (docComment != null);
        JSDocComment jSDocComment = docComment;
        if (jSDocComment == null) {
            JSDocParamReference.$$$reportNull$$$0(6);
        }
        return jSDocComment;
    }

    @NotNull
    public Object[] getVariants() {
        if (ArrayUtil.EMPTY_OBJECT_ARRAY == null) {
            JSDocParamReference.$$$reportNull$$$0(7);
        }
        return ArrayUtil.EMPTY_OBJECT_ARRAY;
    }

    public boolean isSoft() {
        return this.findParameterList() == null;
    }

    @NotNull
    public String getUnresolvedMessagePattern() {
        String string = JSBundle.message((String)"js.comment.matches.signature.inspection.problem2", (Object[])new Object[]{this.getCanonicalText()});
        if (string == null) {
            JSDocParamReference.$$$reportNull$$$0(8);
        }
        return string;
    }

    @NotNull
    public static PsiReference[] createReferences(@NotNull JSDocTag docTag) {
        List<TextRange> range;
        if (docTag == null) {
            JSDocParamReference.$$$reportNull$$$0(9);
        }
        if ((range = JSDocumentationUtils.getParameterNameRanges(docTag)).isEmpty()) {
            if (EMPTY_ARRAY == null) {
                JSDocParamReference.$$$reportNull$$$0(10);
            }
            return EMPTY_ARRAY;
        }
        TextRange firstRange = range.get(0);
        JSDocParamReference firstRef = new JSDocParamReference(docTag, firstRange, null);
        if (range.size() > 1 && firstRef.resolve() instanceof JSDestructuringParameter) {
            JSDocParamReference qualifier = firstRef;
            PsiReference[] result = new PsiReference[range.size()];
            result[0] = firstRef;
            for (int i = 1; i < range.size(); ++i) {
                TextRange textRange = range.get(i);
                qualifier = new JSDocParamReference(docTag, textRange, qualifier);
                result[i] = qualifier;
            }
            if (result == null) {
                JSDocParamReference.$$$reportNull$$$0(11);
            }
            return result;
        }
        PsiReference[] psiReferenceArray = new PsiReference[]{firstRef};
        if (psiReferenceArray == null) {
            JSDocParamReference.$$$reportNull$$$0(12);
        }
        return psiReferenceArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elt";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rangeInElement";
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/jsdoc/impl/JSDocParamReference";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "docComment";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "docTag";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/jsdoc/impl/JSDocParamReference";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getRangeInElement";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getCanonicalText";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getDocComment";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariants";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getUnresolvedMessagePattern";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "createReferences";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "bindToElement";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "findParameterList";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createReferences";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

