/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.types;

import com.intellij.lang.javascript.psi.JSRecordType;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.types.JSAnyType;
import com.intellij.lang.javascript.psi.types.JSFunctionTypeImpl;
import com.intellij.lang.javascript.psi.types.JSRecursiveTypeVisitor;
import com.intellij.lang.javascript.psi.types.JSTypeBaseImpl;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.JSUnionOrIntersectionType;
import com.intellij.lang.javascript.psi.types.primitives.JSNullType;
import com.intellij.lang.javascript.psi.types.primitives.JSUndefinedType;
import com.intellij.lang.javascript.psi.types.primitives.TypeScriptNeverJSTypeImpl;
import com.intellij.util.Function;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class JSCompositeTypeBaseImpl
extends JSTypeBaseImpl
implements JSType.CompositeStructure {
    private final List<JSType> myTypes;

    public static boolean isEmptyType(@Nullable JSType type) {
        return type == null || type instanceof TypeScriptNeverJSTypeImpl;
    }

    public static boolean isNullOrUndefinedType(@Nullable JSType type) {
        return type instanceof JSUndefinedType || type instanceof JSNullType;
    }

    @NotNull
    public static List<JSType> flattenTypes(@NotNull Stream<JSType> stream, @NotNull Class<? extends JSUnionOrIntersectionType> toFlatClass) {
        if (stream == null) {
            JSCompositeTypeBaseImpl.$$$reportNull$$$0(0);
        }
        if (toFlatClass == null) {
            JSCompositeTypeBaseImpl.$$$reportNull$$$0(1);
        }
        List<JSType> list = stream.flatMap(el -> {
            if (toFlatClass == null) {
                JSCompositeTypeBaseImpl.$$$reportNull$$$0(14);
            }
            return toFlatClass.isInstance(el) ? ((JSCompositeTypeBaseImpl)((Object)el)).getTypes().stream() : Stream.of(el);
        }).collect(Collectors.toList());
        if (list == null) {
            JSCompositeTypeBaseImpl.$$$reportNull$$$0(2);
        }
        return list;
    }

    public JSCompositeTypeBaseImpl(JSTypeSource source, JSType ... _types) {
        super(source);
        ArrayList list = new ArrayList(_types.length);
        Collections.addAll(list, _types);
        this.myTypes = Collections.unmodifiableList(list);
    }

    public JSCompositeTypeBaseImpl(@NotNull JSTypeSource source, Collection<JSType> _types) {
        if (source == null) {
            JSCompositeTypeBaseImpl.$$$reportNull$$$0(3);
        }
        super(source);
        ArrayList<JSType> list = new ArrayList<JSType>(_types);
        this.myTypes = Collections.unmodifiableList(list);
    }

    @NotNull
    public String getTypeText(JSType.TypeTextFormat format) {
        String delimiter = format == JSType.TypeTextFormat.PRESENTABLE || this.isTypeScript() && format == JSType.TypeTextFormat.CODE ? " " + this.getTypeSeparator() + " " : this.getTypeSeparator();
        String string = this.myTypes.stream().filter(el -> el != null).map(currentType -> {
            String presentation = this.getNestedTypePresentation(format, (JSType)currentType);
            return this.shouldWrapNestedType((JSType)currentType) ? "(" + presentation + ")" : presentation;
        }).collect(Collectors.joining(delimiter));
        if (string == null) {
            JSCompositeTypeBaseImpl.$$$reportNull$$$0(4);
        }
        return string;
    }

    private boolean shouldWrapNestedType(@NotNull JSType currentType) {
        if (currentType == null) {
            JSCompositeTypeBaseImpl.$$$reportNull$$$0(5);
        }
        return currentType instanceof JSUnionOrIntersectionType && ((Object)((Object)this)).getClass() != currentType.getClass() || currentType instanceof JSFunctionTypeImpl;
    }

    protected String getNestedTypePresentation(JSType.TypeTextFormat format, JSType t) {
        return t.getTypeText(format);
    }

    @Override
    public boolean isEquivalentToImpl(@NotNull JSType type, ProcessingContext processingContext, boolean allowResolve) {
        if (type == null) {
            JSCompositeTypeBaseImpl.$$$reportNull$$$0(6);
        }
        if (type instanceof JSCompositeTypeBaseImpl && type.getClass() == ((Object)((Object)this)).getClass()) {
            Iterator<JSType> iterator = ((JSCompositeTypeBaseImpl)type).getTypes().iterator();
            for (JSType jsType : this.getTypes()) {
                if (iterator.hasNext() && jsType.isEquivalentTo(iterator.next(), processingContext, allowResolve)) continue;
                return false;
            }
            return !iterator.hasNext();
        }
        return false;
    }

    @NotNull
    public List<JSType> getTypes() {
        List<JSType> list = this.myTypes;
        if (list == null) {
            JSCompositeTypeBaseImpl.$$$reportNull$$$0(7);
        }
        return list;
    }

    @Override
    public void accept(JSRecursiveTypeVisitor visitor) {
        visitor.visitJSCompositeBaseType((JSType)this);
    }

    @Override
    public void acceptChildren(JSRecursiveTypeVisitor visitor) {
        for (JSType type : this.myTypes) {
            type.accept(visitor);
        }
    }

    @NotNull
    protected abstract String getTypeSeparator();

    @Override
    @NotNull
    protected final JSType copyTypeHierarchy(@NotNull Function<JSType, JSType> childTransform) {
        if (childTransform == null) {
            JSCompositeTypeBaseImpl.$$$reportNull$$$0(8);
        }
        ArrayList newTypes = ContainerUtil.newArrayList();
        List<JSType> oldTypes = this.getTypes();
        for (JSType jsType : oldTypes) {
            newTypes.add(JSTypeUtils.transformTypeHierarchySafe(jsType, childTransform));
        }
        if (ContainerUtil.equalsIdentity((List)newTypes, oldTypes)) {
            JSCompositeTypeBaseImpl jSCompositeTypeBaseImpl = this;
            if (jSCompositeTypeBaseImpl == null) {
                JSCompositeTypeBaseImpl.$$$reportNull$$$0(9);
            }
            return jSCompositeTypeBaseImpl;
        }
        JSCompositeTypeBaseImpl jSCompositeTypeBaseImpl = this.createType(newTypes, this.getSource());
        if (jSCompositeTypeBaseImpl == null) {
            JSCompositeTypeBaseImpl.$$$reportNull$$$0(10);
        }
        return jSCompositeTypeBaseImpl;
    }

    @NotNull
    protected abstract JSCompositeTypeBaseImpl createType(@NotNull List<JSType> var1, @NotNull JSTypeSource var2);

    @Override
    @NotNull
    protected JSType copyWithNewSource(@NotNull JSTypeSource source) {
        if (source == null) {
            JSCompositeTypeBaseImpl.$$$reportNull$$$0(11);
        }
        JSCompositeTypeBaseImpl jSCompositeTypeBaseImpl = this.createType(this.getTypes(), source);
        if (jSCompositeTypeBaseImpl == null) {
            JSCompositeTypeBaseImpl.$$$reportNull$$$0(12);
        }
        return jSCompositeTypeBaseImpl;
    }

    @Nullable
    protected JSType getSimpleCompositeTypeResult() {
        List<JSType> types = this.getTypes();
        if (types.size() == 1) {
            return (JSType)ContainerUtil.getFirstItem(types, null);
        }
        if (types.isEmpty()) {
            return JSAnyType.get(this.getSource().getSourceElement(), this.getSource().isStrict());
        }
        return null;
    }

    @NotNull
    protected Collection<JSRecordType> getNestedTypesAsRecordType() {
        List list = ContainerUtil.map(this.getTypes(), JSType::asRecordType);
        if (list == null) {
            JSCompositeTypeBaseImpl.$$$reportNull$$$0(13);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: 
            case 7: 
            case 9: 
            case 10: 
            case 12: 
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: 
            case 7: 
            case 9: 
            case 10: 
            case 12: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stream";
                break;
            }
            case 1: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toFlatClass";
                break;
            }
            case 2: 
            case 4: 
            case 7: 
            case 9: 
            case 10: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/types/JSCompositeTypeBaseImpl";
                break;
            }
            case 3: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentType";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "childTransform";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/types/JSCompositeTypeBaseImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "flattenTypes";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeText";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypes";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "copyTypeHierarchy";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "copyWithNewSource";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getNestedTypesAsRecordType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "flattenTypes";
                break;
            }
            case 2: 
            case 4: 
            case 7: 
            case 9: 
            case 10: 
            case 12: 
            case 13: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "shouldWrapNestedType";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isEquivalentToImpl";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "copyTypeHierarchy";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "copyWithNewSource";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "lambda$flattenTypes$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: 
            case 7: 
            case 9: 
            case 10: 
            case 12: 
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

