/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.types;

import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSTypeSourceFactory {
    @NotNull
    public static JSTypeSource createTypeSource(@NotNull PsiElement scope) {
        if (scope == null) {
            JSTypeSourceFactory.$$$reportNull$$$0(0);
        }
        JSTypeSource jSTypeSource = JSTypeSourceFactory.createTypeSource(scope, false);
        if (jSTypeSource == null) {
            JSTypeSourceFactory.$$$reportNull$$$0(1);
        }
        return jSTypeSource;
    }

    @NotNull
    public static JSTypeSource createTypeSource(@Nullable PsiElement scope, boolean isStrict) {
        JSTypeSource jSTypeSource = JSTypeSourceFactory.createTypeSource(scope, isStrict, isStrict);
        if (jSTypeSource == null) {
            JSTypeSourceFactory.$$$reportNull$$$0(2);
        }
        return jSTypeSource;
    }

    @NotNull
    public static JSTypeSource createTypeSource(@Nullable PsiElement scope, boolean isStrict, boolean isExplicitlyDeclared) {
        PsiFile file = scope != null ? scope.getContainingFile() : null;
        JSTypeSource jSTypeSource = new JSTypeSource(file, scope, JSTypeSourceFactory.sourceLanguage(scope), isStrict, isExplicitlyDeclared);
        if (jSTypeSource == null) {
            JSTypeSourceFactory.$$$reportNull$$$0(3);
        }
        return jSTypeSource;
    }

    public static JSTypeSource copyTypeSource(@NotNull JSTypeSource source, boolean isStrict) {
        if (source == null) {
            JSTypeSourceFactory.$$$reportNull$$$0(4);
        }
        return new JSTypeSource(source.getScope(), source.getSourceElement(), source.getLanguage(), isStrict);
    }

    public static JSTypeSource copyTypeSource(@NotNull JSTypeSource source, @NotNull PsiElement sourceElement) {
        if (source == null) {
            JSTypeSourceFactory.$$$reportNull$$$0(5);
        }
        if (sourceElement == null) {
            JSTypeSourceFactory.$$$reportNull$$$0(6);
        }
        return new JSTypeSource(source.getScope(), sourceElement, source.getLanguage(), source.isStrict());
    }

    @NotNull
    private static JSTypeSource.SourceLanguage sourceLanguage(@Nullable PsiElement scope) {
        DialectOptionHolder dialect = DialectDetector.dialectOfElement(scope);
        JSTypeSource.SourceLanguage sourceLanguage = dialect != null ? JSTypeSourceFactory.ofDialectOptionsHolder(dialect) : JSTypeSource.SourceLanguage.JS;
        if (sourceLanguage == null) {
            JSTypeSourceFactory.$$$reportNull$$$0(7);
        }
        return sourceLanguage;
    }

    @NotNull
    private static JSTypeSource.SourceLanguage ofDialectOptionsHolder(@NotNull DialectOptionHolder dialect) {
        if (dialect == null) {
            JSTypeSourceFactory.$$$reportNull$$$0(8);
        }
        switch (dialect) {
            case ECMA_4: {
                JSTypeSource.SourceLanguage sourceLanguage = JSTypeSource.SourceLanguage.AS;
                if (sourceLanguage == null) {
                    JSTypeSourceFactory.$$$reportNull$$$0(9);
                }
                return sourceLanguage;
            }
            case TS: 
            case TSX: {
                JSTypeSource.SourceLanguage sourceLanguage = JSTypeSource.SourceLanguage.TS;
                if (sourceLanguage == null) {
                    JSTypeSourceFactory.$$$reportNull$$$0(10);
                }
                return sourceLanguage;
            }
        }
        JSTypeSource.SourceLanguage sourceLanguage = JSTypeSource.SourceLanguage.JS;
        if (sourceLanguage == null) {
            JSTypeSourceFactory.$$$reportNull$$$0(11);
        }
        return sourceLanguage;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 7: 
            case 9: 
            case 10: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 7: 
            case 9: 
            case 10: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 7: 
            case 9: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/types/JSTypeSourceFactory";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceElement";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dialect";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/types/JSTypeSourceFactory";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createTypeSource";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "sourceLanguage";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "ofDialectOptionsHolder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createTypeSource";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 7: 
            case 9: 
            case 10: 
            case 11: {
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "copyTypeSource";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "ofDialectOptionsHolder";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 7: 
            case 9: 
            case 10: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

