/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.refactoring.introduce;

import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSInheritedLanguagesHelper;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.refactoring.introduce.BaseIntroduceSettings;
import com.intellij.lang.javascript.refactoring.introduce.BasicIntroducedEntityInfoProvider;
import com.intellij.lang.javascript.refactoring.introduce.JSBaseIntroduceDialog;
import com.intellij.lang.javascript.refactoring.introduce.JSBaseIntroduceHandler;
import com.intellij.lang.javascript.refactoring.util.JSRefactoringUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.introduce.inplace.AbstractInplaceIntroducer;
import com.intellij.util.containers.ContainerUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class JSBaseInplaceIntroducer<S extends BaseIntroduceSettings>
extends AbstractInplaceIntroducer<JSVariable, JSExpression> {
    protected final JSBaseIntroduceHandler<? extends JSElement, S, ? extends JSBaseIntroduceDialog> myIntroduceHandler;
    protected JSBaseIntroduceHandler.BaseIntroduceContext<S> myContext;
    protected final S myInitialSettings;
    private RangeMarker myVarMarker;
    private PsiFile myVarFile;

    public JSBaseInplaceIntroducer(Project project, Editor editor, JSExpression expr, JSExpression[] occurrences, FileType languageFileType, JSBaseIntroduceHandler<? extends JSElement, S, ? extends JSBaseIntroduceDialog> introduceHandler, JSBaseIntroduceHandler.BaseIntroduceContext<S> introduceContext) {
        super(project, editor, (PsiElement)expr, null, (PsiElement[])occurrences, RefactoringBundle.message((String)"introduce.variable.title"), languageFileType);
        this.myIntroduceHandler = introduceHandler;
        this.myContext = introduceContext;
        this.myInitialSettings = this.myContext.settings;
    }

    protected String getActionName() {
        return this.myTitle;
    }

    @NotNull
    protected String[] suggestNames(boolean replaceAll, @Nullable JSVariable variable) {
        String[] stringArray = new BasicIntroducedEntityInfoProvider((JSExpression)this.myExpr, (JSExpression[])this.myOccurrences, this.myScope).suggestCandidateNames();
        if (stringArray == null) {
            JSBaseInplaceIntroducer.$$$reportNull$$$0(0);
        }
        return stringArray;
    }

    @Nullable
    protected JSVariable createFieldToStartTemplateOn(boolean replaceAll, @NotNull String[] names) {
        JSBaseIntroduceHandler.IntroduceInfo info;
        if (names == null) {
            JSBaseInplaceIntroducer.$$$reportNull$$$0(1);
        }
        if (!((JSExpression)this.myContext.expressionDescriptor.first).isValid()) {
            this.fixContext();
        }
        if ((info = (JSBaseIntroduceHandler.IntroduceInfo)WriteAction.compute(() -> this.myIntroduceHandler.doRefactoring(this.myProject, this.myEditor, this.myContext, false))) == null || info.createdVariable == null) {
            return null;
        }
        if (info.expression != null) {
            this.myExpr = info.expression;
            this.myExprMarker = this.createMarker((PsiElement)info.expression);
        }
        this.myVarMarker = this.myEditor.getDocument().createRangeMarker(info.createdVariable.getTextRange());
        this.myVarFile = info.createdVariable.getContainingFile();
        this.myOccurrences = (PsiElement[])ContainerUtil.toArray(info.occurrences, (Object[])JSExpression.EMPTY_ARRAY);
        this.setOccurrenceMarkers(ContainerUtil.map((Object[])this.myOccurrences, arg_0 -> ((JSBaseInplaceIntroducer)this).createMarker(arg_0)));
        return info.createdVariable;
    }

    protected abstract S getInplaceIntroduceSettings(String var1);

    protected void performCleanup() {
        JSVariable variable = this.getVariable();
        if (variable != null) {
            super.restoreState((PsiNameIdentifierOwner)variable);
        }
    }

    protected void performIntroduce() {
        Runnable runnable = () -> this.myIntroduceHandler.performIntroduce(this.myContext);
        ApplicationManager.getApplication().runWriteAction(runnable);
    }

    private void fixContext() {
        LOG.assertTrue(((JSExpression)this.myExpr).isValid());
        this.myContext = new JSBaseIntroduceHandler.BaseIntroduceContext<S>((Pair<JSExpression, TextRange>)Pair.create((Object)this.myExpr, (Object)this.myContext.expressionDescriptor.second), JSBaseInplaceIntroducer.ensureExpressionInArray((JSExpression[])this.getOccurrences(), (JSExpression)this.myExpr), this.myContext.scope, this.getInplaceIntroduceSettings(this.getInputName()));
    }

    private static JSExpression[] ensureExpressionInArray(JSExpression[] array, JSExpression element) {
        for (JSExpression o : array) {
            if (element != o) continue;
            return array;
        }
        JSExpression[] newArray = new JSExpression[array.length + 1];
        newArray[0] = element;
        System.arraycopy(array, 0, newArray, 1, array.length);
        return newArray;
    }

    protected PsiElement checkLocalScope() {
        PsiElement element = super.checkLocalScope();
        return element == null || element instanceof PsiDirectory ? this.myElementToRename.getContainingFile() : element;
    }

    protected SearchScope getReferencesSearchScope(VirtualFile file) {
        return JSRefactoringUtil.getElementSearchScope((PsiElement)this.myElementToRename);
    }

    public boolean isReplaceAllOccurrences() {
        return this.myInitialSettings.isReplaceAllOccurrences();
    }

    public void setReplaceAllOccurrences(boolean allOccurrences) {
    }

    protected void saveSettings(@NotNull JSVariable variable) {
        if (variable == null) {
            JSBaseInplaceIntroducer.$$$reportNull$$$0(2);
        }
    }

    protected JSVariable getVariable() {
        JSVariable variable;
        if (this.myVarMarker == null) {
            return null;
        }
        if (!this.myVarFile.isValid()) {
            return null;
        }
        PsiElement element = this.myVarFile.getContainingFile().findElementAt(this.myVarMarker.getStartOffset());
        if (element instanceof PsiWhiteSpace) {
            element = PsiTreeUtil.skipWhitespacesForward((PsiElement)element);
        }
        if ((variable = (JSVariable)PsiTreeUtil.getParentOfType((PsiElement)element, JSVariable.class, (boolean)false)) != null) {
            return variable;
        }
        element = PsiTreeUtil.skipWhitespacesBackward((PsiElement)element);
        return (JSVariable)PsiTreeUtil.getParentOfType((PsiElement)element, JSVariable.class, (boolean)false);
    }

    public JSExpression restoreExpression(@NotNull PsiFile containingFile, @NotNull JSVariable variable, @NotNull RangeMarker marker, String exprText) {
        if (containingFile == null) {
            JSBaseInplaceIntroducer.$$$reportNull$$$0(3);
        }
        if (variable == null) {
            JSBaseInplaceIntroducer.$$$reportNull$$$0(4);
        }
        if (marker == null) {
            JSBaseInplaceIntroducer.$$$reportNull$$$0(5);
        }
        if (exprText == null) {
            return null;
        }
        PsiElement elementAt = containingFile.findElementAt(marker.getStartOffset());
        if (elementAt == null) {
            return null;
        }
        PsiElement parent = elementAt.getParent();
        JSExpression candidateExpression = null;
        if (parent instanceof JSVarStatement) {
            JSVariable[] variables = ((JSVarStatement)parent).getVariables();
            if (variables.length == 1) {
                candidateExpression = variables[0].getInitializer();
            }
        } else if (parent instanceof JSExpression) {
            candidateExpression = (JSExpression)parent;
        }
        JSReferenceExpression result = null;
        if (candidateExpression instanceof JSReferenceExpression) {
            JSReferenceExpression refExpr = (JSReferenceExpression)candidateExpression;
            String referenceName = refExpr.getReferenceName();
            if (Comparing.strEqual((String)exprText, (String)referenceName)) {
                result = refExpr;
            } else if (refExpr.resolve() == variable || Comparing.strEqual((String)variable.getName(), (String)referenceName)) {
                JSExpression newExpression = (JSExpression)JSInheritedLanguagesHelper.createExpressionFromText(exprText, (PsiElement)variable, true);
                result = refExpr.replace(newExpression);
            }
        }
        LOG.assertTrue(result == null || result.isValid());
        return result;
    }

    protected void restoreState(@NotNull JSVariable psiField) {
        if (psiField == null) {
            JSBaseInplaceIntroducer.$$$reportNull$$$0(6);
        }
    }

    protected boolean ensureValid() {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/refactoring/introduce/JSBaseInplaceIntroducer";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "names";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variable";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "containingFile";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "marker";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiField";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "suggestNames";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/refactoring/introduce/JSBaseInplaceIntroducer";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "createFieldToStartTemplateOn";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "saveSettings";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "restoreExpression";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "restoreState";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

