/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.refactoring.memberPullUp;

import com.intellij.lang.ecmascript6.refactoring.ES6ReferenceExpressionsInfo;
import com.intellij.lang.ecmascript6.resolve.ES6PsiUtil;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSElementBase;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSPsiElementBase;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptFunction;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.resolve.JSInheritanceUtil;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.refactoring.JSVisibilityUtil;
import com.intellij.lang.javascript.refactoring.util.JSClassMemberReferencesVisitor;
import com.intellij.lang.javascript.refactoring.util.JSInterfaceContainmentVerifier;
import com.intellij.lang.javascript.refactoring.util.JSMemberInfo;
import com.intellij.lang.javascript.refactoring.util.JSRefactoringConflictsUtil;
import com.intellij.lang.javascript.refactoring.util.JSRefactoringUtil;
import com.intellij.lang.javascript.ui.JSFormatUtil;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.ElementDescriptionLocation;
import com.intellij.psi.ElementDescriptionUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.refactoring.util.RefactoringUIUtil;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewLongNameLocation;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class JSPullUpConflictsUtil {
    public static MultiMap<PsiElement, String> checkConflicts(@NotNull JSMemberInfo[] infos, @NotNull JSClass subclass, @NotNull JSClass superClass, @NotNull JSInterfaceContainmentVerifier interfaceContainmentVerifier, @NotNull JSVisibilityUtil.Options options) {
        if (infos == null) {
            JSPullUpConflictsUtil.$$$reportNull$$$0(0);
        }
        if (subclass == null) {
            JSPullUpConflictsUtil.$$$reportNull$$$0(1);
        }
        if (superClass == null) {
            JSPullUpConflictsUtil.$$$reportNull$$$0(2);
        }
        if (interfaceContainmentVerifier == null) {
            JSPullUpConflictsUtil.$$$reportNull$$$0(3);
        }
        if (options == null) {
            JSPullUpConflictsUtil.$$$reportNull$$$0(4);
        }
        MultiMap conflicts = new MultiMap();
        DialectOptionHolder dialect = DialectDetector.dialectOfElement((PsiElement)subclass);
        JSRefactoringConflictsUtil.checkIncomingReferencesAccessibility(JSRefactoringUtil.getUsages(JSMemberInfo.getStatics(infos), superClass), superClass, "escalate", (MultiMap<PsiElement, String>)conflicts, options);
        for (JSMemberInfo info2 : infos) {
            JSRefactoringConflictsUtil.checkMemberExist((JSAttributeListOwner)info2.getMember(), superClass, (MultiMap<PsiElement, String>)conflicts);
        }
        if (!superClass.isInterface() && !JSPsiImplUtils.hasModifier((JSAttributeListOwner)superClass, JSAttributeList.ModifierType.ABSTRACT) && ContainerUtil.or((Object[])infos, info -> info.isToAbstract())) {
            String text = JSBundle.message((String)"js.pull.up.will.be.made.abstract", (Object[])new Object[]{RefactoringUIUtil.getDescription((PsiElement)superClass, (boolean)false)});
            conflicts.putValue((Object)superClass, (Object)text);
        }
        if (dialect != null && dialect.isECMA4 && superClass.isInterface()) {
            JSPullUpConflictsUtil.checkNoFieldsInInterface(infos, (MultiMap<PsiElement, String>)conflicts);
        }
        if (dialect != null && dialect.isTypeScript && !superClass.isInterface()) {
            JSPullUpConflictsUtil.checkNoOverloadsWithoutImplementation(infos, (MultiMap<PsiElement, String>)conflicts);
        }
        if (dialect != null && (dialect.isTypeScript || dialect.isECMA6) && superClass.getContainingFile() != subclass.getContainingFile()) {
            JSPullUpConflictsUtil.checkUsagesOfNonExported(infos, superClass, interfaceContainmentVerifier, (MultiMap<PsiElement, String>)conflicts);
        }
        HashSet<JSAttributeListOwner> membersToMove = new HashSet<JSAttributeListOwner>();
        HashSet<JSFunction> methodsToAbstract = new HashSet<JSFunction>();
        for (JSMemberInfo info3 : infos) {
            JSAttributeListOwner member = (JSAttributeListOwner)info3.getMember();
            if (member instanceof JSFunction && superClass.isInterface()) {
                methodsToAbstract.add((JSFunction)member);
                continue;
            }
            membersToMove.add(member);
        }
        for (JSAttributeListOwner member : membersToMove) {
            if (member instanceof JSClass) {
                if (JSVisibilityUtil.isAccessible((PsiElement)member, (JSAttributeList)null, null, (PsiElement)superClass, JSVisibilityUtil.DEFAULT_OPTIONS)) continue;
                String message = RefactoringBundle.message((String)"0.with.1.visibility.is.not.accessible.from.2", (Object[])new Object[]{ElementDescriptionUtil.getElementDescription((PsiElement)member, (ElementDescriptionLocation)UsageViewLongNameLocation.INSTANCE), JSFormatUtil.formatVisibility(member.getAttributeList().getAccessType()), ElementDescriptionUtil.getElementDescription((PsiElement)superClass, (ElementDescriptionLocation)UsageViewLongNameLocation.INSTANCE)});
                message = StringUtil.capitalize((String)message);
                conflicts.putValue((Object)subclass, (Object)message);
                continue;
            }
            NonAccessibleUsagesOfSubClassMembers visitor = new NonAccessibleUsagesOfSubClassMembers((PsiElement)member, membersToMove, methodsToAbstract, subclass, superClass, (MultiMap<PsiElement, String>)conflicts, interfaceContainmentVerifier);
            member.accept((PsiElementVisitor)visitor);
            JSRefactoringConflictsUtil.checkOutgoingReferencesAccessibility((PsiElement)member, membersToMove, (PsiElement)superClass, true, (MultiMap<PsiElement, String>)conflicts, (Condition<PsiElement>)((Condition)element -> {
                if (superClass == null) {
                    JSPullUpConflictsUtil.$$$reportNull$$$0(15);
                }
                return !JSInheritanceUtil.isMemberOfSubclass(superClass, (JSElement)element, true);
            }), options);
        }
        for (JSFunction member : methodsToAbstract) {
            JSRefactoringConflictsUtil.checkOutgoingReferencesInSignatureAccessibility(member, (PsiElement)superClass, true, (MultiMap<PsiElement, String>)conflicts, options);
        }
        ArrayList<Object> checkModuleConflictsFor = new ArrayList<Object>(membersToMove);
        for (JSFunction method : methodsToAbstract) {
            checkModuleConflictsFor.add(method.getParameterList());
            PsiElement element2 = method.getReturnTypeElement();
            if (element2 == null) continue;
            checkModuleConflictsFor.add(element2);
        }
        if (dialect != null && dialect.isECMA4) {
            JSRefactoringConflictsUtil.analyzeModuleConflicts(subclass.getProject(), checkModuleConflictsFor, UsageInfo.EMPTY_ARRAY, (PsiElement)superClass, (MultiMap<PsiElement, String>)conflicts);
        }
        return conflicts;
    }

    private static void checkNoOverloadsWithoutImplementation(@NotNull JSMemberInfo[] infos, @NotNull MultiMap<PsiElement, String> conflicts) {
        if (infos == null) {
            JSPullUpConflictsUtil.$$$reportNull$$$0(5);
        }
        if (conflicts == null) {
            JSPullUpConflictsUtil.$$$reportNull$$$0(6);
        }
        for (JSMemberInfo info : infos) {
            TypeScriptFunction implementation;
            TypeScriptFunction typeScriptFunction;
            TypeScriptFunction typeScriptFunction2 = typeScriptFunction = info.getMember() instanceof TypeScriptFunction ? (TypeScriptFunction)info.getMember() : null;
            if (typeScriptFunction == null || !typeScriptFunction.isOverloadDeclaration() || ContainerUtil.find((Object[])infos, arg_0 -> JSPullUpConflictsUtil.lambda$checkNoOverloadsWithoutImplementation$3(implementation = (TypeScriptFunction)ContainerUtil.find((Iterable)typeScriptFunction.getOverloadDeclarations(), t -> t.isOverloadImplementation()), arg_0)) != null) continue;
            String description = RefactoringUIUtil.getDescription((PsiElement)typeScriptFunction, (boolean)false);
            String message = JSBundle.message((String)"es6.extract.super.overload.declaration.without.implementation.conflict", (Object[])new Object[]{description});
            conflicts.putValue((Object)typeScriptFunction, (Object)message);
        }
    }

    private static void checkUsagesOfNonExported(@NotNull JSMemberInfo[] infos, @NotNull JSClass superClass, @NotNull JSInterfaceContainmentVerifier verifier, @NotNull MultiMap<PsiElement, String> conflicts) {
        if (infos == null) {
            JSPullUpConflictsUtil.$$$reportNull$$$0(7);
        }
        if (superClass == null) {
            JSPullUpConflictsUtil.$$$reportNull$$$0(8);
        }
        if (verifier == null) {
            JSPullUpConflictsUtil.$$$reportNull$$$0(9);
        }
        if (conflicts == null) {
            JSPullUpConflictsUtil.$$$reportNull$$$0(10);
        }
        for (JSMemberInfo info : infos) {
            ES6ReferenceExpressionsInfo usageInfo;
            List<String> validations;
            JSPsiElementBase element = (JSPsiElementBase)ObjectUtils.tryCast((Object)info.getMember(), JSPsiElementBase.class);
            if (element == null || (validations = ES6ReferenceExpressionsInfo.getLocalReferencedElementValidations(usageInfo = JSPullUpConflictsUtil.buildInfo(superClass, element, info.isToAbstract()), element, (Condition<PsiElement>)((Condition)t -> false))).isEmpty()) continue;
            conflicts.putValues((Object)element, validations);
        }
    }

    @NotNull
    private static ES6ReferenceExpressionsInfo buildInfo(@NotNull JSClass destinationClass, @NotNull JSPsiElementBase element, boolean isAbstract) {
        PsiElement sourceModule;
        if (destinationClass == null) {
            JSPullUpConflictsUtil.$$$reportNull$$$0(11);
        }
        if (element == null) {
            JSPullUpConflictsUtil.$$$reportNull$$$0(12);
        }
        if ((sourceModule = ES6PsiUtil.findExternalModule((PsiElement)element)) == null || ES6PsiUtil.findExternalModule((PsiElement)destinationClass) == null) {
            ES6ReferenceExpressionsInfo eS6ReferenceExpressionsInfo = ES6ReferenceExpressionsInfo.EMPTY;
            if (eS6ReferenceExpressionsInfo == null) {
                JSPullUpConflictsUtil.$$$reportNull$$$0(13);
            }
            return eS6ReferenceExpressionsInfo;
        }
        JSPsiElementBase toCheck = null;
        if (destinationClass.isInterface()) {
            toCheck = JSRefactoringUtil.tryBuildInterfaceSignature((JSElementBase)element);
        } else if (isAbstract && element instanceof JSFunction) {
            toCheck = JSRefactoringUtil.buildAbstractMethodSignature((JSFunction)element);
        }
        if (toCheck != null) {
            toCheck.getContainingFile().putUserData(JSResolveUtil.contextKey, (Object)element.getParent());
        } else {
            toCheck = element;
        }
        ES6ReferenceExpressionsInfo eS6ReferenceExpressionsInfo = ES6ReferenceExpressionsInfo.getInfo(toCheck, sourceModule);
        if (eS6ReferenceExpressionsInfo == null) {
            JSPullUpConflictsUtil.$$$reportNull$$$0(14);
        }
        return eS6ReferenceExpressionsInfo;
    }

    private static void checkNoFieldsInInterface(JSMemberInfo[] infos, MultiMap<PsiElement, String> conflicts) {
        for (JSMemberInfo info : infos) {
            PsiElement member = info.getMember();
            if (!(member instanceof JSVariable)) continue;
            String message = JSBundle.message((String)"0.is.not.allowed.in.interface", (Object[])new Object[]{RefactoringUIUtil.getDescription((PsiElement)member, (boolean)false)});
            conflicts.putValue((Object)member, (Object)CommonRefactoringUtil.capitalize((String)message));
        }
    }

    private static /* synthetic */ boolean lambda$checkNoOverloadsWithoutImplementation$3(TypeScriptFunction implementation, JSMemberInfo t) {
        return t.getMember() == implementation;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 13: 
            case 14: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 13: 
            case 14: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "infos";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "subclass";
                break;
            }
            case 2: 
            case 8: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "superClass";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interfaceContainmentVerifier";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
            case 6: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "conflicts";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "verifier";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "destinationClass";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/refactoring/memberPullUp/JSPullUpConflictsUtil";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/refactoring/memberPullUp/JSPullUpConflictsUtil";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "buildInfo";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "checkConflicts";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "checkNoOverloadsWithoutImplementation";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "checkUsagesOfNonExported";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "buildInfo";
                break;
            }
            case 13: 
            case 14: {
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "lambda$checkConflicts$1";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 13: 
            case 14: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class NonAccessibleUsagesOfSubClassMembers
    extends JSClassMemberReferencesVisitor {
        private final PsiElement myScope;
        private final Set<JSAttributeListOwner> myMovedMembers;
        private final Set<JSFunction> myAbstractMethods;
        private final JSClass mySuperClass;
        private final MultiMap<PsiElement, String> myConflictsList;
        private final JSInterfaceContainmentVerifier myInterfaceContainmentVerifier;

        NonAccessibleUsagesOfSubClassMembers(PsiElement scope, Set<JSAttributeListOwner> movedMembers, Set<JSFunction> abstractMethods, JSClass subclass, JSClass superClass, MultiMap<PsiElement, String> conflictsList, JSInterfaceContainmentVerifier interfaceContainmentVerifier) {
            super(subclass);
            this.myScope = scope;
            this.myMovedMembers = movedMembers;
            this.myAbstractMethods = abstractMethods;
            this.mySuperClass = superClass;
            this.myConflictsList = conflictsList;
            this.myInterfaceContainmentVerifier = interfaceContainmentVerifier;
        }

        @Override
        protected void visitMemberReference(JSAttributeListOwner classMember, JSReferenceExpression classMemberReference) {
            String message = null;
            if (JSPsiImplUtils.hasModifier(classMember, JSAttributeList.ModifierType.STATIC) && !this.willBeMoved((PsiElement)classMember)) {
                boolean isAccessible;
                if (this.mySuperClass != null) {
                    isAccessible = JSVisibilityUtil.isAccessible((PsiElement)classMember, (JSAttributeList)null, null, (PsiElement)this.mySuperClass, JSVisibilityUtil.DEFAULT_OPTIONS);
                } else {
                    boolean bl = isAccessible = classMember.getAttributeList() != null && classMember.getAttributeList().getAccessType() == JSAttributeList.AccessType.PUBLIC;
                }
                if (!isAccessible) {
                    message = CommonRefactoringUtil.capitalize((String)RefactoringBundle.message((String)"0.uses.1.which.is.not.accessible.from.the.superclass", (Object[])new Object[]{RefactoringUIUtil.getDescription((PsiElement)this.myScope, (boolean)false), RefactoringUIUtil.getDescription((PsiElement)classMember, (boolean)true)}));
                }
            } else if (!(this.myAbstractMethods.contains(classMember) || this.willBeMoved((PsiElement)classMember) || this.existsInSuperClass((JSElement)classMember))) {
                message = CommonRefactoringUtil.capitalize((String)RefactoringBundle.message((String)"0.uses.1.which.is.not.moved.to.the.superclass", (Object[])new Object[]{RefactoringUIUtil.getDescription((PsiElement)this.myScope, (boolean)false), RefactoringUIUtil.getDescription((PsiElement)classMember, (boolean)true)}));
            }
            if (message != null) {
                this.myConflictsList.putValue((Object)classMember, message);
            }
        }

        private boolean willBeMoved(PsiElement element) {
            for (PsiElement parent = element; parent != null; parent = parent.getParent()) {
                if (!this.myMovedMembers.contains(parent)) continue;
                return true;
            }
            return false;
        }

        private boolean existsInSuperClass(JSElement classMember) {
            if (!(classMember instanceof JSFunction)) {
                return false;
            }
            JSFunction method = (JSFunction)classMember;
            if (this.myInterfaceContainmentVerifier.checkedInterfacesContain(method)) {
                return true;
            }
            if (this.mySuperClass == null) {
                return false;
            }
            return this.mySuperClass.findFunctionByName(method.getName()) != null;
        }
    }
}

