/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.ui;

import com.intellij.icons.AllIcons;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.dialects.JSLanguageFeature;
import com.intellij.lang.javascript.psi.JSField;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSParameterListElement;
import com.intellij.lang.javascript.psi.JSPsiElementBase;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeDeclarationOwner;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptCallSignature;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptIndexSignature;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptPropertySignature;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeMember;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.resolve.ActionScriptResolveUtil;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.lang.javascript.refactoring.JSVisibilityUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiFormatUtilBase;
import com.intellij.util.Function;
import com.intellij.util.ObjectUtils;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSFormatUtil
extends PsiFormatUtilBase {
    @NotNull
    public static String formatClass(@NotNull JSClass clazz, int options) {
        if (clazz == null) {
            JSFormatUtil.$$$reportNull$$$0(0);
        }
        if (JSFormatUtil.testOption((int)options, (int)2048)) {
            String qualifiedName = clazz.getQualifiedName();
            String string = qualifiedName != null ? qualifiedName : JSBundle.message((String)"class.name.invalid", (Object[])new Object[0]);
            if (string == null) {
                JSFormatUtil.$$$reportNull$$$0(1);
            }
            return string;
        }
        if (JSFormatUtil.testOption((int)options, (int)1)) {
            String name = clazz.getName();
            String string = name != null ? name : JSBundle.message((String)"class.name.invalid", (Object[])new Object[0]);
            if (string == null) {
                JSFormatUtil.$$$reportNull$$$0(2);
            }
            return string;
        }
        if ("" == null) {
            JSFormatUtil.$$$reportNull$$$0(3);
        }
        return "";
    }

    @NotNull
    public static String formatField(@NotNull JSTypeDeclarationOwner field, int options) {
        if (field == null) {
            JSFormatUtil.$$$reportNull$$$0(4);
        }
        String string = JSFormatUtil.formatField(field, options, null);
        if (string == null) {
            JSFormatUtil.$$$reportNull$$$0(5);
        }
        return string;
    }

    @NotNull
    public static String formatField(@NotNull JSTypeDeclarationOwner field, int options, @Nullable JSClass parentClassOverrride) {
        String returnType;
        if (field == null) {
            JSFormatUtil.$$$reportNull$$$0(6);
        }
        StringBuilder text = new StringBuilder();
        if (JSFormatUtil.testOption((int)options, (int)2) && !JSFormatUtil.testOption((int)options, (int)4) && (returnType = JSFormatUtil.getType(field, options)) != null) {
            text.append(returnType);
        }
        if (JSFormatUtil.testOption((int)options, (int)4096)) {
            String s;
            JSClass clazz;
            JSClass jSClass = clazz = parentClassOverrride != null ? parentClassOverrride : JSResolveUtil.getClassOfContext((PsiElement)field);
            if (clazz != null && (s = JSFormatUtil.formatClass(clazz, options)).length() > 0) {
                JSFormatUtil.appendSpaceIfNeeded((StringBuilder)text);
                text.append(s).append('.');
            }
        }
        if (JSFormatUtil.testOption((int)options, (int)1)) {
            if (!JSFormatUtil.testOption((int)options, (int)4096)) {
                JSFormatUtil.appendSpaceIfNeeded((StringBuilder)text);
            }
            text.append(field.getName());
        }
        if (JSFormatUtil.testAll((int)options, (int[])new int[]{2, 4}) && (returnType = JSFormatUtil.getType(field, options)) != null) {
            text.append(':');
            text.append(returnType);
        }
        String string = text.toString();
        if (string == null) {
            JSFormatUtil.$$$reportNull$$$0(7);
        }
        return string;
    }

    public static String formatMember(@NotNull JSPsiElementBase member, int options) {
        if (member == null) {
            JSFormatUtil.$$$reportNull$$$0(8);
        }
        if (member instanceof JSFunction) {
            return JSFormatUtil.formatMethod((JSFunction)member, options, 0);
        }
        if (member instanceof JSField) {
            return JSFormatUtil.formatField((JSTypeDeclarationOwner)((JSField)member), options);
        }
        return member.getName();
    }

    @NotNull
    public static String formatMethod(@NotNull JSFunction method, int options, int parametersOptions) {
        if (method == null) {
            JSFormatUtil.$$$reportNull$$$0(9);
        }
        String string = JSFormatUtil.formatMethod(method, options, parametersOptions, 7, null);
        if (string == null) {
            JSFormatUtil.$$$reportNull$$$0(10);
        }
        return string;
    }

    @NotNull
    public static String formatTypeMember(@NotNull TypeScriptTypeMember member, int options, int parameterOptions) {
        if (member == null) {
            JSFormatUtil.$$$reportNull$$$0(11);
        }
        if (member instanceof TypeScriptCallSignature) {
            String string = JSFormatUtil.formatMethod((JSFunction)member, options, parameterOptions, 7, null, "");
            if (string == null) {
                JSFormatUtil.$$$reportNull$$$0(12);
            }
            return string;
        }
        if (member instanceof TypeScriptIndexSignature) {
            String string = JSFormatUtil.formatIndexSignature((TypeScriptIndexSignature)member, options, parameterOptions);
            if (string == null) {
                JSFormatUtil.$$$reportNull$$$0(13);
            }
            return string;
        }
        if (member instanceof JSFunction) {
            String string = JSFormatUtil.formatMethod((JSFunction)member, options, parameterOptions);
            if (string == null) {
                JSFormatUtil.$$$reportNull$$$0(14);
            }
            return string;
        }
        if (member instanceof TypeScriptPropertySignature) {
            String string = JSFormatUtil.formatField((JSTypeDeclarationOwner)member, options);
            if (string == null) {
                JSFormatUtil.$$$reportNull$$$0(15);
            }
            return string;
        }
        String string = (String)ObjectUtils.coalesce((Object)member.getName(), (Object)"");
        if (string == null) {
            JSFormatUtil.$$$reportNull$$$0(16);
        }
        return string;
    }

    @NotNull
    public static String formatMethod(@NotNull JSFunction method, int options, int parametersOptions, @Nullable JSClass parentClassOverrride) {
        if (method == null) {
            JSFormatUtil.$$$reportNull$$$0(17);
        }
        String string = JSFormatUtil.formatMethod(method, options, parametersOptions, 7, parentClassOverrride);
        if (string == null) {
            JSFormatUtil.$$$reportNull$$$0(18);
        }
        return string;
    }

    @NotNull
    public static String formatMethod(@NotNull JSFunction method, int options, int parametersOptions, int maxParameters, @Nullable JSClass parentClassOverrride) {
        if (method == null) {
            JSFormatUtil.$$$reportNull$$$0(19);
        }
        String string = JSFormatUtil.formatMethod(method, options, parametersOptions, maxParameters, parentClassOverrride, "<anonymous>");
        if (string == null) {
            JSFormatUtil.$$$reportNull$$$0(20);
        }
        return string;
    }

    @NotNull
    public static String formatMethod(@NotNull JSFunction method, int options, int parametersOptions, int maxParameters, @Nullable JSClass parentClassOverrride, String namePlaceholder) {
        String returnType;
        if (method == null) {
            JSFormatUtil.$$$reportNull$$$0(21);
        }
        StringBuilder text = new StringBuilder();
        if (JSFormatUtil.testOption((int)options, (int)2) && !JSFormatUtil.testOption((int)options, (int)4) && (returnType = JSFormatUtil.getReturnType(method, options)) != null) {
            JSFormatUtil.appendSpaceIfNeeded((StringBuilder)text);
            text.append(returnType);
        }
        if (JSFormatUtil.testOption((int)options, (int)4096)) {
            String s;
            JSClass clazz;
            JSClass jSClass = clazz = parentClassOverrride != null ? parentClassOverrride : JSResolveUtil.getClassOfContext((PsiElement)method);
            if (clazz != null && (s = JSFormatUtil.formatClass(clazz, options)).length() > 0) {
                JSFormatUtil.appendSpaceIfNeeded((StringBuilder)text);
                text.append(s).append('.');
            }
        }
        if (JSFormatUtil.testOption((int)options, (int)1)) {
            if (!JSFormatUtil.testOption((int)options, (int)4096)) {
                JSFormatUtil.appendSpaceIfNeeded((StringBuilder)text);
            }
            text.append((String)ObjectUtils.coalesce((Object)method.getName(), (Object)namePlaceholder));
        }
        if (JSFormatUtil.testOption((int)options, (int)256) && method.getKind() != JSFunction.FunctionKind.GETTER && method.getKind() != JSFunction.FunctionKind.SETTER) {
            text.append('(');
            if (method.getParameterList() != null) {
                boolean first = true;
                JSParameterListElement[] params = method.getParameters();
                for (int i = 0; i < Math.min(params.length, maxParameters); ++i) {
                    if (!first) {
                        text.append(", ");
                    }
                    first = false;
                    text.append(JSFormatUtil.formatParameter(params[i], parametersOptions));
                }
            }
            text.append(')');
        }
        if (JSFormatUtil.testAll((int)options, (int[])new int[]{2, 4}) && (returnType = JSFormatUtil.getReturnType(method, options)) != null) {
            text.append(':');
            text.append(returnType);
        }
        String string = text.toString();
        if (string == null) {
            JSFormatUtil.$$$reportNull$$$0(22);
        }
        return string;
    }

    private static String formatIndexSignature(@NotNull TypeScriptIndexSignature member, int options, int parameterOptions) {
        String returnType;
        String s;
        JSClass clazz;
        if (member == null) {
            JSFormatUtil.$$$reportNull$$$0(23);
        }
        StringBuilder text = new StringBuilder();
        if (JSFormatUtil.testOption((int)options, (int)4096) && (clazz = JSResolveUtil.getClassOfContext((PsiElement)member)) != null && (s = JSFormatUtil.formatClass(clazz, options)).length() > 0) {
            JSFormatUtil.appendSpaceIfNeeded((StringBuilder)text);
            text.append(s).append('.');
        }
        JSFormatUtil.appendSpaceIfNeeded((StringBuilder)text);
        text.append('[');
        if (JSFormatUtil.testOption((int)parameterOptions, (int)1)) {
            PsiElement parameterName = member.getParameterNameElement();
            if (parameterName != null) {
                text.append(parameterName.getText());
            }
            if (JSFormatUtil.testOption((int)options, (int)2)) {
                text.append(':');
                text.append(JSFormatUtil.formatType(member.getMemberParameterType(), (PsiElement)member, options));
            }
        }
        text.append(']');
        if (JSFormatUtil.testAll((int)options, (int[])new int[]{2}) && (returnType = JSFormatUtil.formatType(member.getMemberType(), (PsiElement)member, options)) != null) {
            text.append(':');
            text.append(returnType);
        }
        return text.toString();
    }

    private static String formatParameter(JSParameterListElement parameter, int options) {
        DialectOptionHolder optionHolder = DialectDetector.dialectOfElement((PsiElement)parameter);
        if (JSFormatUtil.testOption((int)options, (int)2) && (optionHolder == null || !optionHolder.hasFeature(JSLanguageFeature.TYPES))) {
            options &= 0xFFFFFFFD;
            options |= 1;
        }
        StringBuilder text = new StringBuilder();
        if (JSFormatUtil.testOption((int)options, (int)2) && !JSFormatUtil.testOption((int)options, (int)4)) {
            if (parameter.isRest() && DialectDetector.isActionScript((PsiElement)parameter)) {
                text.append("Array");
            } else {
                text.append(JSFormatUtil.formatType(parameter.getType(), (PsiElement)parameter, options));
            }
        }
        if (JSFormatUtil.testOption((int)options, (int)1)) {
            JSFormatUtil.appendSpaceIfNeeded((StringBuilder)text);
            text.append(parameter.getName());
        }
        if (JSFormatUtil.testAll((int)options, (int[])new int[]{2, 4})) {
            text.append(':');
            if (parameter.isRest() && DialectDetector.isActionScript((PsiElement)parameter)) {
                text.append("Array");
            } else {
                text.append(JSFormatUtil.formatType(parameter.getType(), (PsiElement)parameter, options));
            }
        }
        return text.toString();
    }

    @Nullable
    private static String getReturnType(@NotNull JSFunction method, int options) {
        if (method == null) {
            JSFormatUtil.$$$reportNull$$$0(24);
        }
        if (method.getKind() == JSFunction.FunctionKind.SETTER) {
            if (method.getParameterList() != null && method.getParameters().length > 0) {
                return JSFormatUtil.formatType(method.getParameters()[0].getType(), (PsiElement)method, options);
            }
            return null;
        }
        if (method.getKind() == JSFunction.FunctionKind.CONSTRUCTOR) {
            return null;
        }
        JSType returnType = method.getReturnType();
        return JSFormatUtil.formatType(returnType, (PsiElement)method, options);
    }

    @NotNull
    private static String getType(@NotNull JSTypeDeclarationOwner field, int options) {
        if (field == null) {
            JSFormatUtil.$$$reportNull$$$0(25);
        }
        String string = JSFormatUtil.formatType(field.getType(), (PsiElement)field, options);
        if (string == null) {
            JSFormatUtil.$$$reportNull$$$0(26);
        }
        return string;
    }

    @NotNull
    private static String formatType(@Nullable JSType type, @Nullable PsiElement context, int options) {
        DialectOptionHolder dialect = DialectDetector.dialectOfElement(context);
        if (type != null) {
            String typeName = type.getTypeText(dialect != null && dialect.isECMA4 ? JSType.TypeTextFormat.SIMPLE : JSType.TypeTextFormat.CODE);
            String string = JSFormatUtil.testOption((int)options, (int)8192) ? typeName : JSResolveUtil.getShortTypeName(typeName, true);
            if (string == null) {
                JSFormatUtil.$$$reportNull$$$0(27);
            }
            return string;
        }
        String string = dialect != null && dialect.isTypeScript ? "any" : "*";
        if (string == null) {
            JSFormatUtil.$$$reportNull$$$0(28);
        }
        return string;
    }

    @Nullable
    public static Icon getPropertyIcon(@NotNull JSFunction method, boolean getterAndSetterMerged) {
        boolean isStatic;
        if (method == null) {
            JSFormatUtil.$$$reportNull$$$0(29);
        }
        boolean bl = isStatic = method.getAttributeList() != null && method.getAttributeList().hasModifier(JSAttributeList.ModifierType.STATIC);
        if (method.getKind() == JSFunction.FunctionKind.GETTER) {
            if (getterAndSetterMerged && JSUtils.getMemberContainingClass((PsiElement)method).findFunctionByNameAndKind(method.getName(), JSFunction.FunctionKind.SETTER) != null) {
                return isStatic ? AllIcons.Nodes.PropertyReadWriteStatic : AllIcons.Nodes.PropertyReadWrite;
            }
            return isStatic ? AllIcons.Nodes.PropertyReadStatic : AllIcons.Nodes.PropertyRead;
        }
        if (method.getKind() == JSFunction.FunctionKind.SETTER) {
            return isStatic ? AllIcons.Nodes.PropertyWriteStatic : AllIcons.Nodes.PropertyWrite;
        }
        return null;
    }

    public static String formatVisibility(JSAttributeList.AccessType accessType, @Nullable PsiElement context) {
        String s = JSVisibilityUtil.accessTypeToKeyword(accessType, context != null ? DialectDetector.dialectOfElement(context) : null);
        if (StringUtil.isEmpty((String)s)) {
            return "";
        }
        return JSBundle.message((String)("javascript.visibility." + s), (Object[])new Object[0]);
    }

    public static String formatVisibility(JSAttributeList.AccessType accessType) {
        return JSFormatUtil.formatVisibility(accessType, null);
    }

    public static String formatVisibility(@NotNull PsiElement element) {
        if (element == null) {
            JSFormatUtil.$$$reportNull$$$0(30);
        }
        return JSFormatUtil.formatVisibility(((JSAttributeListOwner)element).getAttributeList().getAccessType(), element);
    }

    public static String getFunctionLongDescription(JSFunction jsFunction, boolean includeParent, boolean htmlEmphasize, @Nullable JSClass parentClassOverride) {
        boolean isMethod;
        int options = 257;
        boolean bl = isMethod = JSUtils.getMemberContainingClass((PsiElement)jsFunction) != null;
        if (includeParent && isMethod) {
            options |= 0x1000;
        }
        String name = JSFormatUtil.formatMethod(jsFunction, options, 2, parentClassOverride);
        if (htmlEmphasize) {
            name = StringUtil.htmlEmphasize((String)name);
        }
        if (isMethod) {
            if (jsFunction.getKind() == JSFunction.FunctionKind.GETTER || jsFunction.getKind() == JSFunction.FunctionKind.SETTER) {
                return JSBundle.message((String)"property.description", (Object[])new Object[]{name});
            }
            if (jsFunction.getKind() == JSFunction.FunctionKind.CONSTRUCTOR) {
                return JSBundle.message((String)"constructor.description", (Object[])new Object[]{name});
            }
            return JSBundle.message((String)"method.description", (Object[])new Object[]{name});
        }
        if (includeParent) {
            JSClass clazz;
            JSClass jSClass = clazz = parentClassOverride != null ? parentClassOverride : JSResolveUtil.getClassOfContext((PsiElement)jsFunction);
            if (clazz != null) {
                String className = JSFormatUtil.formatClass(clazz, 1);
                if (htmlEmphasize) {
                    className = StringUtil.htmlEmphasize((String)className);
                }
                return JSBundle.message((String)"function.in.class.description", (Object[])new Object[]{name, className});
            }
        }
        if (ActionScriptResolveUtil.isFileLocalSymbol((PsiElement)jsFunction)) {
            return JSBundle.message((String)"inner.function.description", (Object[])new Object[]{name});
        }
        return JSBundle.message((String)"function.description", (Object[])new Object[]{name});
    }

    public static String getVariableLongDescription(JSVariable jsVariable, boolean includeParent, boolean htmlEmphasize, @Nullable JSClass parentClassOverride) {
        boolean isField;
        int options = 1;
        boolean bl = isField = JSUtils.getMemberContainingClass((PsiElement)jsVariable) != null;
        if (includeParent && isField) {
            options |= 0x1000;
        }
        String name = JSFormatUtil.formatField((JSTypeDeclarationOwner)jsVariable, options, parentClassOverride);
        if (htmlEmphasize) {
            name = StringUtil.htmlEmphasize((String)name);
        }
        if (isField) {
            return JSBundle.message((String)(jsVariable.isConst() ? "constant.description" : "field.description"), (Object[])new Object[]{name});
        }
        if (includeParent) {
            JSClass clazz;
            JSClass jSClass = clazz = parentClassOverride != null ? parentClassOverride : JSResolveUtil.getClassOfContext((PsiElement)jsVariable);
            if (clazz != null) {
                String className = JSFormatUtil.formatClass(clazz, 1);
                if (htmlEmphasize) {
                    className = StringUtil.htmlEmphasize((String)className);
                }
                return JSBundle.message((String)(jsVariable.isConst() ? "constant.in.class.description" : "variable.in.class.description"), (Object[])new Object[]{name, className});
            }
        }
        String key = jsVariable instanceof JSParameter ? "parameter.description" : (ActionScriptResolveUtil.isFileLocalSymbol((PsiElement)jsVariable) ? (jsVariable.isConst() ? "inner.constant.description" : "inner.variable.description") : (jsVariable.isConst() ? "constant.description" : "variable.description"));
        return JSBundle.message((String)key, (Object[])new Object[]{name});
    }

    public static String formatPackage(String packageName) {
        return packageName.length() > 0 ? JSBundle.message((String)"package.description", (Object[])new Object[]{packageName}) : JSBundle.message((String)"top.level.package", (Object[])new Object[0]);
    }

    public static PsiElement findInsertionPlaceStartingFrom(PsiElement anchor, boolean skipFirstWs, Function<PsiElement, Boolean> skipFilter) {
        block3: {
            PsiElement anchorNextSibling;
            if (skipFirstWs && anchor instanceof PsiWhiteSpace && ((Boolean)skipFilter.fun((Object)(anchorNextSibling = anchor.getNextSibling()))).booleanValue()) {
                anchor = anchorNextSibling;
            }
            while (true) {
                PsiElement nextSibling;
                if ((nextSibling = (anchorNextSibling = anchor.getNextSibling())) instanceof PsiWhiteSpace) {
                    nextSibling = nextSibling.getNextSibling();
                }
                if (!((Boolean)skipFilter.fun((Object)nextSibling)).booleanValue()) break;
                anchor = nextSibling;
            }
            if (anchorNextSibling == null) break block3;
            anchor = anchorNextSibling;
        }
        return anchor;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 7: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 20: 
            case 22: 
            case 26: 
            case 27: 
            case 28: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 7: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 20: 
            case 22: 
            case 26: 
            case 27: 
            case 28: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 7: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 20: 
            case 22: 
            case 26: 
            case 27: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/ui/JSFormatUtil";
                break;
            }
            case 4: 
            case 6: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "field";
                break;
            }
            case 8: 
            case 11: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "member";
                break;
            }
            case 9: 
            case 17: 
            case 19: 
            case 21: 
            case 24: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/ui/JSFormatUtil";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "formatClass";
                break;
            }
            case 5: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "formatField";
                break;
            }
            case 10: 
            case 18: 
            case 20: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "formatMethod";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "formatTypeMember";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getType";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "formatType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "formatClass";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 7: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 20: 
            case 22: 
            case 26: 
            case 27: 
            case 28: {
                break;
            }
            case 4: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "formatField";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "formatMember";
                break;
            }
            case 9: 
            case 17: 
            case 19: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "formatMethod";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "formatTypeMember";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "formatIndexSignature";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getReturnType";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getType";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "getPropertyIcon";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "formatVisibility";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 7: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 20: 
            case 22: 
            case 26: 
            case 27: 
            case 28: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

