/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.validation.fixes;

import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.javascript.flex.ImportUtils;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.util.JSClassUtils;
import com.intellij.lang.javascript.validation.fixes.BaseCreateFix;
import com.intellij.lang.javascript.validation.fixes.FixAndIntentionAction;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import org.jetbrains.annotations.NotNull;

public class JSInsertCastFix
extends FixAndIntentionAction {
    private final String type;
    @NotNull
    private DialectOptionHolder myDialectHolder;

    public JSInsertCastFix(String type, @NotNull DialectOptionHolder holder) {
        if (holder == null) {
            JSInsertCastFix.$$$reportNull$$$0(0);
        }
        this.type = type;
        this.myDialectHolder = holder;
    }

    @NotNull
    public String getName() {
        String key = this.myDialectHolder.isTypeScript ? "typescript.insert.cast.fix" : "javascript.insert.cast.fix";
        String string = JSBundle.message((String)key, (Object[])new Object[0]);
        if (string == null) {
            JSInsertCastFix.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    protected boolean isAvailable(Project project, PsiElement element, Editor editor, PsiFile file) {
        String shortestTypeName;
        if (element instanceof JSLiteralExpression) {
            JSLiteralExpression literalExpression = (JSLiteralExpression)element;
            String literalType = JSResolveUtil.getExpressionType((JSExpression)literalExpression, element.getContainingFile());
            if (JSInsertCastFix.isNumericType(this.type) && "String".equals(literalType)) {
                return JSInsertCastFix.isValidNumber(StringUtil.unquoteString((String)literalExpression.getText()));
            }
        }
        return !this.myDialectHolder.isTypeScript || !TypeScriptUtil.hasAmbientExternalModuleInQName(this.type) || !TypeScriptUtil.hasAmbientExternalModuleInQName(shortestTypeName = this.getShortestType(element));
    }

    private static boolean isValidNumber(String text) {
        try {
            if (text.startsWith("0x") || text.startsWith("0X")) {
                Integer.parseInt(text.substring(2), 16);
            } else if (text.startsWith("0")) {
                Integer.parseInt(text, 8);
            } else {
                Double.parseDouble(text);
            }
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    @Override
    protected void applyFix(Project project, PsiElement element, PsiFile file, Editor editor) {
        if (editor == null) {
            editor = BaseCreateFix.getEditor(project, element.getContainingFile());
        }
        if (editor == null) {
            return;
        }
        SmartPsiElementPointer p = SmartPointerManager.getInstance((Project)project).createSmartPsiElementPointer(element);
        String shortenedType = this.getShortestType(element);
        element = p.getElement();
        if (element == null) {
            return;
        }
        if (element instanceof JSLiteralExpression) {
            JSLiteralExpression literalExpression = (JSLiteralExpression)element;
            String literalType = JSResolveUtil.getExpressionType((JSExpression)literalExpression, element.getContainingFile());
            String text = literalExpression.getText();
            if ("String".equals(shortenedType) && JSInsertCastFix.isNumericType(literalType)) {
                JSInsertCastFix.replaceElementWithText(project, element, "\"" + text + "\"");
                return;
            }
            if (JSInsertCastFix.isNumericType(shortenedType) && "String".equals(literalType)) {
                if (JSInsertCastFix.isValidNumber(text = StringUtil.unquoteString((String)text))) {
                    JSInsertCastFix.replaceElementWithText(project, element, text);
                }
                return;
            }
        }
        TemplateManager templateManager = TemplateManager.getInstance((Project)project);
        Template template = templateManager.createTemplate("", "", JSClassUtils.getCast(shortenedType, "$SELECTION$", this.myDialectHolder));
        template.setToReformat(true);
        template.setToShortenLongNames(false);
        int offset = element.getTextRange().getStartOffset();
        editor.getSelectionModel().setSelection(offset, offset + element.getTextLength());
        editor.getCaretModel().moveToOffset(offset);
        templateManager.startTemplate(editor, element.getText(), template);
    }

    private static boolean isNumericType(String literalType) {
        return "Number".equals(literalType) || "int".equals(literalType) || "uint".equals(literalType);
    }

    private static void replaceElementWithText(Project project, PsiElement element, String replacement) {
        WriteAction.run(() -> element.replace(JSChangeUtil.createExpressionFromText(project, replacement).getPsi()));
    }

    @Override
    public boolean startInWriteAction() {
        return true;
    }

    private String getShortestType(@NotNull PsiElement context) {
        if (context == null) {
            JSInsertCastFix.$$$reportNull$$$0(2);
        }
        if (this.myDialectHolder.isTypeScript && this.type != null) {
            return TypeScriptUtil.getShortestTypeNameInContext(this.type, context);
        }
        return (String)ImportUtils.importAndShortenReference((String)this.type, (PsiElement)context, (boolean)true, (boolean)true).first;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/validation/fixes/JSInsertCastFix";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/validation/fixes/JSInsertCastFix";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getShortestType";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

