/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.compiler.languageService;

import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.lang.javascript.service.JSLanguageServiceAnnotationResult;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptLanguageServiceAnnotationResult
extends JSLanguageServiceAnnotationResult {
    public static final int CANNOT_FIND_NAME_CODE = 2304;
    private final int myErrorCode;
    @Nullable
    private final String mySource;

    public TypeScriptLanguageServiceAnnotationResult(@NotNull String errorText, @Nullable String fileAbsolutePath) {
        if (errorText == null) {
            TypeScriptLanguageServiceAnnotationResult.$$$reportNull$$$0(0);
        }
        this(errorText, fileAbsolutePath, "error", null, null, -1, 0, 0, 0, 0);
    }

    public TypeScriptLanguageServiceAnnotationResult(@NotNull String errorText, @Nullable String fileAbsolutePath, @Nullable String category, @Nullable String source, @Nullable String tooltipText, int errorCode, int line, int column, int lineEnd, int columnEnd) {
        if (errorText == null) {
            TypeScriptLanguageServiceAnnotationResult.$$$reportNull$$$0(1);
        }
        super(errorText, tooltipText, fileAbsolutePath, category, line, column, lineEnd, columnEnd);
        this.myErrorCode = errorCode == -1 ? TypeScriptLanguageServiceAnnotationResult.getErrorCodeImpl(errorText) : errorCode;
        this.mySource = source;
    }

    public int getErrorCode() {
        return this.myErrorCode;
    }

    @Override
    @NotNull
    public String getDescription() {
        String string = this.getTextWithSourcePrefix(super.getDescription());
        if (string == null) {
            TypeScriptLanguageServiceAnnotationResult.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    @Nullable
    public String getTooltipText() {
        String tooltipText = super.getTooltipText();
        if (tooltipText == null) {
            return null;
        }
        return this.getTextWithSourcePrefix(tooltipText);
    }

    @NotNull
    private String getTextWithSourcePrefix(@NotNull String text) {
        if (text == null) {
            TypeScriptLanguageServiceAnnotationResult.$$$reportNull$$$0(3);
        }
        if (this.mySource != null) {
            String string = this.mySource + ": " + text;
            if (string == null) {
                TypeScriptLanguageServiceAnnotationResult.$$$reportNull$$$0(4);
            }
            return string;
        }
        String string = text.startsWith("TS") || this.myErrorCode <= 0 ? text : "TS" + this.myErrorCode + ": " + text;
        if (string == null) {
            TypeScriptLanguageServiceAnnotationResult.$$$reportNull$$$0(5);
        }
        return string;
    }

    private static int getErrorCodeImpl(String myErrorText) {
        String prefix = "TS";
        if (myErrorText.startsWith(prefix)) {
            int endCode = myErrorText.indexOf(":");
            if (endCode == -1) {
                return -1;
            }
            String code = myErrorText.substring(prefix.length(), endCode);
            try {
                return Integer.valueOf(code.trim());
            }
            catch (Exception e) {
                return -1;
            }
        }
        return -1;
    }

    @Override
    public ProblemHighlightType getHighlightType() {
        int code = this.getErrorCode();
        if (code != -1 && 2304 == code) {
            return ProblemHighlightType.LIKE_UNKNOWN_SYMBOL;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errorText";
                break;
            }
            case 2: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/typescript/compiler/languageService/TypeScriptLanguageServiceAnnotationResult";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/typescript/compiler/languageService/TypeScriptLanguageServiceAnnotationResult";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getDescription";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getTextWithSourcePrefix";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 4: 
            case 5: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getTextWithSourcePrefix";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

